<?php
/**
 * Class TemplatesTrait
 *
 * @package  Conexa\ClipTransparent\Helper\TemplatesTrait
 */

namespace Conexa\ClipTransparent\Includes\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Templates Trait
 */
trait TemplatesTrait {

	/**
	 * Get Template Part
	 *
	 * @param string $slug slug value.
	 * @param string $name name value.
	 * @param array  $args arguments.
	 */
	public static function get_template_part( $slug, $name = null, $args = array() ) {

		/**
		 * Clip transparent get template part hook.
		 *
		 * @since 0.0.1.
		 */
		do_action( "clip_transparent_get_template_part_{$slug}", $slug, $name, $args );
		$templates = array();
		if ( isset( $name ) ) {
			$templates[] = "{$slug}-{$name}.php";
		}

		$templates[] = "{$slug}.php";

		self::get_template_path( $templates, true, false, $args );
	}

	/**
	 * Get Template Path & Load
	 *
	 * @param string $template_names template names.
	 * @param bool   $load load.
	 * @param bool   $require_once_value require once parameter.
	 * @param array  $args arguments.
	 *
	 *  @return string
	 */
	public static function get_template_path( $template_names, $load = false, $require_once_value = true, $args = array() ) {
		$located = '';
		foreach ( (array) $template_names as $template_name ) {
			if ( ! $template_name ) {
				continue;
			}
			// search file within the PLUGIN_DIR_PATH only.
			if ( file_exists( \ClipTransparent::CLIPTRANSP_MAIN_DIR . '/templates/' . $template_name ) ) {
				$located = \ClipTransparent::CLIPTRANSP_MAIN_DIR . '/templates/' . $template_name;
				break;
			}
		}

		if ( $load && '' !== $located ) {
			load_template( $located, $require_once_value, $args );
		}
		return $located;
	}
}
