<?php
/**
 * Class SettingsTrait
 *
 * @package  Conexa\ClipTransparent\Helper\SettingsTrait
 */

namespace Conexa\ClipTransparent\Includes\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Settings Trait
 */
trait SettingsTrait {

	/**
	 * Gets a plugin option
	 *
	 * @param string  $key Key value searching for.
	 * @param boolean $default_value A dafault value in case Key is not founded.
	 *
	 * @return mixed
	 */
	public static function get_option( string $key, $default_value = false ) {
		return isset( self::get_options()[ $key ] ) &&
			! empty( self::get_options()[ $key ] )
			? self::get_options()[ $key ]
			: $default_value;
	}

	/**
	 * Get options
	 *
	 * @param string $gateway Gateway Name.
	 *
	 * @return Array
	 */
	public static function get_options( $gateway = 'wc_clip_transparent' ) {
		$option = get_option( 'woocommerce_' . $gateway . '_settings' );

		return array(

			'enabled'        => isset( $option['enabled'] ) ? $option['enabled'] : 'no',

            'title'          => isset( $option['title'] ) ? $option['title'] : __( 'Pay with Clip Transparent', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),

            'description'    => isset( $option['description'] ) ? $option['description'] : __( 'Accept payments using Clip Transparent.', 'clip-mexico-payments-for-ecommerce-transparent-checkout' ),

			'api_key'        => isset( $option['wc_clip_transparent_api_key'] )
				? $option['wc_clip_transparent_api_key']
				: '',

			'api_secret'     => isset( $option['wc_clip_transparent_api_secret'] )
				? $option['wc_clip_transparent_api_secret']
				: '',

			'theme_options'  => isset( $option['wc_clip_transparent_theme_options'] )
			? $option['wc_clip_transparent_theme_options']
			: 'default',

			'locale_options' => isset( $option['wc_clip_transparent_locale_options'] )
			? $option['wc_clip_transparent_locale_options']
			: 'en',

			'3ds'            => isset( $option['wc_clip_transparent_3ds_enabled'] )
				? $option['wc_clip_transparent_3ds_enabled']
				: 'yes',

			'debug'          => isset( $option['wc_clip_transparent_log_enabled'] )
				? $option['wc_clip_transparent_log_enabled']
				: 'yes',
		);
	}

	/**
	 * Set options
	 *
	 * @param string $key Key value searching for.
	 * @param string $value A value to be setted.
	 * @param string $gateway Gateway Name.
	 */
	public static function set_option( string $key, string $value, string $gateway = 'wc_clip_transparent' ) {
		$option                                 = get_option( 'woocommerce_' . $gateway . '_settings' );
		$option[ 'wc_clip_transparent_' . $key ] = $value;
		update_option( 'woocommerce_' . $gateway . '_settings', $option );
	}
}
