<?php
/**
 * Class Clip Transparent Api
 *
 * @package  Conexa\ClipTransparent\Includes\Api;
 */

namespace Conexa\ClipTransparent\Includes\Api;

defined( 'ABSPATH' ) || exit;

use Conexa\ClipTransparent\Includes\Helper\Helper;

/**
 * API Interface Class
 */
interface ApiInterface {
	/**
	 * Executes Get Request
	 *
	 * @param string $endpoint Endpoint Url.
	 * @param array  $body query params.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function get( string $endpoint, array $body = array(), array $headers = array() );
	/**
	 * Executes Post Request
	 *
	 * @param string $endpoint Endpoint Url.
	 * @param array  $body Body to send data.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function post( string $endpoint, array $body = array(), array $headers = array() );
	/**
	 * Executes Put Request
	 *
	 * @param string $endpoint Endpoint Url.
	 * @param array  $body Body to send data.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function put( string $endpoint, array $body = array(), array $headers = array() );
	/**
	 * Executes Deletes Request
	 *
	 * @param string $endpoint Endpoint Url.
	 * @param array  $body Body to send data.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function delete( string $endpoint, array $body = array(), array $headers = array() );
}
