<?php
/**
 * Class Clip Transparent Api
 *
 * @package  Conexa\ClipTransparent\Includes\Api;
 */

namespace Conexa\ClipTransparent\Includes\Api;

defined( 'ABSPATH' ) || exit;

use Conexa\ClipTransparent\Includes\Helper\Helper;

/**
 * Abstract API Class
 */
abstract class ApiConnector {
	/**
	 * Executes API Request
	 *
	 * @param string $method Http Method Post|Get|Put|Delete.
	 * @param string $url Url.
	 * @param array  $body Body to send or Query Params for Get.
	 * @param array  $headers Headers includes on request.
	 * @param string $data data for testing purpouses.
	 * @return string
	 */
	public function exec( string $method, string $url, array $body, array $headers, string $data = null ) {

		$args['timeout'] = 10;
		$args['method']  = $method;
		$args['headers'] = $headers;
		if ( 'GET' === strtoupper( $method ) ) {
			$args['body'] = $body;
		} else {
			$args['body'] = wp_json_encode( $body, JSON_UNESCAPED_UNICODE );
		}

		$request = wp_safe_remote_request( $url, $args );
		Helper::log( '==============================================>' );
		Helper::log( $url );
		Helper::log( $headers );
		Helper::log( 'Request > ' );
		Helper::log( wp_json_encode( $body, JSON_UNESCAPED_UNICODE ) );

		if ( 'error1' === $data ) {
			$request['response']['code'] = 200;
		}

		if ( is_wp_error( $request ) || 'error2' === $data ) {
			Helper::log( 'ERROR' );
			Helper::log( $request );
			return false;
		}

		$response = wp_remote_retrieve_body( $request );
		Helper::log( 'Response Code > ' . $request['response']['code'] );
		Helper::log( 'Response > ' );
		Helper::log( $response );

		if ( 200 === $request['response']['code'] || 201 === $request['response']['code'] ) {
			return json_decode( $response, true );
		} else {
			return array( 'errors' => json_decode( $response, true ) );
		}
	}

	/**
	 * Executes Post Request
	 *
	 * @param string $url Endpoint Url.
	 * @param array  $body Body to send data.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function post( string $url, array $body = array(), array $headers = array() ) {
		return $this->exec( 'POST', $url, $body, $headers );
	}


	/**
	 * Executes Get Request
	 *
	 * @param string $url Endpoint Url.
	 * @param array  $body Query params.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function get( string $url, array $body = array(), array $headers = array() ) {
		if ( ! empty( $body ) ) {
			$url .= '?' . http_build_query( $body );
		}
		return $this->exec( 'GET', $url, array(), $headers );
	}

	/**
	 * Executes Put Request
	 *
	 * @param string $url Endpoint Url.
	 * @param array  $body Body to send data.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function put( string $url, array $body = array(), array $headers = array() ) {
		return $this->exec( 'PUT', $url, $body, $headers );
	}

	/**
	 * Executes Delete Request
	 *
	 * @param string $url Endpoint Url.
	 * @param array  $body Body to send data.
	 * @param array  $headers Headers to include in requests.
	 * @return string
	 */
	public function delete( string $url, array $body = array(), array $headers = array() ) {
		return $this->exec( 'DELETE', $url, $body, $headers );
	}

	/**
	 * Add Get Params to URL
	 *
	 * @param string $url Url.
	 * @param array  $params Params to convert in query string.
	 * @return string
	 */
	public function add_params_to_url( $url, $params ) {
		if ( strpos( $url, '?' ) !== false ) {
			$url .= '&' . $params;
		} else {
			$url .= '?' . $params;
		}
		return $url;
	}
}
