//if(clip_transparent_object.mode === 'stage') 
console.log("Init Clip Payment SDK");

jQuery(document).ready( function( $ ) {
    const ClipPaymentMethodId = 'wc_clip_transparent';
    const ClipPaymentMethod = 'payment_method_' + ClipPaymentMethodId;
    const ClipPaymentButtonId = 'clip-payment-button';
    const ClipCardWrapperId = 'clip_transparent_card-element';
    var checkout_form;
    var submitButton;
    var clonedButton;
    var ClipCard;
    let mutexForDisplayCard = false;    

    function isClipPaymentMethodSelected(){
        return $('#'+ClipPaymentMethod).prop('checked');
    }


    async function tokenizeCard(){
        if (isClipPaymentMethodSelected()) {
            try {
                const cardTokenPromise = ClipCard.cardToken();
                const installments = await ClipCard.installments();
                const preventionData = await ClipCard.preventionData();
    
                const timeoutPromise = new Promise((resolve, reject) => {
                    setTimeout(() => reject(new Error('Tiempo de espera excedido')), 10000);
                });
                const cardToken = await Promise.race([cardTokenPromise, timeoutPromise]);
    
                //if(clip_transparent_object.mode === 'stage') 
                console.log("card token generado");
    
                $("#clip_transparent_cardtoken").val( cardToken.id );
                $("#clip_transparent_installments").val( installments );
                $("#clip_transparent_prevention").val( Object.values(preventionData) );                           
    
            } catch (error) {    
                console.log(error);                 
            }
        }
        
    }   
    function clipPaymentButton(){
        console.log('Botón de pago Clip presionado');
        if (isClipPaymentMethodSelected()) {
            tokenizeCard().finally(() => {
                console.log("tokenizado listo");
                submitButton.click();
                clonedButton.prop('disabled', false);
            });
        } else {
            submitButton.click();
            clonedButton.prop('disabled', false);
        }
    }

    function wrappSubmitButton(){
        checkout_form = $('form.checkout');
        submitButton = checkout_form.find('button[type="submit"]');
        submitButton = checkout_form.find('button[type="submit"]#place_order');

        if(clip_transparent_object.mode === 'stage'){
            console.log('[Clip] Submit button found:', submitButton.get(0));
        }

        // Clonar el botón original
        clonedButton = submitButton.clone();        
        clonedButton.attr('id', ClipPaymentButtonId);      
        clonedButton.addClass(ClipPaymentButtonId);        
        clonedButton.attr('type', 'button');

        // Insertar el botón clonado al lado del botón original
        submitButton.after(clonedButton);
        
        // Ocultar el botón original (opcional)
        submitButton.hide();               

        clonedButton.on('click', function(){
            clonedButton.prop('disabled', true);
            clipPaymentButton();
        });
    }

    function clipCardMount(price){        
        //if(clip_transparent_object.mode === 'stage') 
        console.log("Clip Card Mount");
        var clipSdk;
        if(clip_transparent_object.mode === 'stage'){
            clipSdk = new ClipSDK(clip_transparent_object.api_key, {
                env: "dev"
            }); 
        } else {
            clipSdk = new ClipSDK(clip_transparent_object.api_key, {});
        }
        
        ClipCard = clipSdk.element.create( "Card", { // Asignar a la variable card
            theme: clip_transparent_object.theme_options,
            locale: clip_transparent_object.locale_options,
            paymentAmount: price,
            terms: {
                enabled: true
            }
        });

        $('.' + ClipPaymentMethodId + ' #' + ClipCardWrapperId).each(function() {                      
            $(this).find('iframe').remove();
        });
        ClipCard.mount(ClipCardWrapperId);
    }

    async function displayClipCard(){
        //if(clip_transparent_object.mode === 'stage') 
        console.log("Display Clip Card");
        
        $('.'+ClipPaymentMethod+' #'+ClipCardWrapperId).each(function() {               
            $(this).find('iframe').remove();
        });
        var dataToSend = {
            action: "clip_transparent_cart_total",
            nonce: clip_transparent_object.nonce,
        }
        jQuery.post(clip_transparent_object.admin_ajax, dataToSend, function(response) {
            if (response.success) {               
                clipCardMount(response.data);
            }
        });
        
    }

    function runDisplayClipCard() {
        if (mutexForDisplayCard) {
            console.log("Verificación en progreso, esperando...");
            return;
        }

        mutexForDisplayCard = true;
        displayClipCard().finally(() => {
            mutexForDisplayCard = false;
        });
    }   

    jQuery('body').on('updated_checkout', function(){
        console.log('updated_checkout triggered');
        wrappSubmitButton();
        runDisplayClipCard();
    });
   
});

