<?php
/**
* Plugin Name: CleverConnected User Role by Subscription
* Plugin URI: https://cleverconnected.nl/
* Description: This plug-in connects the subscribers data to your WordPress-accounts.
* Version: 1.32
* Author: Ambition4Clients B.V.
* Author URI: https://ambition4clients.nl/
* Text Domain: cleverconnected_subscriptions
* Domain Path: /languages
**/

if( !defined( 'ABSPATH' ) ) exit;

// Settings
function a4c_cc_add_settings_page() {
    add_options_page( 'CleverConnected User Role', 'CleverConnected User Role', 'manage_options', 'cc-plugin', 'a4c_cc_render_plugin_settings_page' );
}
add_action( 'admin_menu', 'a4c_cc_add_settings_page' );

function a4c_cc_render_plugin_settings_page() {
    ?>
    <h2><strong>CleverConnected User Roles by Subscription > setup</strong></h2>
    <form action="options.php" method="post">
    <?php 
        settings_fields( 'a4c_cc_plugin_options' );
        do_settings_sections( 'a4c_cc_plugin' ); ?>
        <input name="submit" class="button button-primary" type="submit" value="<?php esc_attr_e( 'Save' ); ?>" />
    </form>
    <?php
}

function a4c_cc_plugin_section_text() {
    echo '<p>Setup yor account by entering the API key and endpoint URL.</p>';
    echo '<p><strong>Warning!</strong> Custom roles must be set according to the provided documentation before this plug-in can be activated.</p>';	
}

function a4c_cc_plugin_setting_api_url() {
	$options = get_option( 'a4c_cc_plugin_options' );
	if(is_array($options)) {
		$api_url = esc_attr($options['a4c_cc_plugin_setting_api_url']);
	} else {
		$api_url = '';
	}
	
    echo "<input id='a4c_cc_plugin_setting_api_url' name='a4c_cc_plugin_options[a4c_cc_plugin_setting_api_url]' type='text' value='" . esc_attr($api_url) . "' />";
}
function a4c_cc_plugin_setting_api_key() {
	$options = get_option( 'a4c_cc_plugin_options' );
	if(is_array($options)) {
		$api_key = esc_attr($options['a4c_cc_plugin_setting_api_key']);
	} else {
		$api_key = '';
	}

	echo "<input id='a4c_cc_plugin_setting_api_key' name='a4c_cc_plugin_options[a4c_cc_plugin_setting_api_key]' type='password' value='" . esc_attr($api_key) ."' />";
}

function a4c_cc_register_settings() {
    register_setting( 'a4c_cc_plugin_options', 'a4c_cc_plugin_options', 'a4c_cc_plugin_options_validate' );
    add_settings_section( 'api_settings', 'API authentication', 'a4c_cc_plugin_section_text', 'a4c_cc_plugin' );
	add_settings_field( 'a4c_cc_plugin_setting_api_url', 'API URL', 'a4c_cc_plugin_setting_api_url', 'a4c_cc_plugin', 'api_settings' );
	add_settings_field( 'a4c_cc_plugin_setting_api_key', 'API Key', 'a4c_cc_plugin_setting_api_key', 'a4c_cc_plugin', 'api_settings' );	
}
add_action( 'admin_init', 'a4c_cc_register_settings' );

function a4c_cc_get_roles($user_login, $user){
	
	$user->remove_role( 'digital' );
	$user->remove_role( 'full' );		
	$user->remove_role( 'trial' );
	$user->remove_role( 'lid' );
	$user->remove_role( 'uitsupporter' );		
	$user->remove_role( 'loyaal' );

	$options = get_option( 'a4c_cc_plugin_options' );
	$api_key = esc_attr($options['a4c_cc_plugin_setting_api_key']);
	$api_url = esc_attr($options['a4c_cc_plugin_setting_api_url']);		

	$uid = $user->ID;
	$email = $user->user_email;
	$domein = getenv('HTTP_HOST');

	$data = array(
		'access_token' => $api_key,
		'domain' => $domein,
		'external_id' => $uid,
		'email' => $email
	);

	$args = array(
		'body'        => json_encode($data),
		'timeout'     => '5',
		'redirection' => '5',
		'httpversion' => '1.0',
		'blocking'    => true,
		'headers'     => array('Content-Type' => 'application/json; charset=utf-8'),
		'cookies'     => array(),
	);	

	$response = wp_remote_post( $api_url, $args );
	if (!$response or !is_array($response)){
		error_log($response);
	}
	else {
		$response_code = wp_remote_retrieve_response_code($response);
		
		// Alleen doorgaan als de response code succesvol is (200-299)
		if ($response_code >= 200 && $response_code < 300) {
			$responseData = json_decode(wp_remote_retrieve_body($response), true);

			// Controleren of responseData een array is en niet leeg
			if (is_array($responseData) && !empty($responseData)) {
				foreach( $responseData as $role ) {
					// Controleren of de role array de verwachte structuur heeft
					if (is_array($role) && isset($role['ROL'])) {
						$user->add_role( $role['ROL'] );
					}
				}
			}
		} else {
			// Log error als de API een niet-succesvolle response geeft
			error_log('CleverConnected API error: HTTP ' . $response_code . ' - ' . wp_remote_retrieve_body($response));
		}
	}
}

add_action( 'wp_login' , 'a4c_cc_get_roles' ,10,2);
