<?php
/**
 * WooCommerce Dependency Check
 *
 * @package ClearCartOnLogoutForWooCommerce
 */

if (!defined('ABSPATH')) {
   exit; // Exit if accessed directly
}

/**
 * Deactivate the plugin if WooCommerce is not active.
 */
add_action( 'admin_init', 'clctolfw_check_woocommerce_dependency' );

function clctolfw_check_woocommerce_dependency() {
	if ( ! class_exists( 'WooCommerce' ) ) {
		deactivate_plugins( plugin_basename( __FILE__ ) );
		add_action( 'admin_notices', 'clctolfw_show_wc_missing_notice' );
	}
}

/**
 * Show an admin error notice when WooCommerce is missing.
 */
function clctolfw_show_wc_missing_notice() {
	?>
	<div class="notice notice-error is-dismissible">
		<p><?php esc_html_e( 'Clear Cart on Logout for WooCommerce requires WooCommerce to be installed and activated.', 'clear-cart-on-logout-for-woocommerce' ); ?></p>
	</div>
	<?php
}