<?php
/**
 * Clear Cart on Logout Logic
 *
 * Handles clearing WooCommerce cart items and persistent carts when a logged-in user logs out.
 *
 * @package ClearCartOnLogoutForWooCommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Clears the WooCommerce cart and persistent cart for the current user when they log out.
 */
add_action( 'clear_auth_cookie', 'clctolfw_clear_cart_on_logout' );

function clctolfw_clear_cart_on_logout() {
    if ( is_user_logged_in() ) {
        $user_id = get_current_user_id();

        if ( $user_id ) {
            delete_user_meta( $user_id, '_woocommerce_persistent_cart_' . get_current_blog_id() );
        }
    }

    if ( function_exists( 'WC' ) && WC()->cart ) {
        WC()->cart->empty_cart();
    }
}