<?php
/**
 * States
 *
 * Returns an array of country states. This deprecates and replaces the /states/ directory found in older versions.
 * States should be defined in English and translated native through localisation files.
 * Country codes and states (or province) names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/country-names).
 * Countries defined with empty arrays have no states.
 *
 * @package ClassifiedListing\i18n
 * @version 3.8.0
 */

defined( 'ABSPATH' ) || exit;

return array(
	'AF' => array(),
	'AL' => array( // Albania states.
		'AL-01' => __( 'Berat', 'classified-listing' ),
		'AL-09' => __( 'Dibër', 'classified-listing' ),
		'AL-02' => __( 'Durrës', 'classified-listing' ),
		'AL-03' => __( 'Elbasan', 'classified-listing' ),
		'AL-04' => __( 'Fier', 'classified-listing' ),
		'AL-05' => __( 'Gjirokastër', 'classified-listing' ),
		'AL-06' => __( 'Korçë', 'classified-listing' ),
		'AL-07' => __( 'Kukës', 'classified-listing' ),
		'AL-08' => __( 'Lezhë', 'classified-listing' ),
		'AL-10' => __( 'Shkodër', 'classified-listing' ),
		'AL-11' => __( 'Tirana', 'classified-listing' ),
		'AL-12' => __( 'Vlorë', 'classified-listing' ),
	),
	'AO' => array( // Angola states.
		'BGO' => __( 'Bengo', 'classified-listing' ),
		'BLU' => __( 'Benguela', 'classified-listing' ),
		'BIE' => __( 'Bié', 'classified-listing' ),
		'CAB' => __( 'Cabinda', 'classified-listing' ),
		'CNN' => __( 'Cunene', 'classified-listing' ),
		'HUA' => __( 'Huambo', 'classified-listing' ),
		'HUI' => __( 'Huíla', 'classified-listing' ),
		'CCU' => __( 'Kuando Kubango', 'classified-listing' ),
		'CNO' => __( 'Kwanza-Norte', 'classified-listing' ),
		'CUS' => __( 'Kwanza-Sul', 'classified-listing' ),
		'LUA' => __( 'Luanda', 'classified-listing' ),
		'LNO' => __( 'Lunda-Norte', 'classified-listing' ),
		'LSU' => __( 'Lunda-Sul', 'classified-listing' ),
		'MAL' => __( 'Malanje', 'classified-listing' ),
		'MOX' => __( 'Moxico', 'classified-listing' ),
		'NAM' => __( 'Namibe', 'classified-listing' ),
		'UIG' => __( 'Uíge', 'classified-listing' ),
		'ZAI' => __( 'Zaire', 'classified-listing' ),
	),
	'AR' => array( // Argentinian provinces.
		'C' => __( 'Ciudad Autónoma de Buenos Aires', 'classified-listing' ),
		'B' => __( 'Buenos Aires', 'classified-listing' ),
		'K' => __( 'Catamarca', 'classified-listing' ),
		'H' => __( 'Chaco', 'classified-listing' ),
		'U' => __( 'Chubut', 'classified-listing' ),
		'X' => __( 'Córdoba', 'classified-listing' ),
		'W' => __( 'Corrientes', 'classified-listing' ),
		'E' => __( 'Entre Ríos', 'classified-listing' ),
		'P' => __( 'Formosa', 'classified-listing' ),
		'Y' => __( 'Jujuy', 'classified-listing' ),
		'L' => __( 'La Pampa', 'classified-listing' ),
		'F' => __( 'La Rioja', 'classified-listing' ),
		'M' => __( 'Mendoza', 'classified-listing' ),
		'N' => __( 'Misiones', 'classified-listing' ),
		'Q' => __( 'Neuquén', 'classified-listing' ),
		'R' => __( 'Río Negro', 'classified-listing' ),
		'A' => __( 'Salta', 'classified-listing' ),
		'J' => __( 'San Juan', 'classified-listing' ),
		'D' => __( 'San Luis', 'classified-listing' ),
		'Z' => __( 'Santa Cruz', 'classified-listing' ),
		'S' => __( 'Santa Fe', 'classified-listing' ),
		'G' => __( 'Santiago del Estero', 'classified-listing' ),
		'V' => __( 'Tierra del Fuego', 'classified-listing' ),
		'T' => __( 'Tucumán', 'classified-listing' ),
	),
	'AT' => array(),
	'AU' => array( // Australian states.
		'ACT' => __( 'Australian Capital Territory', 'classified-listing' ),
		'NSW' => __( 'New South Wales', 'classified-listing' ),
		'NT'  => __( 'Northern Territory', 'classified-listing' ),
		'QLD' => __( 'Queensland', 'classified-listing' ),
		'SA'  => __( 'South Australia', 'classified-listing' ),
		'TAS' => __( 'Tasmania', 'classified-listing' ),
		'VIC' => __( 'Victoria', 'classified-listing' ),
		'WA'  => __( 'Western Australia', 'classified-listing' ),
	),
	'AX' => array(),
	'BD' => array( // Bangladeshi states (districts).
		'BD-05' => __( 'Bagerhat', 'classified-listing' ),
		'BD-01' => __( 'Bandarban', 'classified-listing' ),
		'BD-02' => __( 'Barguna', 'classified-listing' ),
		'BD-06' => __( 'Barishal', 'classified-listing' ),
		'BD-07' => __( 'Bhola', 'classified-listing' ),
		'BD-03' => __( 'Bogura', 'classified-listing' ),
		'BD-04' => __( 'Brahmanbaria', 'classified-listing' ),
		'BD-09' => __( 'Chandpur', 'classified-listing' ),
		'BD-10' => __( 'Chattogram', 'classified-listing' ),
		'BD-12' => __( 'Chuadanga', 'classified-listing' ),
		'BD-11' => __( "Cox's Bazar", 'classified-listing' ),
		'BD-08' => __( 'Cumilla', 'classified-listing' ),
		'BD-13' => __( 'Dhaka', 'classified-listing' ),
		'BD-14' => __( 'Dinajpur', 'classified-listing' ),
		'BD-15' => __( 'Faridpur ', 'classified-listing' ),
		'BD-16' => __( 'Feni', 'classified-listing' ),
		'BD-19' => __( 'Gaibandha', 'classified-listing' ),
		'BD-18' => __( 'Gazipur', 'classified-listing' ),
		'BD-17' => __( 'Gopalganj', 'classified-listing' ),
		'BD-20' => __( 'Habiganj', 'classified-listing' ),
		'BD-21' => __( 'Jamalpur', 'classified-listing' ),
		'BD-22' => __( 'Jashore', 'classified-listing' ),
		'BD-25' => __( 'Jhalokati', 'classified-listing' ),
		'BD-23' => __( 'Jhenaidah', 'classified-listing' ),
		'BD-24' => __( 'Joypurhat', 'classified-listing' ),
		'BD-29' => __( 'Khagrachhari', 'classified-listing' ),
		'BD-27' => __( 'Khulna', 'classified-listing' ),
		'BD-26' => __( 'Kishoreganj', 'classified-listing' ),
		'BD-28' => __( 'Kurigram', 'classified-listing' ),
		'BD-30' => __( 'Kushtia', 'classified-listing' ),
		'BD-31' => __( 'Lakshmipur', 'classified-listing' ),
		'BD-32' => __( 'Lalmonirhat', 'classified-listing' ),
		'BD-36' => __( 'Madaripur', 'classified-listing' ),
		'BD-37' => __( 'Magura', 'classified-listing' ),
		'BD-33' => __( 'Manikganj ', 'classified-listing' ),
		'BD-39' => __( 'Meherpur', 'classified-listing' ),
		'BD-38' => __( 'Moulvibazar', 'classified-listing' ),
		'BD-35' => __( 'Munshiganj', 'classified-listing' ),
		'BD-34' => __( 'Mymensingh', 'classified-listing' ),
		'BD-48' => __( 'Naogaon', 'classified-listing' ),
		'BD-43' => __( 'Narail', 'classified-listing' ),
		'BD-40' => __( 'Narayanganj', 'classified-listing' ),
		'BD-42' => __( 'Narsingdi', 'classified-listing' ),
		'BD-44' => __( 'Natore', 'classified-listing' ),
		'BD-45' => __( 'Nawabganj', 'classified-listing' ),
		'BD-41' => __( 'Netrakona', 'classified-listing' ),
		'BD-46' => __( 'Nilphamari', 'classified-listing' ),
		'BD-47' => __( 'Noakhali', 'classified-listing' ),
		'BD-49' => __( 'Pabna', 'classified-listing' ),
		'BD-52' => __( 'Panchagarh', 'classified-listing' ),
		'BD-51' => __( 'Patuakhali', 'classified-listing' ),
		'BD-50' => __( 'Pirojpur', 'classified-listing' ),
		'BD-53' => __( 'Rajbari', 'classified-listing' ),
		'BD-54' => __( 'Rajshahi', 'classified-listing' ),
		'BD-56' => __( 'Rangamati', 'classified-listing' ),
		'BD-55' => __( 'Rangpur', 'classified-listing' ),
		'BD-58' => __( 'Satkhira', 'classified-listing' ),
		'BD-62' => __( 'Shariatpur', 'classified-listing' ),
		'BD-57' => __( 'Sherpur', 'classified-listing' ),
		'BD-59' => __( 'Sirajganj', 'classified-listing' ),
		'BD-61' => __( 'Sunamganj', 'classified-listing' ),
		'BD-60' => __( 'Sylhet', 'classified-listing' ),
		'BD-63' => __( 'Tangail', 'classified-listing' ),
		'BD-64' => __( 'Thakurgaon', 'classified-listing' ),
	),
	'BE' => array(),
	'BG' => array( // Bulgarian states.
		'BG-01' => __( 'Blagoevgrad', 'classified-listing' ),
		'BG-02' => __( 'Burgas', 'classified-listing' ),
		'BG-08' => __( 'Dobrich', 'classified-listing' ),
		'BG-07' => __( 'Gabrovo', 'classified-listing' ),
		'BG-26' => __( 'Haskovo', 'classified-listing' ),
		'BG-09' => __( 'Kardzhali', 'classified-listing' ),
		'BG-10' => __( 'Kyustendil', 'classified-listing' ),
		'BG-11' => __( 'Lovech', 'classified-listing' ),
		'BG-12' => __( 'Montana', 'classified-listing' ),
		'BG-13' => __( 'Pazardzhik', 'classified-listing' ),
		'BG-14' => __( 'Pernik', 'classified-listing' ),
		'BG-15' => __( 'Pleven', 'classified-listing' ),
		'BG-16' => __( 'Plovdiv', 'classified-listing' ),
		'BG-17' => __( 'Razgrad', 'classified-listing' ),
		'BG-18' => __( 'Ruse', 'classified-listing' ),
		'BG-27' => __( 'Shumen', 'classified-listing' ),
		'BG-19' => __( 'Silistra', 'classified-listing' ),
		'BG-20' => __( 'Sliven', 'classified-listing' ),
		'BG-21' => __( 'Smolyan', 'classified-listing' ),
		'BG-23' => __( 'Sofia', 'classified-listing' ),
		'BG-22' => __( 'Sofia-Grad', 'classified-listing' ),
		'BG-24' => __( 'Stara Zagora', 'classified-listing' ),
		'BG-25' => __( 'Targovishte', 'classified-listing' ),
		'BG-03' => __( 'Varna', 'classified-listing' ),
		'BG-04' => __( 'Veliko Tarnovo', 'classified-listing' ),
		'BG-05' => __( 'Vidin', 'classified-listing' ),
		'BG-06' => __( 'Vratsa', 'classified-listing' ),
		'BG-28' => __( 'Yambol', 'classified-listing' ),
	),
	'BH' => array(),
	'BI' => array(),
	'BJ' => array( // Benin states.
		'AL' => __( 'Alibori', 'classified-listing' ),
		'AK' => __( 'Atakora', 'classified-listing' ),
		'AQ' => __( 'Atlantique', 'classified-listing' ),
		'BO' => __( 'Borgou', 'classified-listing' ),
		'CO' => __( 'Collines', 'classified-listing' ),
		'KO' => __( 'Kouffo', 'classified-listing' ),
		'DO' => __( 'Donga', 'classified-listing' ),
		'LI' => __( 'Littoral', 'classified-listing' ),
		'MO' => __( 'Mono', 'classified-listing' ),
		'OU' => __( 'Ouémé', 'classified-listing' ),
		'PL' => __( 'Plateau', 'classified-listing' ),
		'ZO' => __( 'Zou', 'classified-listing' ),
	),
	'BO' => array( // Bolivian states.
		'BO-B' => __( 'Beni', 'classified-listing' ),
		'BO-H' => __( 'Chuquisaca', 'classified-listing' ),
		'BO-C' => __( 'Cochabamba', 'classified-listing' ),
		'BO-L' => __( 'La Paz', 'classified-listing' ),
		'BO-O' => __( 'Oruro', 'classified-listing' ),
		'BO-N' => __( 'Pando', 'classified-listing' ),
		'BO-P' => __( 'Potosí', 'classified-listing' ),
		'BO-S' => __( 'Santa Cruz', 'classified-listing' ),
		'BO-T' => __( 'Tarija', 'classified-listing' ),
	),
	'BR' => array( // Brazillian states.
		'AC' => __( 'Acre', 'classified-listing' ),
		'AL' => __( 'Alagoas', 'classified-listing' ),
		'AP' => __( 'Amapá', 'classified-listing' ),
		'AM' => __( 'Amazonas', 'classified-listing' ),
		'BA' => __( 'Bahia', 'classified-listing' ),
		'CE' => __( 'Ceará', 'classified-listing' ),
		'DF' => __( 'Distrito Federal', 'classified-listing' ),
		'ES' => __( 'Espírito Santo', 'classified-listing' ),
		'GO' => __( 'Goiás', 'classified-listing' ),
		'MA' => __( 'Maranhão', 'classified-listing' ),
		'MT' => __( 'Mato Grosso', 'classified-listing' ),
		'MS' => __( 'Mato Grosso do Sul', 'classified-listing' ),
		'MG' => __( 'Minas Gerais', 'classified-listing' ),
		'PA' => __( 'Pará', 'classified-listing' ),
		'PB' => __( 'Paraíba', 'classified-listing' ),
		'PR' => __( 'Paraná', 'classified-listing' ),
		'PE' => __( 'Pernambuco', 'classified-listing' ),
		'PI' => __( 'Piauí', 'classified-listing' ),
		'RJ' => __( 'Rio de Janeiro', 'classified-listing' ),
		'RN' => __( 'Rio Grande do Norte', 'classified-listing' ),
		'RS' => __( 'Rio Grande do Sul', 'classified-listing' ),
		'RO' => __( 'Rondônia', 'classified-listing' ),
		'RR' => __( 'Roraima', 'classified-listing' ),
		'SC' => __( 'Santa Catarina', 'classified-listing' ),
		'SP' => __( 'São Paulo', 'classified-listing' ),
		'SE' => __( 'Sergipe', 'classified-listing' ),
		'TO' => __( 'Tocantins', 'classified-listing' ),
	),
	'CA' => array( // Canadian states.
		'AB' => __( 'Alberta', 'classified-listing' ),
		'BC' => __( 'British Columbia', 'classified-listing' ),
		'MB' => __( 'Manitoba', 'classified-listing' ),
		'NB' => __( 'New Brunswick', 'classified-listing' ),
		'NL' => __( 'Newfoundland and Labrador', 'classified-listing' ),
		'NT' => __( 'Northwest Territories', 'classified-listing' ),
		'NS' => __( 'Nova Scotia', 'classified-listing' ),
		'NU' => __( 'Nunavut', 'classified-listing' ),
		'ON' => __( 'Ontario', 'classified-listing' ),
		'PE' => __( 'Prince Edward Island', 'classified-listing' ),
		'QC' => __( 'Quebec', 'classified-listing' ),
		'SK' => __( 'Saskatchewan', 'classified-listing' ),
		'YT' => __( 'Yukon Territory', 'classified-listing' ),
	),
	'CH' => array( // Cantons of Switzerland.
		'AG' => __( 'Aargau', 'classified-listing' ),
		'AR' => __( 'Appenzell Ausserrhoden', 'classified-listing' ),
		'AI' => __( 'Appenzell Innerrhoden', 'classified-listing' ),
		'BL' => __( 'Basel-Landschaft', 'classified-listing' ),
		'BS' => __( 'Basel-Stadt', 'classified-listing' ),
		'BE' => __( 'Bern', 'classified-listing' ),
		'FR' => __( 'Fribourg', 'classified-listing' ),
		'GE' => __( 'Geneva', 'classified-listing' ),
		'GL' => __( 'Glarus', 'classified-listing' ),
		'GR' => __( 'Graubünden', 'classified-listing' ),
		'JU' => __( 'Jura', 'classified-listing' ),
		'LU' => __( 'Luzern', 'classified-listing' ),
		'NE' => __( 'Neuchâtel', 'classified-listing' ),
		'NW' => __( 'Nidwalden', 'classified-listing' ),
		'OW' => __( 'Obwalden', 'classified-listing' ),
		'SH' => __( 'Schaffhausen', 'classified-listing' ),
		'SZ' => __( 'Schwyz', 'classified-listing' ),
		'SO' => __( 'Solothurn', 'classified-listing' ),
		'SG' => __( 'St. Gallen', 'classified-listing' ),
		'TG' => __( 'Thurgau', 'classified-listing' ),
		'TI' => __( 'Ticino', 'classified-listing' ),
		'UR' => __( 'Uri', 'classified-listing' ),
		'VS' => __( 'Valais', 'classified-listing' ),
		'VD' => __( 'Vaud', 'classified-listing' ),
		'ZG' => __( 'Zug', 'classified-listing' ),
		'ZH' => __( 'Zürich', 'classified-listing' ),
	),
	'CL' => array( // Chile states.
		'CL-AI' => __( 'Aisén del General Carlos Ibañez del Campo', 'classified-listing' ),
		'CL-AN' => __( 'Antofagasta', 'classified-listing' ),
		'CL-AP' => __( 'Arica y Parinacota', 'classified-listing' ),
		'CL-AR' => __( 'La Araucanía', 'classified-listing' ),
		'CL-AT' => __( 'Atacama', 'classified-listing' ),
		'CL-BI' => __( 'Biobío', 'classified-listing' ),
		'CL-CO' => __( 'Coquimbo', 'classified-listing' ),
		'CL-LI' => __( 'Libertador General Bernardo O\'Higgins', 'classified-listing' ),
		'CL-LL' => __( 'Los Lagos', 'classified-listing' ),
		'CL-LR' => __( 'Los Ríos', 'classified-listing' ),
		'CL-MA' => __( 'Magallanes', 'classified-listing' ),
		'CL-ML' => __( 'Maule', 'classified-listing' ),
		'CL-NB' => __( 'Ñuble', 'classified-listing' ),
		'CL-RM' => __( 'Región Metropolitana de Santiago', 'classified-listing' ),
		'CL-TA' => __( 'Tarapacá', 'classified-listing' ),
		'CL-VS' => __( 'Valparaíso', 'classified-listing' ),
	),
	'CN' => array( // Chinese states.
		'CN1'  => __( 'Yunnan / 云南', 'classified-listing' ),
		'CN2'  => __( 'Beijing / 北京', 'classified-listing' ),
		'CN3'  => __( 'Tianjin / 天津', 'classified-listing' ),
		'CN4'  => __( 'Hebei / 河北', 'classified-listing' ),
		'CN5'  => __( 'Shanxi / 山西', 'classified-listing' ),
		'CN6'  => __( 'Inner Mongolia / 內蒙古', 'classified-listing' ),
		'CN7'  => __( 'Liaoning / 辽宁', 'classified-listing' ),
		'CN8'  => __( 'Jilin / 吉林', 'classified-listing' ),
		'CN9'  => __( 'Heilongjiang / 黑龙江', 'classified-listing' ),
		'CN10' => __( 'Shanghai / 上海', 'classified-listing' ),
		'CN11' => __( 'Jiangsu / 江苏', 'classified-listing' ),
		'CN12' => __( 'Zhejiang / 浙江', 'classified-listing' ),
		'CN13' => __( 'Anhui / 安徽', 'classified-listing' ),
		'CN14' => __( 'Fujian / 福建', 'classified-listing' ),
		'CN15' => __( 'Jiangxi / 江西', 'classified-listing' ),
		'CN16' => __( 'Shandong / 山东', 'classified-listing' ),
		'CN17' => __( 'Henan / 河南', 'classified-listing' ),
		'CN18' => __( 'Hubei / 湖北', 'classified-listing' ),
		'CN19' => __( 'Hunan / 湖南', 'classified-listing' ),
		'CN20' => __( 'Guangdong / 广东', 'classified-listing' ),
		'CN21' => __( 'Guangxi Zhuang / 广西壮族', 'classified-listing' ),
		'CN22' => __( 'Hainan / 海南', 'classified-listing' ),
		'CN23' => __( 'Chongqing / 重庆', 'classified-listing' ),
		'CN24' => __( 'Sichuan / 四川', 'classified-listing' ),
		'CN25' => __( 'Guizhou / 贵州', 'classified-listing' ),
		'CN26' => __( 'Shaanxi / 陕西', 'classified-listing' ),
		'CN27' => __( 'Gansu / 甘肃', 'classified-listing' ),
		'CN28' => __( 'Qinghai / 青海', 'classified-listing' ),
		'CN29' => __( 'Ningxia Hui / 宁夏', 'classified-listing' ),
		'CN30' => __( 'Macao / 澳门', 'classified-listing' ),
		'CN31' => __( 'Tibet / 西藏', 'classified-listing' ),
		'CN32' => __( 'Xinjiang / 新疆', 'classified-listing' ),
	),
	'CO' => array( // Colombia States.
		'CO-AMA' => __( 'Amazonas', 'classified-listing' ),
		'CO-ANT' => __( 'Antioquia', 'classified-listing' ),
		'CO-ARA' => __( 'Arauca', 'classified-listing' ),
		'CO-ATL' => __( 'Atlántico', 'classified-listing' ),
		'CO-BOL' => __( 'Bolívar', 'classified-listing' ),
		'CO-BOY' => __( 'Boyacá', 'classified-listing' ),
		'CO-CAL' => __( 'Caldas', 'classified-listing' ),
		'CO-CAQ' => __( 'Caquetá', 'classified-listing' ),
		'CO-CAS' => __( 'Casanare', 'classified-listing' ),
		'CO-CAU' => __( 'Cauca', 'classified-listing' ),
		'CO-CES' => __( 'Cesar', 'classified-listing' ),
		'CO-CHO' => __( 'Chocó', 'classified-listing' ),
		'CO-COR' => __( 'Córdoba', 'classified-listing' ),
		'CO-CUN' => __( 'Cundinamarca', 'classified-listing' ),
		'CO-DC' => __( 'Capital District', 'classified-listing' ),
		'CO-GUA' => __( 'Guainía', 'classified-listing' ),
		'CO-GUV' => __( 'Guaviare', 'classified-listing' ),
		'CO-HUI' => __( 'Huila', 'classified-listing' ),
		'CO-LAG' => __( 'La Guajira', 'classified-listing' ),
		'CO-MAG' => __( 'Magdalena', 'classified-listing' ),
		'CO-MET' => __( 'Meta', 'classified-listing' ),
		'CO-NAR' => __( 'Nariño', 'classified-listing' ),
		'CO-NSA' => __( 'Norte de Santander', 'classified-listing' ),
		'CO-PUT' => __( 'Putumayo', 'classified-listing' ),
		'CO-QUI' => __( 'Quindío', 'classified-listing' ),
		'CO-RIS' => __( 'Risaralda', 'classified-listing' ),
		'CO-SAN' => __( 'Santander', 'classified-listing' ),
		'CO-SAP' => __( 'San Andrés & Providencia', 'classified-listing' ),
		'CO-SUC' => __( 'Sucre', 'classified-listing' ),
		'CO-TOL' => __( 'Tolima', 'classified-listing' ),
		'CO-VAC' => __( 'Valle del Cauca', 'classified-listing' ),
		'CO-VAU' => __( 'Vaupés', 'classified-listing' ),
		'CO-VID' => __( 'Vichada', 'classified-listing' ),
	),
	'CR' => array( // Costa Rica states.
		'CR-A' => __( 'Alajuela', 'classified-listing' ),
		'CR-C' => __( 'Cartago', 'classified-listing' ),
		'CR-G' => __( 'Guanacaste', 'classified-listing' ),
		'CR-H' => __( 'Heredia', 'classified-listing' ),
		'CR-L' => __( 'Limón', 'classified-listing' ),
		'CR-P' => __( 'Puntarenas', 'classified-listing' ),
		'CR-SJ' => __( 'San José', 'classified-listing' ),
	),
	'CZ' => array(),
	'DE' => array(),
	'DK' => array(),
	'DO' => array( // Dominican Republic.
		'DO-01' => __( 'Distrito Nacional', 'classified-listing' ),
		'DO-02' => __( 'Azua', 'classified-listing' ),
		'DO-03' => __( 'Baoruco', 'classified-listing' ),
		'DO-04' => __( 'Barahona', 'classified-listing' ),
		'DO-33' => __( 'Cibao Nordeste', 'classified-listing' ),
		'DO-34' => __( 'Cibao Noroeste', 'classified-listing' ),
		'DO-35' => __( 'Cibao Norte', 'classified-listing' ),
		'DO-36' => __( 'Cibao Sur', 'classified-listing' ),
		'DO-05' => __( 'Dajabón', 'classified-listing' ),
		'DO-06' => __( 'Duarte', 'classified-listing' ),
		'DO-08' => __( 'El Seibo', 'classified-listing' ),
		'DO-37' => __( 'El Valle', 'classified-listing' ),
		'DO-07' => __( 'Elías Piña', 'classified-listing' ),
		'DO-38' => __( 'Enriquillo', 'classified-listing' ),		
		'DO-09' => __( 'Espaillat', 'classified-listing' ),
		'DO-30' => __( 'Hato Mayor', 'classified-listing' ),
		'DO-19' => __( 'Hermanas Mirabal', 'classified-listing' ),
		'DO-39' => __( 'Higüamo', 'classified-listing' ),
		'DO-10' => __( 'Independencia', 'classified-listing' ),
		'DO-11' => __( 'La Altagracia', 'classified-listing' ),
		'DO-12' => __( 'La Romana', 'classified-listing' ),
		'DO-13' => __( 'La Vega', 'classified-listing' ),
		'DO-14' => __( 'María Trinidad Sánchez', 'classified-listing' ),
		'DO-28' => __( 'Monseñor Nouel', 'classified-listing' ),
		'DO-15' => __( 'Monte Cristi', 'classified-listing' ),
		'DO-29' => __( 'Monte Plata', 'classified-listing' ),
		'DO-40' => __( 'Ozama', 'classified-listing' ),
		'DO-16' => __( 'Pedernales', 'classified-listing' ),
		'DO-17' => __( 'Peravia', 'classified-listing' ),
		'DO-18' => __( 'Puerto Plata', 'classified-listing' ),
		'DO-20' => __( 'Samaná', 'classified-listing' ),
		'DO-21' => __( 'San Cristóbal', 'classified-listing' ),
		'DO-31' => __( 'San José de Ocoa', 'classified-listing' ),
		'DO-22' => __( 'San Juan', 'classified-listing' ),
		'DO-23' => __( 'San Pedro de Macorís', 'classified-listing' ),
		'DO-24' => __( 'Sánchez Ramírez', 'classified-listing' ),
		'DO-25' => __( 'Santiago', 'classified-listing' ),
		'DO-26' => __( 'Santiago Rodríguez', 'classified-listing' ),
		'DO-32' => __( 'Santo Domingo', 'classified-listing' ),
		'DO-41' => __( 'Valdesia', 'classified-listing' ),
		'DO-27' => __( 'Valverde', 'classified-listing' ),
		'DO-42' => __( 'Yuma', 'classified-listing' ),
	),
	'DZ' => array(
		'DZ-01' => __( 'Adrar', 'classified-listing' ),
		'DZ-02' => __( 'Chlef', 'classified-listing' ),
		'DZ-03' => __( 'Laghouat', 'classified-listing' ),
		'DZ-04' => __( 'Oum El Bouaghi', 'classified-listing' ),
		'DZ-05' => __( 'Batna', 'classified-listing' ),
		'DZ-06' => __( 'Béjaïa', 'classified-listing' ),
		'DZ-07' => __( 'Biskra', 'classified-listing' ),
		'DZ-08' => __( 'Béchar', 'classified-listing' ),
		'DZ-09' => __( 'Blida', 'classified-listing' ),
		'DZ-10' => __( 'Bouira', 'classified-listing' ),
		'DZ-11' => __( 'Tamanghasset', 'classified-listing' ),
		'DZ-12' => __( 'Tébessa', 'classified-listing' ),
		'DZ-13' => __( 'Tlemcen', 'classified-listing' ),
		'DZ-14' => __( 'Tiaret', 'classified-listing' ),
		'DZ-15' => __( 'Tizi Ouzou', 'classified-listing' ),
		'DZ-16' => __( 'Algiers', 'classified-listing' ),
		'DZ-17' => __( 'Djelfa', 'classified-listing' ),
		'DZ-18' => __( 'Jijel', 'classified-listing' ),
		'DZ-19' => __( 'Sétif', 'classified-listing' ),
		'DZ-20' => __( 'Saïda', 'classified-listing' ),
		'DZ-21' => __( 'Skikda', 'classified-listing' ),
		'DZ-22' => __( 'Sidi Bel Abbès', 'classified-listing' ),
		'DZ-23' => __( 'Annaba', 'classified-listing' ),
		'DZ-24' => __( 'Guelma', 'classified-listing' ),
		'DZ-25' => __( 'Constantine', 'classified-listing' ),
		'DZ-26' => __( 'Médéa', 'classified-listing' ),
		'DZ-27' => __( 'Mostaganem', 'classified-listing' ),
		'DZ-28' => __( 'M’Sila', 'classified-listing' ),
		'DZ-29' => __( 'Mascara', 'classified-listing' ),
		'DZ-30' => __( 'Ouargla', 'classified-listing' ),
		'DZ-31' => __( 'Oran', 'classified-listing' ),
		'DZ-32' => __( 'El Bayadh', 'classified-listing' ),
		'DZ-33' => __( 'Illizi', 'classified-listing' ),
		'DZ-34' => __( 'Bordj Bou Arréridj', 'classified-listing' ),
		'DZ-35' => __( 'Boumerdès', 'classified-listing' ),
		'DZ-36' => __( 'El Tarf', 'classified-listing' ),
		'DZ-37' => __( 'Tindouf', 'classified-listing' ),
		'DZ-38' => __( 'Tissemsilt', 'classified-listing' ),
		'DZ-39' => __( 'El Oued', 'classified-listing' ),
		'DZ-40' => __( 'Khenchela', 'classified-listing' ),
		'DZ-41' => __( 'Souk Ahras', 'classified-listing' ),
		'DZ-42' => __( 'Tipasa', 'classified-listing' ),
		'DZ-43' => __( 'Mila', 'classified-listing' ),
		'DZ-44' => __( 'Aïn Defla', 'classified-listing' ),
		'DZ-45' => __( 'Naama', 'classified-listing' ),
		'DZ-46' => __( 'Aïn Témouchent', 'classified-listing' ),
		'DZ-47' => __( 'Ghardaïa', 'classified-listing' ),
		'DZ-48' => __( 'Relizane', 'classified-listing' ),
	),
	'EE' => array(),
	'EC' => array( // Ecuador states.
		'EC-A' => __( 'Azuay', 'classified-listing' ),
		'EC-B' => __( 'Bolívar', 'classified-listing' ),
		'EC-F' => __( 'Cañar', 'classified-listing' ),
		'EC-C' => __( 'Carchi', 'classified-listing' ),
		'EC-H' => __( 'Chimborazo', 'classified-listing' ),
		'EC-X' => __( 'Cotopaxi', 'classified-listing' ),
		'EC-O' => __( 'El Oro', 'classified-listing' ),
		'EC-E' => __( 'Esmeraldas', 'classified-listing' ),
		'EC-W' => __( 'Galápagos', 'classified-listing' ),
		'EC-G' => __( 'Guayas', 'classified-listing' ),
		'EC-I' => __( 'Imbabura', 'classified-listing' ),
		'EC-L' => __( 'Loja', 'classified-listing' ),
		'EC-R' => __( 'Los Ríos', 'classified-listing' ),
		'EC-M' => __( 'Manabí', 'classified-listing' ),
		'EC-S' => __( 'Morona-Santiago', 'classified-listing' ),
		'EC-N' => __( 'Napo', 'classified-listing' ),
		'EC-D' => __( 'Orellana', 'classified-listing' ),
		'EC-Y' => __( 'Pastaza', 'classified-listing' ),
		'EC-P' => __( 'Pichincha', 'classified-listing' ),
		'EC-SE' => __( 'Santa Elena', 'classified-listing' ),
		'EC-SD' => __( 'Santo Domingo de los Tsáchilas', 'classified-listing' ),
		'EC-U' => __( 'Sucumbíos', 'classified-listing' ),
		'EC-T' => __( 'Tungurahua', 'classified-listing' ),
		'EC-Z' => __( 'Zamora-Chinchipe', 'classified-listing' ),
	),
	'EG' => array( // Egypt states.
		'EGALX' => __( 'Alexandria', 'classified-listing' ),
		'EGASN' => __( 'Aswan', 'classified-listing' ),
		'EGAST' => __( 'Asyut', 'classified-listing' ),
		'EGBA'  => __( 'Red Sea', 'classified-listing' ),
		'EGBH'  => __( 'Beheira', 'classified-listing' ),
		'EGBNS' => __( 'Beni Suef', 'classified-listing' ),
		'EGC'   => __( 'Cairo', 'classified-listing' ),
		'EGDK'  => __( 'Dakahlia', 'classified-listing' ),
		'EGDT'  => __( 'Damietta', 'classified-listing' ),
		'EGFYM' => __( 'Faiyum', 'classified-listing' ),
		'EGGH'  => __( 'Gharbia', 'classified-listing' ),
		'EGGZ'  => __( 'Giza', 'classified-listing' ),
		'EGIS'  => __( 'Ismailia', 'classified-listing' ),
		'EGJS'  => __( 'South Sinai', 'classified-listing' ),
		'EGKB'  => __( 'Qalyubia', 'classified-listing' ),
		'EGKFS' => __( 'Kafr el-Sheikh', 'classified-listing' ),
		'EGKN'  => __( 'Qena', 'classified-listing' ),
		'EGLX'  => __( 'Luxor', 'classified-listing' ),
		'EGMN'  => __( 'Minya', 'classified-listing' ),
		'EGMNF' => __( 'Monufia', 'classified-listing' ),
		'EGMT'  => __( 'Matrouh', 'classified-listing' ),
		'EGPTS' => __( 'Port Said', 'classified-listing' ),
		'EGSHG' => __( 'Sohag', 'classified-listing' ),
		'EGSHR' => __( 'Al Sharqia', 'classified-listing' ),
		'EGSIN' => __( 'North Sinai', 'classified-listing' ),
		'EGSUZ' => __( 'Suez', 'classified-listing' ),
		'EGWAD' => __( 'New Valley', 'classified-listing' ),
	),
	'ES' => array( // Spanish states.
		'C'  => __( 'A Coruña', 'classified-listing' ),
		'VI' => __( 'Araba/Álava', 'classified-listing' ),
		'AB' => __( 'Albacete', 'classified-listing' ),
		'A'  => __( 'Alicante', 'classified-listing' ),
		'AL' => __( 'Almería', 'classified-listing' ),
		'O'  => __( 'Asturias', 'classified-listing' ),
		'AV' => __( 'Ávila', 'classified-listing' ),
		'BA' => __( 'Badajoz', 'classified-listing' ),
		'PM' => __( 'Baleares', 'classified-listing' ),
		'B'  => __( 'Barcelona', 'classified-listing' ),
		'BU' => __( 'Burgos', 'classified-listing' ),
		'CC' => __( 'Cáceres', 'classified-listing' ),
		'CA' => __( 'Cádiz', 'classified-listing' ),
		'S'  => __( 'Cantabria', 'classified-listing' ),
		'CS' => __( 'Castellón', 'classified-listing' ),
		'CE' => __( 'Ceuta', 'classified-listing' ),
		'CR' => __( 'Ciudad Real', 'classified-listing' ),
		'CO' => __( 'Córdoba', 'classified-listing' ),
		'CU' => __( 'Cuenca', 'classified-listing' ),
		'GI' => __( 'Girona', 'classified-listing' ),
		'GR' => __( 'Granada', 'classified-listing' ),
		'GU' => __( 'Guadalajara', 'classified-listing' ),
		'SS' => __( 'Gipuzkoa', 'classified-listing' ),
		'H'  => __( 'Huelva', 'classified-listing' ),
		'HU' => __( 'Huesca', 'classified-listing' ),
		'J'  => __( 'Jaén', 'classified-listing' ),
		'LO' => __( 'La Rioja', 'classified-listing' ),
		'GC' => __( 'Las Palmas', 'classified-listing' ),
		'LE' => __( 'León', 'classified-listing' ),
		'L'  => __( 'Lleida', 'classified-listing' ),
		'LU' => __( 'Lugo', 'classified-listing' ),
		'M'  => __( 'Madrid', 'classified-listing' ),
		'MA' => __( 'Málaga', 'classified-listing' ),
		'ML' => __( 'Melilla', 'classified-listing' ),
		'MU' => __( 'Murcia', 'classified-listing' ),
		'NA' => __( 'Navarra', 'classified-listing' ),
		'OR' => __( 'Ourense', 'classified-listing' ),
		'P'  => __( 'Palencia', 'classified-listing' ),
		'PO' => __( 'Pontevedra', 'classified-listing' ),
		'SA' => __( 'Salamanca', 'classified-listing' ),
		'TF' => __( 'Santa Cruz de Tenerife', 'classified-listing' ),
		'SG' => __( 'Segovia', 'classified-listing' ),
		'SE' => __( 'Sevilla', 'classified-listing' ),
		'SO' => __( 'Soria', 'classified-listing' ),
		'T'  => __( 'Tarragona', 'classified-listing' ),
		'TE' => __( 'Teruel', 'classified-listing' ),
		'TO' => __( 'Toledo', 'classified-listing' ),
		'V'  => __( 'Valencia', 'classified-listing' ),
		'VA' => __( 'Valladolid', 'classified-listing' ),
		'BI' => __( 'Biscay', 'classified-listing' ),
		'ZA' => __( 'Zamora', 'classified-listing' ),
		'Z'  => __( 'Zaragoza', 'classified-listing' ),
	),
	'FI' => array(),
	'FR' => array(),
	'GF' => array(),
	'GH' => array( // Ghanaian Regions.
		'AF' => __( 'Ahafo', 'classified-listing' ),
		'AH' => __( 'Ashanti', 'classified-listing' ),
		'BA' => __( 'Brong-Ahafo', 'classified-listing' ),
		'BO' => __( 'Bono', 'classified-listing' ),
		'BE' => __( 'Bono East', 'classified-listing' ),
		'CP' => __( 'Central', 'classified-listing' ),
		'EP' => __( 'Eastern', 'classified-listing' ),
		'AA' => __( 'Greater Accra', 'classified-listing' ),
		'NE' => __( 'North East', 'classified-listing' ),
		'NP' => __( 'Northern', 'classified-listing' ),
		'OT' => __( 'Oti', 'classified-listing' ),
		'SV' => __( 'Savannah', 'classified-listing' ),
		'UE' => __( 'Upper East', 'classified-listing' ),
		'UW' => __( 'Upper West', 'classified-listing' ),
		'TV' => __( 'Volta', 'classified-listing' ),
		'WP' => __( 'Western', 'classified-listing' ),
		'WN' => __( 'Western North', 'classified-listing' ),
	),
	'GP' => array(),
	'GR' => array( // Greek Regions.
		'I' => __( 'Attica', 'classified-listing' ),
		'A' => __( 'East Macedonia and Thrace', 'classified-listing' ),
		'B' => __( 'Central Macedonia', 'classified-listing' ),
		'C' => __( 'West Macedonia', 'classified-listing' ),
		'D' => __( 'Epirus', 'classified-listing' ),
		'E' => __( 'Thessaly', 'classified-listing' ),
		'F' => __( 'Ionian Islands', 'classified-listing' ),
		'G' => __( 'West Greece', 'classified-listing' ),
		'H' => __( 'Central Greece', 'classified-listing' ),
		'J' => __( 'Peloponnese', 'classified-listing' ),
		'K' => __( 'North Aegean', 'classified-listing' ),
		'L' => __( 'South Aegean', 'classified-listing' ),
		'M' => __( 'Crete', 'classified-listing' ),
	),
	'GT' => array( // Guatemalan states.
		'GT-AV' => __( 'Alta Verapaz', 'classified-listing' ),
		'GT-BV' => __( 'Baja Verapaz', 'classified-listing' ),
		'GT-CM' => __( 'Chimaltenango', 'classified-listing' ),
		'GT-CQ' => __( 'Chiquimula', 'classified-listing' ),
		'GT-PR' => __( 'El Progreso', 'classified-listing' ),
		'GT-ES' => __( 'Escuintla', 'classified-listing' ),
		'GT-GU' => __( 'Guatemala', 'classified-listing' ),
		'GT-HU' => __( 'Huehuetenango', 'classified-listing' ),
		'GT-IZ' => __( 'Izabal', 'classified-listing' ),
		'GT-JA' => __( 'Jalapa', 'classified-listing' ),
		'GT-JU' => __( 'Jutiapa', 'classified-listing' ),
		'GT-PE' => __( 'Petén', 'classified-listing' ),
		'GT-QZ' => __( 'Quetzaltenango', 'classified-listing' ),
		'GT-QC' => __( 'Quiché', 'classified-listing' ),
		'GT-RE' => __( 'Retalhuleu', 'classified-listing' ),
		'GT-SA' => __( 'Sacatepéquez', 'classified-listing' ),
		'GT-SM' => __( 'San Marcos', 'classified-listing' ),
		'GT-SR' => __( 'Santa Rosa', 'classified-listing' ),
		'GT-SO' => __( 'Sololá', 'classified-listing' ),
		'GT-SU' => __( 'Suchitepéquez', 'classified-listing' ),
		'GT-TO' => __( 'Totonicapán', 'classified-listing' ),
		'GT-ZA' => __( 'Zacapa', 'classified-listing' ),
	),
	'HK' => array( // Hong Kong states.
		'HONG KONG'       => __( 'Hong Kong Island', 'classified-listing' ),
		'KOWLOON'         => __( 'Kowloon', 'classified-listing' ),
		'NEW TERRITORIES' => __( 'New Territories', 'classified-listing' ),
	),
	'HN' => array( // Honduras states.
		'HN-AT' => __( 'Atlántida', 'classified-listing' ),
		'HN-IB' => __( 'Bay Islands', 'classified-listing' ),
		'HN-CH' => __( 'Choluteca', 'classified-listing' ),
		'HN-CL' => __( 'Colón', 'classified-listing' ),
		'HN-CM' => __( 'Comayagua', 'classified-listing' ),
		'HN-CP' => __( 'Copán', 'classified-listing' ),
		'HN-CR' => __( 'Cortés', 'classified-listing' ),
		'HN-EP' => __( 'El Paraíso', 'classified-listing' ),
		'HN-FM' => __( 'Francisco Morazán', 'classified-listing' ),
		'HN-GD' => __( 'Gracias a Dios', 'classified-listing' ),
		'HN-IN' => __( 'Intibucá', 'classified-listing' ),
		'HN-LE' => __( 'Lempira', 'classified-listing' ),
		'HN-LP' => __( 'La Paz', 'classified-listing' ),
		'HN-OC' => __( 'Ocotepeque', 'classified-listing' ),
		'HN-OL' => __( 'Olancho', 'classified-listing' ),
		'HN-SB' => __( 'Santa Bárbara', 'classified-listing' ),
		'HN-VA' => __( 'Valle', 'classified-listing' ),
		'HN-YO' => __( 'Yoro', 'classified-listing' ),
	),
	'HU' => array( // Hungary states.
		'BK' => __( 'Bács-Kiskun', 'classified-listing' ),
		'BE' => __( 'Békés', 'classified-listing' ),
		'BA' => __( 'Baranya', 'classified-listing' ),
		'BZ' => __( 'Borsod-Abaúj-Zemplén', 'classified-listing' ),
		'BU' => __( 'Budapest', 'classified-listing' ),
		'CS' => __( 'Csongrád-Csanád', 'classified-listing' ),
		'FE' => __( 'Fejér', 'classified-listing' ),
		'GS' => __( 'Győr-Moson-Sopron', 'classified-listing' ),
		'HB' => __( 'Hajdú-Bihar', 'classified-listing' ),
		'HE' => __( 'Heves', 'classified-listing' ),
		'JN' => __( 'Jász-Nagykun-Szolnok', 'classified-listing' ),
		'KE' => __( 'Komárom-Esztergom', 'classified-listing' ),
		'NO' => __( 'Nógrád', 'classified-listing' ),
		'PE' => __( 'Pest', 'classified-listing' ),
		'SO' => __( 'Somogy', 'classified-listing' ),
		'SZ' => __( 'Szabolcs-Szatmár-Bereg', 'classified-listing' ),
		'TO' => __( 'Tolna', 'classified-listing' ),
		'VA' => __( 'Vas', 'classified-listing' ),
		'VE' => __( 'Veszprém', 'classified-listing' ),
		'ZA' => __( 'Zala', 'classified-listing' ),
	),
	'ID' => array( // Indonesia Provinces.
		'AC' => __( 'Daerah Istimewa Aceh', 'classified-listing' ),
		'SU' => __( 'Sumatera Utara', 'classified-listing' ),
		'SB' => __( 'Sumatera Barat', 'classified-listing' ),
		'RI' => __( 'Riau', 'classified-listing' ),
		'KR' => __( 'Kepulauan Riau', 'classified-listing' ),
		'JA' => __( 'Jambi', 'classified-listing' ),
		'SS' => __( 'Sumatera Selatan', 'classified-listing' ),
		'BB' => __( 'Bangka Belitung', 'classified-listing' ),
		'BE' => __( 'Bengkulu', 'classified-listing' ),
		'LA' => __( 'Lampung', 'classified-listing' ),
		'JK' => __( 'DKI Jakarta', 'classified-listing' ),
		'JB' => __( 'Jawa Barat', 'classified-listing' ),
		'BT' => __( 'Banten', 'classified-listing' ),
		'JT' => __( 'Jawa Tengah', 'classified-listing' ),
		'JI' => __( 'Jawa Timur', 'classified-listing' ),
		'YO' => __( 'Daerah Istimewa Yogyakarta', 'classified-listing' ),
		'BA' => __( 'Bali', 'classified-listing' ),
		'NB' => __( 'Nusa Tenggara Barat', 'classified-listing' ),
		'NT' => __( 'Nusa Tenggara Timur', 'classified-listing' ),
		'KB' => __( 'Kalimantan Barat', 'classified-listing' ),
		'KT' => __( 'Kalimantan Tengah', 'classified-listing' ),
		'KI' => __( 'Kalimantan Timur', 'classified-listing' ),
		'KS' => __( 'Kalimantan Selatan', 'classified-listing' ),
		'KU' => __( 'Kalimantan Utara', 'classified-listing' ),
		'SA' => __( 'Sulawesi Utara', 'classified-listing' ),
		'ST' => __( 'Sulawesi Tengah', 'classified-listing' ),
		'SG' => __( 'Sulawesi Tenggara', 'classified-listing' ),
		'SR' => __( 'Sulawesi Barat', 'classified-listing' ),
		'SN' => __( 'Sulawesi Selatan', 'classified-listing' ),
		'GO' => __( 'Gorontalo', 'classified-listing' ),
		'MA' => __( 'Maluku', 'classified-listing' ),
		'MU' => __( 'Maluku Utara', 'classified-listing' ),
		'PA' => __( 'Papua', 'classified-listing' ),
		'PB' => __( 'Papua Barat', 'classified-listing' ),
	),
	'IE' => array( // Republic of Ireland.
		'CW' => __( 'Carlow', 'classified-listing' ),
		'CN' => __( 'Cavan', 'classified-listing' ),
		'CE' => __( 'Clare', 'classified-listing' ),
		'CO' => __( 'Cork', 'classified-listing' ),
		'DL' => __( 'Donegal', 'classified-listing' ),
		'D'  => __( 'Dublin', 'classified-listing' ),
		'G'  => __( 'Galway', 'classified-listing' ),
		'KY' => __( 'Kerry', 'classified-listing' ),
		'KE' => __( 'Kildare', 'classified-listing' ),
		'KK' => __( 'Kilkenny', 'classified-listing' ),
		'LS' => __( 'Laois', 'classified-listing' ),
		'LM' => __( 'Leitrim', 'classified-listing' ),
		'LK' => __( 'Limerick', 'classified-listing' ),
		'LD' => __( 'Longford', 'classified-listing' ),
		'LH' => __( 'Louth', 'classified-listing' ),
		'MO' => __( 'Mayo', 'classified-listing' ),
		'MH' => __( 'Meath', 'classified-listing' ),
		'MN' => __( 'Monaghan', 'classified-listing' ),
		'OY' => __( 'Offaly', 'classified-listing' ),
		'RN' => __( 'Roscommon', 'classified-listing' ),
		'SO' => __( 'Sligo', 'classified-listing' ),
		'TA' => __( 'Tipperary', 'classified-listing' ),
		'WD' => __( 'Waterford', 'classified-listing' ),
		'WH' => __( 'Westmeath', 'classified-listing' ),
		'WX' => __( 'Wexford', 'classified-listing' ),
		'WW' => __( 'Wicklow', 'classified-listing' ),
	),
	'IN' => array( // Indian states.
		'AP' => __( 'Andhra Pradesh', 'classified-listing' ),
		'AR' => __( 'Arunachal Pradesh', 'classified-listing' ),
		'AS' => __( 'Assam', 'classified-listing' ),
		'BR' => __( 'Bihar', 'classified-listing' ),
		'CT' => __( 'Chhattisgarh', 'classified-listing' ),
		'GA' => __( 'Goa', 'classified-listing' ),
		'GJ' => __( 'Gujarat', 'classified-listing' ),
		'HR' => __( 'Haryana', 'classified-listing' ),
		'HP' => __( 'Himachal Pradesh', 'classified-listing' ),
		'JK' => __( 'Jammu and Kashmir', 'classified-listing' ),
		'JH' => __( 'Jharkhand', 'classified-listing' ),
		'KA' => __( 'Karnataka', 'classified-listing' ),
		'KL' => __( 'Kerala', 'classified-listing' ),
		'LA' => __( 'Ladakh', 'classified-listing' ),
		'MP' => __( 'Madhya Pradesh', 'classified-listing' ),
		'MH' => __( 'Maharashtra', 'classified-listing' ),
		'MN' => __( 'Manipur', 'classified-listing' ),
		'ML' => __( 'Meghalaya', 'classified-listing' ),
		'MZ' => __( 'Mizoram', 'classified-listing' ),
		'NL' => __( 'Nagaland', 'classified-listing' ),
		'OR' => __( 'Odisha', 'classified-listing' ),
		'PB' => __( 'Punjab', 'classified-listing' ),
		'RJ' => __( 'Rajasthan', 'classified-listing' ),
		'SK' => __( 'Sikkim', 'classified-listing' ),
		'TN' => __( 'Tamil Nadu', 'classified-listing' ),
		'TS' => __( 'Telangana', 'classified-listing' ),
		'TR' => __( 'Tripura', 'classified-listing' ),
		'UK' => __( 'Uttarakhand', 'classified-listing' ),
		'UP' => __( 'Uttar Pradesh', 'classified-listing' ),
		'WB' => __( 'West Bengal', 'classified-listing' ),
		'AN' => __( 'Andaman and Nicobar Islands', 'classified-listing' ),
		'CH' => __( 'Chandigarh', 'classified-listing' ),
		'DN' => __( 'Dadra and Nagar Haveli', 'classified-listing' ),
		'DD' => __( 'Daman and Diu', 'classified-listing' ),
		'DL' => __( 'Delhi', 'classified-listing' ),
		'LD' => __( 'Lakshadeep', 'classified-listing' ),
		'PY' => __( 'Pondicherry (Puducherry)', 'classified-listing' ),
	),
	'IR' => array( // Iran States.
		'KHZ' => __( 'Khuzestan (خوزستان)', 'classified-listing' ),
		'THR' => __( 'Tehran (تهران)', 'classified-listing' ),
		'ILM' => __( 'Ilaam (ایلام)', 'classified-listing' ),
		'BHR' => __( 'Bushehr (بوشهر)', 'classified-listing' ),
		'ADL' => __( 'Ardabil (اردبیل)', 'classified-listing' ),
		'ESF' => __( 'Isfahan (اصفهان)', 'classified-listing' ),
		'YZD' => __( 'Yazd (یزد)', 'classified-listing' ),
		'KRH' => __( 'Kermanshah (کرمانشاه)', 'classified-listing' ),
		'KRN' => __( 'Kerman (کرمان)', 'classified-listing' ),
		'HDN' => __( 'Hamadan (همدان)', 'classified-listing' ),
		'GZN' => __( 'Ghazvin (قزوین)', 'classified-listing' ),
		'ZJN' => __( 'Zanjan (زنجان)', 'classified-listing' ),
		'LRS' => __( 'Luristan (لرستان)', 'classified-listing' ),
		'ABZ' => __( 'Alborz (البرز)', 'classified-listing' ),
		'EAZ' => __( 'East Azarbaijan (آذربایجان شرقی)', 'classified-listing' ),
		'WAZ' => __( 'West Azarbaijan (آذربایجان غربی)', 'classified-listing' ),
		'CHB' => __( 'Chaharmahal and Bakhtiari (چهارمحال و بختیاری)', 'classified-listing' ),
		'SKH' => __( 'South Khorasan (خراسان جنوبی)', 'classified-listing' ),
		'RKH' => __( 'Razavi Khorasan (خراسان رضوی)', 'classified-listing' ),
		'NKH' => __( 'North Khorasan (خراسان شمالی)', 'classified-listing' ),
		'SMN' => __( 'Semnan (سمنان)', 'classified-listing' ),
		'FRS' => __( 'Fars (فارس)', 'classified-listing' ),
		'QHM' => __( 'Qom (قم)', 'classified-listing' ),
		'KRD' => __( 'Kurdistan / کردستان)', 'classified-listing' ),
		'KBD' => __( 'Kohgiluyeh and BoyerAhmad (کهگیلوییه و بویراحمد)', 'classified-listing' ),
		'GLS' => __( 'Golestan (گلستان)', 'classified-listing' ),
		'GIL' => __( 'Gilan (گیلان)', 'classified-listing' ),
		'MZN' => __( 'Mazandaran (مازندران)', 'classified-listing' ),
		'MKZ' => __( 'Markazi (مرکزی)', 'classified-listing' ),
		'HRZ' => __( 'Hormozgan (هرمزگان)', 'classified-listing' ),
		'SBN' => __( 'Sistan and Baluchestan (سیستان و بلوچستان)', 'classified-listing' ),
	),
	'IS' => array(),
	'IT' => array( // Italy Provinces.
		'AG' => __( 'Agrigento', 'classified-listing' ),
		'AL' => __( 'Alessandria', 'classified-listing' ),
		'AN' => __( 'Ancona', 'classified-listing' ),
		'AO' => __( 'Aosta', 'classified-listing' ),
		'AR' => __( 'Arezzo', 'classified-listing' ),
		'AP' => __( 'Ascoli Piceno', 'classified-listing' ),
		'AT' => __( 'Asti', 'classified-listing' ),
		'AV' => __( 'Avellino', 'classified-listing' ),
		'BA' => __( 'Bari', 'classified-listing' ),
		'BT' => __( 'Barletta-Andria-Trani', 'classified-listing' ),
		'BL' => __( 'Belluno', 'classified-listing' ),
		'BN' => __( 'Benevento', 'classified-listing' ),
		'BG' => __( 'Bergamo', 'classified-listing' ),
		'BI' => __( 'Biella', 'classified-listing' ),
		'BO' => __( 'Bologna', 'classified-listing' ),
		'BZ' => __( 'Bolzano', 'classified-listing' ),
		'BS' => __( 'Brescia', 'classified-listing' ),
		'BR' => __( 'Brindisi', 'classified-listing' ),
		'CA' => __( 'Cagliari', 'classified-listing' ),
		'CL' => __( 'Caltanissetta', 'classified-listing' ),
		'CB' => __( 'Campobasso', 'classified-listing' ),
		'CE' => __( 'Caserta', 'classified-listing' ),
		'CT' => __( 'Catania', 'classified-listing' ),
		'CZ' => __( 'Catanzaro', 'classified-listing' ),
		'CH' => __( 'Chieti', 'classified-listing' ),
		'CO' => __( 'Como', 'classified-listing' ),
		'CS' => __( 'Cosenza', 'classified-listing' ),
		'CR' => __( 'Cremona', 'classified-listing' ),
		'KR' => __( 'Crotone', 'classified-listing' ),
		'CN' => __( 'Cuneo', 'classified-listing' ),
		'EN' => __( 'Enna', 'classified-listing' ),
		'FM' => __( 'Fermo', 'classified-listing' ),
		'FE' => __( 'Ferrara', 'classified-listing' ),
		'FI' => __( 'Firenze', 'classified-listing' ),
		'FG' => __( 'Foggia', 'classified-listing' ),
		'FC' => __( 'Forlì-Cesena', 'classified-listing' ),
		'FR' => __( 'Frosinone', 'classified-listing' ),
		'GE' => __( 'Genova', 'classified-listing' ),
		'GO' => __( 'Gorizia', 'classified-listing' ),
		'GR' => __( 'Grosseto', 'classified-listing' ),
		'IM' => __( 'Imperia', 'classified-listing' ),
		'IS' => __( 'Isernia', 'classified-listing' ),
		'SP' => __( 'La Spezia', 'classified-listing' ),
		'AQ' => __( "L'Aquila", 'classified-listing' ),
		'LT' => __( 'Latina', 'classified-listing' ),
		'LE' => __( 'Lecce', 'classified-listing' ),
		'LC' => __( 'Lecco', 'classified-listing' ),
		'LI' => __( 'Livorno', 'classified-listing' ),
		'LO' => __( 'Lodi', 'classified-listing' ),
		'LU' => __( 'Lucca', 'classified-listing' ),
		'MC' => __( 'Macerata', 'classified-listing' ),
		'MN' => __( 'Mantova', 'classified-listing' ),
		'MS' => __( 'Massa-Carrara', 'classified-listing' ),
		'MT' => __( 'Matera', 'classified-listing' ),
		'ME' => __( 'Messina', 'classified-listing' ),
		'MI' => __( 'Milano', 'classified-listing' ),
		'MO' => __( 'Modena', 'classified-listing' ),
		'MB' => __( 'Monza e della Brianza', 'classified-listing' ),
		'NA' => __( 'Napoli', 'classified-listing' ),
		'NO' => __( 'Novara', 'classified-listing' ),
		'NU' => __( 'Nuoro', 'classified-listing' ),
		'OR' => __( 'Oristano', 'classified-listing' ),
		'PD' => __( 'Padova', 'classified-listing' ),
		'PA' => __( 'Palermo', 'classified-listing' ),
		'PR' => __( 'Parma', 'classified-listing' ),
		'PV' => __( 'Pavia', 'classified-listing' ),
		'PG' => __( 'Perugia', 'classified-listing' ),
		'PU' => __( 'Pesaro e Urbino', 'classified-listing' ),
		'PE' => __( 'Pescara', 'classified-listing' ),
		'PC' => __( 'Piacenza', 'classified-listing' ),
		'PI' => __( 'Pisa', 'classified-listing' ),
		'PT' => __( 'Pistoia', 'classified-listing' ),
		'PN' => __( 'Pordenone', 'classified-listing' ),
		'PZ' => __( 'Potenza', 'classified-listing' ),
		'PO' => __( 'Prato', 'classified-listing' ),
		'RG' => __( 'Ragusa', 'classified-listing' ),
		'RA' => __( 'Ravenna', 'classified-listing' ),
		'RC' => __( 'Reggio Calabria', 'classified-listing' ),
		'RE' => __( 'Reggio Emilia', 'classified-listing' ),
		'RI' => __( 'Rieti', 'classified-listing' ),
		'RN' => __( 'Rimini', 'classified-listing' ),
		'RM' => __( 'Roma', 'classified-listing' ),
		'RO' => __( 'Rovigo', 'classified-listing' ),
		'SA' => __( 'Salerno', 'classified-listing' ),
		'SS' => __( 'Sassari', 'classified-listing' ),
		'SV' => __( 'Savona', 'classified-listing' ),
		'SI' => __( 'Siena', 'classified-listing' ),
		'SR' => __( 'Siracusa', 'classified-listing' ),
		'SO' => __( 'Sondrio', 'classified-listing' ),
		'SU' => __( 'Sud Sardegna', 'classified-listing' ),
		'TA' => __( 'Taranto', 'classified-listing' ),
		'TE' => __( 'Teramo', 'classified-listing' ),
		'TR' => __( 'Terni', 'classified-listing' ),
		'TO' => __( 'Torino', 'classified-listing' ),
		'TP' => __( 'Trapani', 'classified-listing' ),
		'TN' => __( 'Trento', 'classified-listing' ),
		'TV' => __( 'Treviso', 'classified-listing' ),
		'TS' => __( 'Trieste', 'classified-listing' ),
		'UD' => __( 'Udine', 'classified-listing' ),
		'VA' => __( 'Varese', 'classified-listing' ),
		'VE' => __( 'Venezia', 'classified-listing' ),
		'VB' => __( 'Verbano-Cusio-Ossola', 'classified-listing' ),
		'VC' => __( 'Vercelli', 'classified-listing' ),
		'VR' => __( 'Verona', 'classified-listing' ),
		'VV' => __( 'Vibo Valentia', 'classified-listing' ),
		'VI' => __( 'Vicenza', 'classified-listing' ),
		'VT' => __( 'Viterbo', 'classified-listing' ),
	),
	'IL' => array(),
	'IM' => array(),
	'JM' => array( // Jamaica's Parishes. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:JM.
		'JM-01' => __( 'Kingston', 'classified-listing' ),
		'JM-02' => __( 'Saint Andrew', 'classified-listing' ),
		'JM-03' => __( 'Saint Thomas', 'classified-listing' ),
		'JM-04' => __( 'Portland', 'classified-listing' ),
		'JM-05' => __( 'Saint Mary', 'classified-listing' ),
		'JM-06' => __( 'Saint Ann', 'classified-listing' ),
		'JM-07' => __( 'Trelawny', 'classified-listing' ),
		'JM-08' => __( 'Saint James', 'classified-listing' ),
		'JM-09' => __( 'Hanover', 'classified-listing' ),
		'JM-10' => __( 'Westmoreland', 'classified-listing' ),
		'JM-11' => __( 'Saint Elizabeth', 'classified-listing' ),
		'JM-12' => __( 'Manchester', 'classified-listing' ),
		'JM-13' => __( 'Clarendon', 'classified-listing' ),
		'JM-14' => __( 'Saint Catherine', 'classified-listing' ),
	),

	/**
	 * Japan States.
	 *
	 * English notation of prefectures conform to the notation of Japan Post.
	 * The suffix corresponds with the Japanese translation file.
	 */
	'JP' => array(
		'JP01' => __( 'Hokkaido', 'classified-listing' ),
		'JP02' => __( 'Aomori', 'classified-listing' ),
		'JP03' => __( 'Iwate', 'classified-listing' ),
		'JP04' => __( 'Miyagi', 'classified-listing' ),
		'JP05' => __( 'Akita', 'classified-listing' ),
		'JP06' => __( 'Yamagata', 'classified-listing' ),
		'JP07' => __( 'Fukushima', 'classified-listing' ),
		'JP08' => __( 'Ibaraki', 'classified-listing' ),
		'JP09' => __( 'Tochigi', 'classified-listing' ),
		'JP10' => __( 'Gunma', 'classified-listing' ),
		'JP11' => __( 'Saitama', 'classified-listing' ),
		'JP12' => __( 'Chiba', 'classified-listing' ),
		'JP13' => __( 'Tokyo', 'classified-listing' ),
		'JP14' => __( 'Kanagawa', 'classified-listing' ),
		'JP15' => __( 'Niigata', 'classified-listing' ),
		'JP16' => __( 'Toyama', 'classified-listing' ),
		'JP17' => __( 'Ishikawa', 'classified-listing' ),
		'JP18' => __( 'Fukui', 'classified-listing' ),
		'JP19' => __( 'Yamanashi', 'classified-listing' ),
		'JP20' => __( 'Nagano', 'classified-listing' ),
		'JP21' => __( 'Gifu', 'classified-listing' ),
		'JP22' => __( 'Shizuoka', 'classified-listing' ),
		'JP23' => __( 'Aichi', 'classified-listing' ),
		'JP24' => __( 'Mie', 'classified-listing' ),
		'JP25' => __( 'Shiga', 'classified-listing' ),
		'JP26' => __( 'Kyoto', 'classified-listing' ),
		'JP27' => __( 'Osaka', 'classified-listing' ),
		'JP28' => __( 'Hyogo', 'classified-listing' ),
		'JP29' => __( 'Nara', 'classified-listing' ),
		'JP30' => __( 'Wakayama', 'classified-listing' ),
		'JP31' => __( 'Tottori', 'classified-listing' ),
		'JP32' => __( 'Shimane', 'classified-listing' ),
		'JP33' => __( 'Okayama', 'classified-listing' ),
		'JP34' => __( 'Hiroshima', 'classified-listing' ),
		'JP35' => __( 'Yamaguchi', 'classified-listing' ),
		'JP36' => __( 'Tokushima', 'classified-listing' ),
		'JP37' => __( 'Kagawa', 'classified-listing' ),
		'JP38' => __( 'Ehime', 'classified-listing' ),
		'JP39' => __( 'Kochi', 'classified-listing' ),
		'JP40' => __( 'Fukuoka', 'classified-listing' ),
		'JP41' => __( 'Saga', 'classified-listing' ),
		'JP42' => __( 'Nagasaki', 'classified-listing' ),
		'JP43' => __( 'Kumamoto', 'classified-listing' ),
		'JP44' => __( 'Oita', 'classified-listing' ),
		'JP45' => __( 'Miyazaki', 'classified-listing' ),
		'JP46' => __( 'Kagoshima', 'classified-listing' ),
		'JP47' => __( 'Okinawa', 'classified-listing' ),
	),
	'KE' => array( // Kenya counties.
		'KE01' => __( 'Baringo', 'classified-listing' ),
		'KE02' => __( 'Bomet', 'classified-listing' ),
		'KE03' => __( 'Bungoma', 'classified-listing' ),
		'KE04' => __( 'Busia', 'classified-listing' ),
		'KE05' => __( 'Elgeyo-Marakwet', 'classified-listing' ),
		'KE06' => __( 'Embu', 'classified-listing' ),
		'KE07' => __( 'Garissa', 'classified-listing' ),
		'KE08' => __( 'Homa Bay', 'classified-listing' ),
		'KE09' => __( 'Isiolo', 'classified-listing' ),
		'KE10' => __( 'Kajiado', 'classified-listing' ),
		'KE11' => __( 'Kakamega', 'classified-listing' ),
		'KE12' => __( 'Kericho', 'classified-listing' ),
		'KE13' => __( 'Kiambu', 'classified-listing' ),
		'KE14' => __( 'Kilifi', 'classified-listing' ),
		'KE15' => __( 'Kirinyaga', 'classified-listing' ),
		'KE16' => __( 'Kisii', 'classified-listing' ),
		'KE17' => __( 'Kisumu', 'classified-listing' ),
		'KE18' => __( 'Kitui', 'classified-listing' ),
		'KE19' => __( 'Kwale', 'classified-listing' ),
		'KE20' => __( 'Laikipia', 'classified-listing' ),
		'KE21' => __( 'Lamu', 'classified-listing' ),
		'KE22' => __( 'Machakos', 'classified-listing' ),
		'KE23' => __( 'Makueni', 'classified-listing' ),
		'KE24' => __( 'Mandera', 'classified-listing' ),
		'KE25' => __( 'Marsabit', 'classified-listing' ),
		'KE26' => __( 'Meru', 'classified-listing' ),
		'KE27' => __( 'Migori', 'classified-listing' ),
		'KE28' => __( 'Mombasa', 'classified-listing' ),
		'KE29' => __( 'Murang’a', 'classified-listing' ),
		'KE30' => __( 'Nairobi County', 'classified-listing' ),
		'KE31' => __( 'Nakuru', 'classified-listing' ),
		'KE32' => __( 'Nandi', 'classified-listing' ),
		'KE33' => __( 'Narok', 'classified-listing' ),
		'KE34' => __( 'Nyamira', 'classified-listing' ),
		'KE35' => __( 'Nyandarua', 'classified-listing' ),
		'KE36' => __( 'Nyeri', 'classified-listing' ),
		'KE37' => __( 'Samburu', 'classified-listing' ),
		'KE38' => __( 'Siaya', 'classified-listing' ),
		'KE39' => __( 'Taita-Taveta', 'classified-listing' ),
		'KE40' => __( 'Tana River', 'classified-listing' ),
		'KE41' => __( 'Tharaka-Nithi', 'classified-listing' ),
		'KE42' => __( 'Trans Nzoia', 'classified-listing' ),
		'KE43' => __( 'Turkana', 'classified-listing' ),
		'KE44' => __( 'Uasin Gishu', 'classified-listing' ),
		'KE45' => __( 'Vihiga', 'classified-listing' ),
		'KE46' => __( 'Wajir', 'classified-listing' ),
		'KE47' => __( 'West Pokot', 'classified-listing' ),
	),
	'KR' => array(),
	'KW' => array(),
	'LA' => array(
		'AT' => __( 'Attapeu', 'classified-listing' ),
		'BK' => __( 'Bokeo', 'classified-listing' ),
		'BL' => __( 'Bolikhamsai', 'classified-listing' ),
		'CH' => __( 'Champasak', 'classified-listing' ),
		'HO' => __( 'Houaphanh', 'classified-listing' ),
		'KH' => __( 'Khammouane', 'classified-listing' ),
		'LM' => __( 'Luang Namtha', 'classified-listing' ),
		'LP' => __( 'Luang Prabang', 'classified-listing' ),
		'OU' => __( 'Oudomxay', 'classified-listing' ),
		'PH' => __( 'Phongsaly', 'classified-listing' ),
		'SL' => __( 'Salavan', 'classified-listing' ),
		'SV' => __( 'Savannakhet', 'classified-listing' ),
		'VI' => __( 'Vientiane Province', 'classified-listing' ),
		'VT' => __( 'Vientiane', 'classified-listing' ),
		'XA' => __( 'Sainyabuli', 'classified-listing' ),
		'XE' => __( 'Sekong', 'classified-listing' ),
		'XI' => __( 'Xiangkhouang', 'classified-listing' ),
		'XS' => __( 'Xaisomboun', 'classified-listing' ),
	),
	'LB' => array(),
	'LC' => array( // Saint Lucia.
	    'LC-01' => __( 'Anse la Raye Quarter', 'classified-listing' ),
	    'LC-12' => __( 'Canaries', 'classified-listing' ),
	    'LC-02' => __( 'Castries Quarter', 'classified-listing' ),
	    'LC-03' => __( 'Choiseul Quarter', 'classified-listing' ),
	    'LC-04' => __( 'Dauphin Quarter', 'classified-listing' ),
	    'LC-05' => __( 'Dennery Quarter', 'classified-listing' ),
	    'LC-06' => __( 'Gros Islet Quarter', 'classified-listing' ),
	    'LC-07' => __( 'Laborie Quarter', 'classified-listing' ),
	    'LC-08' => __( 'Micoud Quarter', 'classified-listing' ),
	    'LC-09' => __( 'Praslin Quarter', 'classified-listing' ),
	    'LC-10' => __( 'Soufrière Quarter', 'classified-listing' ),
	    'LC-11' => __( 'Vieux Fort Quarter', 'classified-listing' ),
	),
	'LR' => array( // Liberia provinces.
		'BM' => __( 'Bomi', 'classified-listing' ),
		'BN' => __( 'Bong', 'classified-listing' ),
		'GA' => __( 'Gbarpolu', 'classified-listing' ),
		'GB' => __( 'Grand Bassa', 'classified-listing' ),
		'GC' => __( 'Grand Cape Mount', 'classified-listing' ),
		'GG' => __( 'Grand Gedeh', 'classified-listing' ),
		'GK' => __( 'Grand Kru', 'classified-listing' ),
		'LO' => __( 'Lofa', 'classified-listing' ),
		'MA' => __( 'Margibi', 'classified-listing' ),
		'MY' => __( 'Maryland', 'classified-listing' ),
		'MO' => __( 'Montserrado', 'classified-listing' ),
		'NM' => __( 'Nimba', 'classified-listing' ),
		'RV' => __( 'Rivercess', 'classified-listing' ),
		'RG' => __( 'River Gee', 'classified-listing' ),
		'SN' => __( 'Sinoe', 'classified-listing' ),
	),
	'LU' => array(),
	'MD' => array( // Moldova states.
		'C'  => __( 'Chișinău', 'classified-listing' ),
		'BL' => __( 'Bălți', 'classified-listing' ),
		'AN' => __( 'Anenii Noi', 'classified-listing' ),
		'BS' => __( 'Basarabeasca', 'classified-listing' ),
		'BR' => __( 'Briceni', 'classified-listing' ),
		'CH' => __( 'Cahul', 'classified-listing' ),
		'CT' => __( 'Cantemir', 'classified-listing' ),
		'CL' => __( 'Călărași', 'classified-listing' ),
		'CS' => __( 'Căușeni', 'classified-listing' ),
		'CM' => __( 'Cimișlia', 'classified-listing' ),
		'CR' => __( 'Criuleni', 'classified-listing' ),
		'DN' => __( 'Dondușeni', 'classified-listing' ),
		'DR' => __( 'Drochia', 'classified-listing' ),
		'DB' => __( 'Dubăsari', 'classified-listing' ),
		'ED' => __( 'Edineț', 'classified-listing' ),
		'FL' => __( 'Fălești', 'classified-listing' ),
		'FR' => __( 'Florești', 'classified-listing' ),
		'GE' => __( 'UTA Găgăuzia', 'classified-listing' ),
		'GL' => __( 'Glodeni', 'classified-listing' ),
		'HN' => __( 'Hîncești', 'classified-listing' ),
		'IL' => __( 'Ialoveni', 'classified-listing' ),
		'LV' => __( 'Leova', 'classified-listing' ),
		'NS' => __( 'Nisporeni', 'classified-listing' ),
		'OC' => __( 'Ocnița', 'classified-listing' ),
		'OR' => __( 'Orhei', 'classified-listing' ),
		'RZ' => __( 'Rezina', 'classified-listing' ),
		'RS' => __( 'Rîșcani', 'classified-listing' ),
		'SG' => __( 'Sîngerei', 'classified-listing' ),
		'SR' => __( 'Soroca', 'classified-listing' ),
		'ST' => __( 'Strășeni', 'classified-listing' ),
		'SD' => __( 'Șoldănești', 'classified-listing' ),
		'SV' => __( 'Ștefan Vodă', 'classified-listing' ),
		'TR' => __( 'Taraclia', 'classified-listing' ),
		'TL' => __( 'Telenești', 'classified-listing' ),
		'UN' => __( 'Ungheni', 'classified-listing' ),
	),
	'MQ' => array(),
	'MT' => array(),
	'MX' => array( // Mexico States.
		'DF' => __( 'Ciudad de México', 'classified-listing' ),
		'JA' => __( 'Jalisco', 'classified-listing' ),
		'NL' => __( 'Nuevo León', 'classified-listing' ),
		'AG' => __( 'Aguascalientes', 'classified-listing' ),
		'BC' => __( 'Baja California', 'classified-listing' ),
		'BS' => __( 'Baja California Sur', 'classified-listing' ),
		'CM' => __( 'Campeche', 'classified-listing' ),
		'CS' => __( 'Chiapas', 'classified-listing' ),
		'CH' => __( 'Chihuahua', 'classified-listing' ),
		'CO' => __( 'Coahuila', 'classified-listing' ),
		'CL' => __( 'Colima', 'classified-listing' ),
		'DG' => __( 'Durango', 'classified-listing' ),
		'GT' => __( 'Guanajuato', 'classified-listing' ),
		'GR' => __( 'Guerrero', 'classified-listing' ),
		'HG' => __( 'Hidalgo', 'classified-listing' ),
		'MX' => __( 'Estado de México', 'classified-listing' ),
		'MI' => __( 'Michoacán', 'classified-listing' ),
		'MO' => __( 'Morelos', 'classified-listing' ),
		'NA' => __( 'Nayarit', 'classified-listing' ),
		'OA' => __( 'Oaxaca', 'classified-listing' ),
		'PU' => __( 'Puebla', 'classified-listing' ),
		'QT' => __( 'Querétaro', 'classified-listing' ),
		'QR' => __( 'Quintana Roo', 'classified-listing' ),
		'SL' => __( 'San Luis Potosí', 'classified-listing' ),
		'SI' => __( 'Sinaloa', 'classified-listing' ),
		'SO' => __( 'Sonora', 'classified-listing' ),
		'TB' => __( 'Tabasco', 'classified-listing' ),
		'TM' => __( 'Tamaulipas', 'classified-listing' ),
		'TL' => __( 'Tlaxcala', 'classified-listing' ),
		'VE' => __( 'Veracruz', 'classified-listing' ),
		'YU' => __( 'Yucatán', 'classified-listing' ),
		'ZA' => __( 'Zacatecas', 'classified-listing' ),
	),
	'MY' => array( // Malaysian states.
		'JHR' => __( 'Johor', 'classified-listing' ),
		'KDH' => __( 'Kedah', 'classified-listing' ),
		'KTN' => __( 'Kelantan', 'classified-listing' ),
		'LBN' => __( 'Labuan', 'classified-listing' ),
		'MLK' => __( 'Malacca (Melaka)', 'classified-listing' ),
		'NSN' => __( 'Negeri Sembilan', 'classified-listing' ),
		'PHG' => __( 'Pahang', 'classified-listing' ),
		'PNG' => __( 'Penang (Pulau Pinang)', 'classified-listing' ),
		'PRK' => __( 'Perak', 'classified-listing' ),
		'PLS' => __( 'Perlis', 'classified-listing' ),
		'SBH' => __( 'Sabah', 'classified-listing' ),
		'SWK' => __( 'Sarawak', 'classified-listing' ),
		'SGR' => __( 'Selangor', 'classified-listing' ),
		'TRG' => __( 'Terengganu', 'classified-listing' ),
		'PJY' => __( 'Putrajaya', 'classified-listing' ),
		'KUL' => __( 'Kuala Lumpur', 'classified-listing' ),
	),
	'MZ' => array( // Mozambique provinces.
		'MZP'   => __( 'Cabo Delgado', 'classified-listing' ),
		'MZG'   => __( 'Gaza', 'classified-listing' ),
		'MZI'   => __( 'Inhambane', 'classified-listing' ),
		'MZB'   => __( 'Manica', 'classified-listing' ),
		'MZL'   => __( 'Maputo Province', 'classified-listing' ),
		'MZMPM' => __( 'Maputo', 'classified-listing' ),
		'MZN'   => __( 'Nampula', 'classified-listing' ),
		'MZA'   => __( 'Niassa', 'classified-listing' ),
		'MZS'   => __( 'Sofala', 'classified-listing' ),
		'MZT'   => __( 'Tete', 'classified-listing' ),
		'MZQ'   => __( 'Zambézia', 'classified-listing' ),
	),
	'NA' => array( // Namibia regions.
		'ER' => __( 'Erongo', 'classified-listing' ),
		'HA' => __( 'Hardap', 'classified-listing' ),
		'KA' => __( 'Karas', 'classified-listing' ),
		'KE' => __( 'Kavango East', 'classified-listing' ),
		'KW' => __( 'Kavango West', 'classified-listing' ),
		'KH' => __( 'Khomas', 'classified-listing' ),
		'KU' => __( 'Kunene', 'classified-listing' ),
		'OW' => __( 'Ohangwena', 'classified-listing' ),
		'OH' => __( 'Omaheke', 'classified-listing' ),
		'OS' => __( 'Omusati', 'classified-listing' ),
		'ON' => __( 'Oshana', 'classified-listing' ),
		'OT' => __( 'Oshikoto', 'classified-listing' ),
		'OD' => __( 'Otjozondjupa', 'classified-listing' ),
		'CA' => __( 'Zambezi', 'classified-listing' ),
	),
	'NG' => array( // Nigerian provinces.
		'AB' => __( 'Abia', 'classified-listing' ),
		'FC' => __( 'Abuja', 'classified-listing' ),
		'AD' => __( 'Adamawa', 'classified-listing' ),
		'AK' => __( 'Akwa Ibom', 'classified-listing' ),
		'AN' => __( 'Anambra', 'classified-listing' ),
		'BA' => __( 'Bauchi', 'classified-listing' ),
		'BY' => __( 'Bayelsa', 'classified-listing' ),
		'BE' => __( 'Benue', 'classified-listing' ),
		'BO' => __( 'Borno', 'classified-listing' ),
		'CR' => __( 'Cross River', 'classified-listing' ),
		'DE' => __( 'Delta', 'classified-listing' ),
		'EB' => __( 'Ebonyi', 'classified-listing' ),
		'ED' => __( 'Edo', 'classified-listing' ),
		'EK' => __( 'Ekiti', 'classified-listing' ),
		'EN' => __( 'Enugu', 'classified-listing' ),
		'GO' => __( 'Gombe', 'classified-listing' ),
		'IM' => __( 'Imo', 'classified-listing' ),
		'JI' => __( 'Jigawa', 'classified-listing' ),
		'KD' => __( 'Kaduna', 'classified-listing' ),
		'KN' => __( 'Kano', 'classified-listing' ),
		'KT' => __( 'Katsina', 'classified-listing' ),
		'KE' => __( 'Kebbi', 'classified-listing' ),
		'KO' => __( 'Kogi', 'classified-listing' ),
		'KW' => __( 'Kwara', 'classified-listing' ),
		'LA' => __( 'Lagos', 'classified-listing' ),
		'NA' => __( 'Nasarawa', 'classified-listing' ),
		'NI' => __( 'Niger', 'classified-listing' ),
		'OG' => __( 'Ogun', 'classified-listing' ),
		'ON' => __( 'Ondo', 'classified-listing' ),
		'OS' => __( 'Osun', 'classified-listing' ),
		'OY' => __( 'Oyo', 'classified-listing' ),
		'PL' => __( 'Plateau', 'classified-listing' ),
		'RI' => __( 'Rivers', 'classified-listing' ),
		'SO' => __( 'Sokoto', 'classified-listing' ),
		'TA' => __( 'Taraba', 'classified-listing' ),
		'YO' => __( 'Yobe', 'classified-listing' ),
		'ZA' => __( 'Zamfara', 'classified-listing' ),
	),
	'NL' => array(),
	'NO' => array(),
	'NP' => array( // Nepal states (Zones).
		'BAG' => __( 'Bagmati', 'classified-listing' ),
		'BHE' => __( 'Bheri', 'classified-listing' ),
		'DHA' => __( 'Dhaulagiri', 'classified-listing' ),
		'GAN' => __( 'Gandaki', 'classified-listing' ),
		'JAN' => __( 'Janakpur', 'classified-listing' ),
		'KAR' => __( 'Karnali', 'classified-listing' ),
		'KOS' => __( 'Koshi', 'classified-listing' ),
		'LUM' => __( 'Lumbini', 'classified-listing' ),
		'MAH' => __( 'Mahakali', 'classified-listing' ),
		'MEC' => __( 'Mechi', 'classified-listing' ),
		'NAR' => __( 'Narayani', 'classified-listing' ),
		'RAP' => __( 'Rapti', 'classified-listing' ),
		'SAG' => __( 'Sagarmatha', 'classified-listing' ),
		'SET' => __( 'Seti', 'classified-listing' ),
	),
	'NI' => array( // Nicaragua states
		'NI-AN' => __( 'Atlántico Norte', 'classified-listing' ),
		'NI-AS' => __( 'Atlántico Sur', 'classified-listing' ),
		'NI-BO' => __( 'Boaco', 'classified-listing' ),
		'NI-CA' => __( 'Carazo', 'classified-listing' ),
		'NI-CI' => __( 'Chinandega', 'classified-listing' ),
		'NI-CO' => __( 'Chontales', 'classified-listing' ),
		'NI-ES' => __( 'Estelí', 'classified-listing' ),
		'NI-GR' => __( 'Granada', 'classified-listing' ),
		'NI-JI' => __( 'Jinotega', 'classified-listing' ),
		'NI-LE' => __( 'León', 'classified-listing' ),
		'NI-MD' => __( 'Madriz', 'classified-listing' ),
		'NI-MN' => __( 'Managua', 'classified-listing' ),
		'NI-MS' => __( 'Masaya', 'classified-listing' ),
		'NI-MT' => __( 'Matagalpa', 'classified-listing' ),
		'NI-NS' => __( 'Nueva Segovia', 'classified-listing' ),
		'NI-RI' => __( 'Rivas', 'classified-listing' ),
		'NI-SJ' => __( 'Río San Juan', 'classified-listing' ),
	),
	'NZ' => array( // New Zealand States.
		'NL' => __( 'Northland', 'classified-listing' ),
		'AK' => __( 'Auckland', 'classified-listing' ),
		'WA' => __( 'Waikato', 'classified-listing' ),
		'BP' => __( 'Bay of Plenty', 'classified-listing' ),
		'TK' => __( 'Taranaki', 'classified-listing' ),
		'GI' => __( 'Gisborne', 'classified-listing' ),
		'HB' => __( 'Hawke’s Bay', 'classified-listing' ),
		'MW' => __( 'Manawatu-Wanganui', 'classified-listing' ),
		'WE' => __( 'Wellington', 'classified-listing' ),
		'NS' => __( 'Nelson', 'classified-listing' ),
		'MB' => __( 'Marlborough', 'classified-listing' ),
		'TM' => __( 'Tasman', 'classified-listing' ),
		'WC' => __( 'West Coast', 'classified-listing' ),
		'CT' => __( 'Canterbury', 'classified-listing' ),
		'OT' => __( 'Otago', 'classified-listing' ),
		'SL' => __( 'Southland', 'classified-listing' ),
	),
	'PA' => array( // Panama states.
		'PA-1' => __( 'Bocas del Toro', 'classified-listing' ),
		'PA-2' => __( 'Coclé', 'classified-listing' ),
		'PA-3' => __( 'Colón', 'classified-listing' ),
		'PA-4' => __( 'Chiriquí', 'classified-listing' ),
		'PA-5' => __( 'Darién', 'classified-listing' ),
		'PA-6' => __( 'Herrera', 'classified-listing' ),
		'PA-7' => __( 'Los Santos', 'classified-listing' ),
		'PA-8' => __( 'Panamá', 'classified-listing' ),
		'PA-9' => __( 'Veraguas', 'classified-listing' ),
		'PA-10' => __( 'West Panamá', 'classified-listing' ),
		'PA-EM' => __( 'Emberá', 'classified-listing' ),
		'PA-KY' => __( 'Guna Yala', 'classified-listing' ),
		'PA-NB' => __( 'Ngöbe-Buglé', 'classified-listing' ),
	),
	'PE' => array( // Peru states.
		'CAL' => __( 'El Callao', 'classified-listing' ),
		'LMA' => __( 'Municipalidad Metropolitana de Lima', 'classified-listing' ),
		'AMA' => __( 'Amazonas', 'classified-listing' ),
		'ANC' => __( 'Ancash', 'classified-listing' ),
		'APU' => __( 'Apurímac', 'classified-listing' ),
		'ARE' => __( 'Arequipa', 'classified-listing' ),
		'AYA' => __( 'Ayacucho', 'classified-listing' ),
		'CAJ' => __( 'Cajamarca', 'classified-listing' ),
		'CUS' => __( 'Cusco', 'classified-listing' ),
		'HUV' => __( 'Huancavelica', 'classified-listing' ),
		'HUC' => __( 'Huánuco', 'classified-listing' ),
		'ICA' => __( 'Ica', 'classified-listing' ),
		'JUN' => __( 'Junín', 'classified-listing' ),
		'LAL' => __( 'La Libertad', 'classified-listing' ),
		'LAM' => __( 'Lambayeque', 'classified-listing' ),
		'LIM' => __( 'Lima', 'classified-listing' ),
		'LOR' => __( 'Loreto', 'classified-listing' ),
		'MDD' => __( 'Madre de Dios', 'classified-listing' ),
		'MOQ' => __( 'Moquegua', 'classified-listing' ),
		'PAS' => __( 'Pasco', 'classified-listing' ),
		'PIU' => __( 'Piura', 'classified-listing' ),
		'PUN' => __( 'Puno', 'classified-listing' ),
		'SAM' => __( 'San Martín', 'classified-listing' ),
		'TAC' => __( 'Tacna', 'classified-listing' ),
		'TUM' => __( 'Tumbes', 'classified-listing' ),
		'UCA' => __( 'Ucayali', 'classified-listing' ),
	),

	/**
	 * Philippine Provinces.
	 */
	'PH' => array(
		'ABR' => __( 'Abra', 'classified-listing' ),
		'AGN' => __( 'Agusan del Norte', 'classified-listing' ),
		'AGS' => __( 'Agusan del Sur', 'classified-listing' ),
		'AKL' => __( 'Aklan', 'classified-listing' ),
		'ALB' => __( 'Albay', 'classified-listing' ),
		'ANT' => __( 'Antique', 'classified-listing' ),
		'APA' => __( 'Apayao', 'classified-listing' ),
		'AUR' => __( 'Aurora', 'classified-listing' ),
		'BAS' => __( 'Basilan', 'classified-listing' ),
		'BAN' => __( 'Bataan', 'classified-listing' ),
		'BTN' => __( 'Batanes', 'classified-listing' ),
		'BTG' => __( 'Batangas', 'classified-listing' ),
		'BEN' => __( 'Benguet', 'classified-listing' ),
		'BIL' => __( 'Biliran', 'classified-listing' ),
		'BOH' => __( 'Bohol', 'classified-listing' ),
		'BUK' => __( 'Bukidnon', 'classified-listing' ),
		'BUL' => __( 'Bulacan', 'classified-listing' ),
		'CAG' => __( 'Cagayan', 'classified-listing' ),
		'CAN' => __( 'Camarines Norte', 'classified-listing' ),
		'CAS' => __( 'Camarines Sur', 'classified-listing' ),
		'CAM' => __( 'Camiguin', 'classified-listing' ),
		'CAP' => __( 'Capiz', 'classified-listing' ),
		'CAT' => __( 'Catanduanes', 'classified-listing' ),
		'CAV' => __( 'Cavite', 'classified-listing' ),
		'CEB' => __( 'Cebu', 'classified-listing' ),
		'COM' => __( 'Compostela Valley', 'classified-listing' ),
		'NCO' => __( 'Cotabato', 'classified-listing' ),
		'DAV' => __( 'Davao del Norte', 'classified-listing' ),
		'DAS' => __( 'Davao del Sur', 'classified-listing' ),
		'DAC' => __( 'Davao Occidental', 'classified-listing' ),
		'DAO' => __( 'Davao Oriental', 'classified-listing' ),
		'DIN' => __( 'Dinagat Islands', 'classified-listing' ),
		'EAS' => __( 'Eastern Samar', 'classified-listing' ),
		'GUI' => __( 'Guimaras', 'classified-listing' ),
		'IFU' => __( 'Ifugao', 'classified-listing' ),
		'ILN' => __( 'Ilocos Norte', 'classified-listing' ),
		'ILS' => __( 'Ilocos Sur', 'classified-listing' ),
		'ILI' => __( 'Iloilo', 'classified-listing' ),
		'ISA' => __( 'Isabela', 'classified-listing' ),
		'KAL' => __( 'Kalinga', 'classified-listing' ),
		'LUN' => __( 'La Union', 'classified-listing' ),
		'LAG' => __( 'Laguna', 'classified-listing' ),
		'LAN' => __( 'Lanao del Norte', 'classified-listing' ),
		'LAS' => __( 'Lanao del Sur', 'classified-listing' ),
		'LEY' => __( 'Leyte', 'classified-listing' ),
		'MAG' => __( 'Maguindanao', 'classified-listing' ),
		'MAD' => __( 'Marinduque', 'classified-listing' ),
		'MAS' => __( 'Masbate', 'classified-listing' ),
		'MSC' => __( 'Misamis Occidental', 'classified-listing' ),
		'MSR' => __( 'Misamis Oriental', 'classified-listing' ),
		'MOU' => __( 'Mountain Province', 'classified-listing' ),
		'NEC' => __( 'Negros Occidental', 'classified-listing' ),
		'NER' => __( 'Negros Oriental', 'classified-listing' ),
		'NSA' => __( 'Northern Samar', 'classified-listing' ),
		'NUE' => __( 'Nueva Ecija', 'classified-listing' ),
		'NUV' => __( 'Nueva Vizcaya', 'classified-listing' ),
		'MDC' => __( 'Occidental Mindoro', 'classified-listing' ),
		'MDR' => __( 'Oriental Mindoro', 'classified-listing' ),
		'PLW' => __( 'Palawan', 'classified-listing' ),
		'PAM' => __( 'Pampanga', 'classified-listing' ),
		'PAN' => __( 'Pangasinan', 'classified-listing' ),
		'QUE' => __( 'Quezon', 'classified-listing' ),
		'QUI' => __( 'Quirino', 'classified-listing' ),
		'RIZ' => __( 'Rizal', 'classified-listing' ),
		'ROM' => __( 'Romblon', 'classified-listing' ),
		'WSA' => __( 'Samar', 'classified-listing' ),
		'SAR' => __( 'Sarangani', 'classified-listing' ),
		'SIQ' => __( 'Siquijor', 'classified-listing' ),
		'SOR' => __( 'Sorsogon', 'classified-listing' ),
		'SCO' => __( 'South Cotabato', 'classified-listing' ),
		'SLE' => __( 'Southern Leyte', 'classified-listing' ),
		'SUK' => __( 'Sultan Kudarat', 'classified-listing' ),
		'SLU' => __( 'Sulu', 'classified-listing' ),
		'SUN' => __( 'Surigao del Norte', 'classified-listing' ),
		'SUR' => __( 'Surigao del Sur', 'classified-listing' ),
		'TAR' => __( 'Tarlac', 'classified-listing' ),
		'TAW' => __( 'Tawi-Tawi', 'classified-listing' ),
		'ZMB' => __( 'Zambales', 'classified-listing' ),
		'ZAN' => __( 'Zamboanga del Norte', 'classified-listing' ),
		'ZAS' => __( 'Zamboanga del Sur', 'classified-listing' ),
		'ZSI' => __( 'Zamboanga Sibugay', 'classified-listing' ),
		'00'  => __( 'Metro Manila', 'classified-listing' ),
	),
	'PK' => array( // Pakistan's states.
		'JK' => __( 'Azad Kashmir', 'classified-listing' ),
		'BA' => __( 'Balochistan', 'classified-listing' ),
		'TA' => __( 'FATA', 'classified-listing' ),
		'GB' => __( 'Gilgit Baltistan', 'classified-listing' ),
		'IS' => __( 'Islamabad Capital Territory', 'classified-listing' ),
		'KP' => __( 'Khyber Pakhtunkhwa', 'classified-listing' ),
		'PB' => __( 'Punjab', 'classified-listing' ),
		'SD' => __( 'Sindh', 'classified-listing' ),
	),
	'PL' => array(),
	'PR' => array(),
	'PT' => array(),
	'PY' => array( // Paraguay states.
		'PY-ASU' => __( 'Asunción', 'classified-listing' ),
		'PY-1'   => __( 'Concepción', 'classified-listing' ),
		'PY-2'   => __( 'San Pedro', 'classified-listing' ),
		'PY-3'   => __( 'Cordillera', 'classified-listing' ),
		'PY-4'   => __( 'Guairá', 'classified-listing' ),
		'PY-5'   => __( 'Caaguazú', 'classified-listing' ),
		'PY-6'   => __( 'Caazapá', 'classified-listing' ),
		'PY-7'   => __( 'Itapúa', 'classified-listing' ),
		'PY-8'   => __( 'Misiones', 'classified-listing' ),
		'PY-9'   => __( 'Paraguarí', 'classified-listing' ),
		'PY-10'  => __( 'Alto Paraná', 'classified-listing' ),
		'PY-11'  => __( 'Central', 'classified-listing' ),
		'PY-12'  => __( 'Ñeembucú', 'classified-listing' ),
		'PY-13'  => __( 'Amambay', 'classified-listing' ),
		'PY-14'  => __( 'Canindeyú', 'classified-listing' ),
		'PY-15'  => __( 'Presidente Hayes', 'classified-listing' ),
		'PY-16'  => __( 'Alto Paraguay', 'classified-listing' ),
		'PY-17'  => __( 'Boquerón', 'classified-listing' ),
	),
	'RE' => array(),
	'RO' => array( // Romania states.
		'AB' => __( 'Alba', 'classified-listing' ),
		'AR' => __( 'Arad', 'classified-listing' ),
		'AG' => __( 'Argeș', 'classified-listing' ),
		'BC' => __( 'Bacău', 'classified-listing' ),
		'BH' => __( 'Bihor', 'classified-listing' ),
		'BN' => __( 'Bistrița-Năsăud', 'classified-listing' ),
		'BT' => __( 'Botoșani', 'classified-listing' ),
		'BR' => __( 'Brăila', 'classified-listing' ),
		'BV' => __( 'Brașov', 'classified-listing' ),
		'B'  => __( 'București', 'classified-listing' ),
		'BZ' => __( 'Buzău', 'classified-listing' ),
		'CL' => __( 'Călărași', 'classified-listing' ),
		'CS' => __( 'Caraș-Severin', 'classified-listing' ),
		'CJ' => __( 'Cluj', 'classified-listing' ),
		'CT' => __( 'Constanța', 'classified-listing' ),
		'CV' => __( 'Covasna', 'classified-listing' ),
		'DB' => __( 'Dâmbovița', 'classified-listing' ),
		'DJ' => __( 'Dolj', 'classified-listing' ),
		'GL' => __( 'Galați', 'classified-listing' ),
		'GR' => __( 'Giurgiu', 'classified-listing' ),
		'GJ' => __( 'Gorj', 'classified-listing' ),
		'HR' => __( 'Harghita', 'classified-listing' ),
		'HD' => __( 'Hunedoara', 'classified-listing' ),
		'IL' => __( 'Ialomița', 'classified-listing' ),
		'IS' => __( 'Iași', 'classified-listing' ),
		'IF' => __( 'Ilfov', 'classified-listing' ),
		'MM' => __( 'Maramureș', 'classified-listing' ),
		'MH' => __( 'Mehedinți', 'classified-listing' ),
		'MS' => __( 'Mureș', 'classified-listing' ),
		'NT' => __( 'Neamț', 'classified-listing' ),
		'OT' => __( 'Olt', 'classified-listing' ),
		'PH' => __( 'Prahova', 'classified-listing' ),
		'SJ' => __( 'Sălaj', 'classified-listing' ),
		'SM' => __( 'Satu Mare', 'classified-listing' ),
		'SB' => __( 'Sibiu', 'classified-listing' ),
		'SV' => __( 'Suceava', 'classified-listing' ),
		'TR' => __( 'Teleorman', 'classified-listing' ),
		'TM' => __( 'Timiș', 'classified-listing' ),
		'TL' => __( 'Tulcea', 'classified-listing' ),
		'VL' => __( 'Vâlcea', 'classified-listing' ),
		'VS' => __( 'Vaslui', 'classified-listing' ),
		'VN' => __( 'Vrancea', 'classified-listing' ),
	),
	'SG' => array(),
	'SK' => array(),
	'SI' => array(),
	'SV' => array( // El Salvador states.
		'SV-AH' => __( 'Ahuachapán', 'classified-listing' ),
		'SV-CA' => __( 'Cabañas', 'classified-listing' ),
		'SV-CH' => __( 'Chalatenango', 'classified-listing' ),
		'SV-CU' => __( 'Cuscatlán', 'classified-listing' ),
		'SV-LI' => __( 'La Libertad', 'classified-listing' ),
		'SV-MO' => __( 'Morazán', 'classified-listing' ),
		'SV-PA' => __( 'La Paz', 'classified-listing' ),
		'SV-SA' => __( 'Santa Ana', 'classified-listing' ),
		'SV-SM' => __( 'San Miguel', 'classified-listing' ),
		'SV-SO' => __( 'Sonsonate', 'classified-listing' ),
		'SV-SS' => __( 'San Salvador', 'classified-listing' ),
		'SV-SV' => __( 'San Vicente', 'classified-listing' ),
		'SV-UN' => __( 'La Unión', 'classified-listing' ),
		'SV-US' => __( 'Usulután', 'classified-listing' ),
	),
	'TH' => array( // Thailand states.
		'TH-37' => __( 'Amnat Charoen', 'classified-listing' ),
		'TH-15' => __( 'Ang Thong', 'classified-listing' ),
		'TH-14' => __( 'Ayutthaya', 'classified-listing' ),
		'TH-10' => __( 'Bangkok', 'classified-listing' ),
		'TH-38' => __( 'Bueng Kan', 'classified-listing' ),
		'TH-31' => __( 'Buri Ram', 'classified-listing' ),
		'TH-24' => __( 'Chachoengsao', 'classified-listing' ),
		'TH-18' => __( 'Chai Nat', 'classified-listing' ),
		'TH-36' => __( 'Chaiyaphum', 'classified-listing' ),
		'TH-22' => __( 'Chanthaburi', 'classified-listing' ),
		'TH-50' => __( 'Chiang Mai', 'classified-listing' ),
		'TH-57' => __( 'Chiang Rai', 'classified-listing' ),
		'TH-20' => __( 'Chonburi', 'classified-listing' ),
		'TH-86' => __( 'Chumphon', 'classified-listing' ),
		'TH-46' => __( 'Kalasin', 'classified-listing' ),
		'TH-62' => __( 'Kamphaeng Phet', 'classified-listing' ),
		'TH-71' => __( 'Kanchanaburi', 'classified-listing' ),
		'TH-40' => __( 'Khon Kaen', 'classified-listing' ),
		'TH-81' => __( 'Krabi', 'classified-listing' ),
		'TH-52' => __( 'Lampang', 'classified-listing' ),
		'TH-51' => __( 'Lamphun', 'classified-listing' ),
		'TH-42' => __( 'Loei', 'classified-listing' ),
		'TH-16' => __( 'Lopburi', 'classified-listing' ),
		'TH-58' => __( 'Mae Hong Son', 'classified-listing' ),
		'TH-44' => __( 'Maha Sarakham', 'classified-listing' ),
		'TH-49' => __( 'Mukdahan', 'classified-listing' ),
		'TH-26' => __( 'Nakhon Nayok', 'classified-listing' ),
		'TH-73' => __( 'Nakhon Pathom', 'classified-listing' ),
		'TH-48' => __( 'Nakhon Phanom', 'classified-listing' ),
		'TH-30' => __( 'Nakhon Ratchasima', 'classified-listing' ),
		'TH-60' => __( 'Nakhon Sawan', 'classified-listing' ),
		'TH-80' => __( 'Nakhon Si Thammarat', 'classified-listing' ),
		'TH-55' => __( 'Nan', 'classified-listing' ),
		'TH-96' => __( 'Narathiwat', 'classified-listing' ),
		'TH-39' => __( 'Nong Bua Lam Phu', 'classified-listing' ),
		'TH-43' => __( 'Nong Khai', 'classified-listing' ),
		'TH-12' => __( 'Nonthaburi', 'classified-listing' ),
		'TH-13' => __( 'Pathum Thani', 'classified-listing' ),
		'TH-94' => __( 'Pattani', 'classified-listing' ),
		'TH-82' => __( 'Phang Nga', 'classified-listing' ),
		'TH-93' => __( 'Phatthalung', 'classified-listing' ),
		'TH-56' => __( 'Phayao', 'classified-listing' ),
		'TH-67' => __( 'Phetchabun', 'classified-listing' ),
		'TH-76' => __( 'Phetchaburi', 'classified-listing' ),
		'TH-66' => __( 'Phichit', 'classified-listing' ),
		'TH-65' => __( 'Phitsanulok', 'classified-listing' ),
		'TH-54' => __( 'Phrae', 'classified-listing' ),
		'TH-83' => __( 'Phuket', 'classified-listing' ),
		'TH-25' => __( 'Prachin Buri', 'classified-listing' ),
		'TH-77' => __( 'Prachuap Khiri Khan', 'classified-listing' ),
		'TH-85' => __( 'Ranong', 'classified-listing' ),
		'TH-70' => __( 'Ratchaburi', 'classified-listing' ),
		'TH-21' => __( 'Rayong', 'classified-listing' ),
		'TH-45' => __( 'Roi Et', 'classified-listing' ),
		'TH-27' => __( 'Sa Kaeo', 'classified-listing' ),
		'TH-47' => __( 'Sakon Nakhon', 'classified-listing' ),
		'TH-11' => __( 'Samut Prakan', 'classified-listing' ),
		'TH-74' => __( 'Samut Sakhon', 'classified-listing' ),
		'TH-75' => __( 'Samut Songkhram', 'classified-listing' ),
		'TH-19' => __( 'Saraburi', 'classified-listing' ),
		'TH-91' => __( 'Satun', 'classified-listing' ),
		'TH-17' => __( 'Sing Buri', 'classified-listing' ),
		'TH-33' => __( 'Sisaket', 'classified-listing' ),
		'TH-90' => __( 'Songkhla', 'classified-listing' ),
		'TH-64' => __( 'Sukhothai', 'classified-listing' ),
		'TH-72' => __( 'Suphan Buri', 'classified-listing' ),
		'TH-84' => __( 'Surat Thani', 'classified-listing' ),
		'TH-32' => __( 'Surin', 'classified-listing' ),
		'TH-63' => __( 'Tak', 'classified-listing' ),
		'TH-92' => __( 'Trang', 'classified-listing' ),
		'TH-23' => __( 'Trat', 'classified-listing' ),
		'TH-34' => __( 'Ubon Ratchathani', 'classified-listing' ),
		'TH-41' => __( 'Udon Thani', 'classified-listing' ),
		'TH-61' => __( 'Uthai Thani', 'classified-listing' ),
		'TH-53' => __( 'Uttaradit', 'classified-listing' ),
		'TH-95' => __( 'Yala', 'classified-listing' ),
		'TH-35' => __( 'Yasothon', 'classified-listing' ),
	),
	'TR' => array( // Turkey States.
		'TR01' => __( 'Adana', 'classified-listing' ),
		'TR02' => __( 'Adıyaman', 'classified-listing' ),
		'TR03' => __( 'Afyon', 'classified-listing' ),
		'TR04' => __( 'Ağrı', 'classified-listing' ),
		'TR05' => __( 'Amasya', 'classified-listing' ),
		'TR06' => __( 'Ankara', 'classified-listing' ),
		'TR07' => __( 'Antalya', 'classified-listing' ),
		'TR08' => __( 'Artvin', 'classified-listing' ),
		'TR09' => __( 'Aydın', 'classified-listing' ),
		'TR10' => __( 'Balıkesir', 'classified-listing' ),
		'TR11' => __( 'Bilecik', 'classified-listing' ),
		'TR12' => __( 'Bingöl', 'classified-listing' ),
		'TR13' => __( 'Bitlis', 'classified-listing' ),
		'TR14' => __( 'Bolu', 'classified-listing' ),
		'TR15' => __( 'Burdur', 'classified-listing' ),
		'TR16' => __( 'Bursa', 'classified-listing' ),
		'TR17' => __( 'Çanakkale', 'classified-listing' ),
		'TR18' => __( 'Çankırı', 'classified-listing' ),
		'TR19' => __( 'Çorum', 'classified-listing' ),
		'TR20' => __( 'Denizli', 'classified-listing' ),
		'TR21' => __( 'Diyarbakır', 'classified-listing' ),
		'TR22' => __( 'Edirne', 'classified-listing' ),
		'TR23' => __( 'Elazığ', 'classified-listing' ),
		'TR24' => __( 'Erzincan', 'classified-listing' ),
		'TR25' => __( 'Erzurum', 'classified-listing' ),
		'TR26' => __( 'Eskişehir', 'classified-listing' ),
		'TR27' => __( 'Gaziantep', 'classified-listing' ),
		'TR28' => __( 'Giresun', 'classified-listing' ),
		'TR29' => __( 'Gümüşhane', 'classified-listing' ),
		'TR30' => __( 'Hakkari', 'classified-listing' ),
		'TR31' => __( 'Hatay', 'classified-listing' ),
		'TR32' => __( 'Isparta', 'classified-listing' ),
		'TR33' => __( 'İçel', 'classified-listing' ),
		'TR34' => __( 'İstanbul', 'classified-listing' ),
		'TR35' => __( 'İzmir', 'classified-listing' ),
		'TR36' => __( 'Kars', 'classified-listing' ),
		'TR37' => __( 'Kastamonu', 'classified-listing' ),
		'TR38' => __( 'Kayseri', 'classified-listing' ),
		'TR39' => __( 'Kırklareli', 'classified-listing' ),
		'TR40' => __( 'Kırşehir', 'classified-listing' ),
		'TR41' => __( 'Kocaeli', 'classified-listing' ),
		'TR42' => __( 'Konya', 'classified-listing' ),
		'TR43' => __( 'Kütahya', 'classified-listing' ),
		'TR44' => __( 'Malatya', 'classified-listing' ),
		'TR45' => __( 'Manisa', 'classified-listing' ),
		'TR46' => __( 'Kahramanmaraş', 'classified-listing' ),
		'TR47' => __( 'Mardin', 'classified-listing' ),
		'TR48' => __( 'Muğla', 'classified-listing' ),
		'TR49' => __( 'Muş', 'classified-listing' ),
		'TR50' => __( 'Nevşehir', 'classified-listing' ),
		'TR51' => __( 'Niğde', 'classified-listing' ),
		'TR52' => __( 'Ordu', 'classified-listing' ),
		'TR53' => __( 'Rize', 'classified-listing' ),
		'TR54' => __( 'Sakarya', 'classified-listing' ),
		'TR55' => __( 'Samsun', 'classified-listing' ),
		'TR56' => __( 'Siirt', 'classified-listing' ),
		'TR57' => __( 'Sinop', 'classified-listing' ),
		'TR58' => __( 'Sivas', 'classified-listing' ),
		'TR59' => __( 'Tekirdağ', 'classified-listing' ),
		'TR60' => __( 'Tokat', 'classified-listing' ),
		'TR61' => __( 'Trabzon', 'classified-listing' ),
		'TR62' => __( 'Tunceli', 'classified-listing' ),
		'TR63' => __( 'Şanlıurfa', 'classified-listing' ),
		'TR64' => __( 'Uşak', 'classified-listing' ),
		'TR65' => __( 'Van', 'classified-listing' ),
		'TR66' => __( 'Yozgat', 'classified-listing' ),
		'TR67' => __( 'Zonguldak', 'classified-listing' ),
		'TR68' => __( 'Aksaray', 'classified-listing' ),
		'TR69' => __( 'Bayburt', 'classified-listing' ),
		'TR70' => __( 'Karaman', 'classified-listing' ),
		'TR71' => __( 'Kırıkkale', 'classified-listing' ),
		'TR72' => __( 'Batman', 'classified-listing' ),
		'TR73' => __( 'Şırnak', 'classified-listing' ),
		'TR74' => __( 'Bartın', 'classified-listing' ),
		'TR75' => __( 'Ardahan', 'classified-listing' ),
		'TR76' => __( 'Iğdır', 'classified-listing' ),
		'TR77' => __( 'Yalova', 'classified-listing' ),
		'TR78' => __( 'Karabük', 'classified-listing' ),
		'TR79' => __( 'Kilis', 'classified-listing' ),
		'TR80' => __( 'Osmaniye', 'classified-listing' ),
		'TR81' => __( 'Düzce', 'classified-listing' ),
	),
	'TZ' => array( // Tanzania States.
		'TZ01' => __( 'Arusha', 'classified-listing' ),
		'TZ02' => __( 'Dar es Salaam', 'classified-listing' ),
		'TZ03' => __( 'Dodoma', 'classified-listing' ),
		'TZ04' => __( 'Iringa', 'classified-listing' ),
		'TZ05' => __( 'Kagera', 'classified-listing' ),
		'TZ06' => __( 'Pemba North', 'classified-listing' ),
		'TZ07' => __( 'Zanzibar North', 'classified-listing' ),
		'TZ08' => __( 'Kigoma', 'classified-listing' ),
		'TZ09' => __( 'Kilimanjaro', 'classified-listing' ),
		'TZ10' => __( 'Pemba South', 'classified-listing' ),
		'TZ11' => __( 'Zanzibar South', 'classified-listing' ),
		'TZ12' => __( 'Lindi', 'classified-listing' ),
		'TZ13' => __( 'Mara', 'classified-listing' ),
		'TZ14' => __( 'Mbeya', 'classified-listing' ),
		'TZ15' => __( 'Zanzibar West', 'classified-listing' ),
		'TZ16' => __( 'Morogoro', 'classified-listing' ),
		'TZ17' => __( 'Mtwara', 'classified-listing' ),
		'TZ18' => __( 'Mwanza', 'classified-listing' ),
		'TZ19' => __( 'Coast', 'classified-listing' ),
		'TZ20' => __( 'Rukwa', 'classified-listing' ),
		'TZ21' => __( 'Ruvuma', 'classified-listing' ),
		'TZ22' => __( 'Shinyanga', 'classified-listing' ),
		'TZ23' => __( 'Singida', 'classified-listing' ),
		'TZ24' => __( 'Tabora', 'classified-listing' ),
		'TZ25' => __( 'Tanga', 'classified-listing' ),
		'TZ26' => __( 'Manyara', 'classified-listing' ),
		'TZ27' => __( 'Geita', 'classified-listing' ),
		'TZ28' => __( 'Katavi', 'classified-listing' ),
		'TZ29' => __( 'Njombe', 'classified-listing' ),
		'TZ30' => __( 'Simiyu', 'classified-listing' ),
	),
	'LK' => array(),
	'RS' => array( // Serbia districts. Ref: https://github.com/unicode-org/cldr/blob/release-37/common/subdivisions/en.xml#L4251-L4283.
		'RS00' => _x( 'Belgrade', 'district', 'classified-listing' ),
		'RS14' => _x( 'Bor', 'district', 'classified-listing' ),
		'RS11' => _x( 'Braničevo', 'district', 'classified-listing' ),
		'RS02' => _x( 'Central Banat', 'district', 'classified-listing' ),
		'RS10' => _x( 'Danube', 'district', 'classified-listing' ),
		'RS23' => _x( 'Jablanica', 'district', 'classified-listing' ),
		'RS09' => _x( 'Kolubara', 'district', 'classified-listing' ),
		'RS08' => _x( 'Mačva', 'district', 'classified-listing' ),
		'RS17' => _x( 'Morava', 'district', 'classified-listing' ),
		'RS20' => _x( 'Nišava', 'district', 'classified-listing' ),
		'RS01' => _x( 'North Bačka', 'district', 'classified-listing' ),
		'RS03' => _x( 'North Banat', 'district', 'classified-listing' ),
		'RS24' => _x( 'Pčinja', 'district', 'classified-listing' ),
		'RS22' => _x( 'Pirot', 'district', 'classified-listing' ),
		'RS13' => _x( 'Pomoravlje', 'district', 'classified-listing' ),
		'RS19' => _x( 'Rasina', 'district', 'classified-listing' ),
		'RS18' => _x( 'Raška', 'district', 'classified-listing' ),
		'RS06' => _x( 'South Bačka', 'district', 'classified-listing' ),
		'RS04' => _x( 'South Banat', 'district', 'classified-listing' ),
		'RS07' => _x( 'Srem', 'district', 'classified-listing' ),
		'RS12' => _x( 'Šumadija', 'district', 'classified-listing' ),
		'RS21' => _x( 'Toplica', 'district', 'classified-listing' ),
		'RS05' => _x( 'West Bačka', 'district', 'classified-listing' ),
		'RS15' => _x( 'Zaječar', 'district', 'classified-listing' ),
		'RS16' => _x( 'Zlatibor', 'district', 'classified-listing' ),
		'RS25' => _x( 'Kosovo', 'district', 'classified-listing' ),
		'RS26' => _x( 'Peć', 'district', 'classified-listing' ),
		'RS27' => _x( 'Prizren', 'district', 'classified-listing' ),
		'RS28' => _x( 'Kosovska Mitrovica', 'district', 'classified-listing' ),
		'RS29' => _x( 'Kosovo-Pomoravlje', 'district', 'classified-listing' ),
		'RSKM' => _x( 'Kosovo-Metohija', 'district', 'classified-listing' ),
		'RSVO' => _x( 'Vojvodina', 'district', 'classified-listing' ),
	),
	'SE' => array(),
	'UA' => array( // Ukraine. Ref: https://en.wikipedia.org/wiki/Oblasts_of_Ukraine.
		'VN' => __( 'Vinnytsia Oblast', 'classified-listing' ),
		'VL' => __( 'Volyn Oblast', 'classified-listing' ),
		'DP' => __( 'Dnipropetrovsk Oblast', 'classified-listing' ),
		'DT' => __( 'Donetsk Oblast', 'classified-listing' ),
		'ZT' => __( 'Zhytomyr Oblast', 'classified-listing' ),
		'ZK' => __( 'Zakarpattia Oblast', 'classified-listing' ),
		'ZP' => __( 'Zaporizhzhia Oblast', 'classified-listing' ),
		'IF' => __( 'Ivano-Frankivsk Oblast', 'classified-listing' ),
		'KV' => __( 'Kyiv Oblast', 'classified-listing' ),
		'KH' => __( 'Kirovohrad Oblast', 'classified-listing' ),
		'LH' => __( 'Luhansk Oblast', 'classified-listing' ),
		'LV' => __( 'Lviv Oblast', 'classified-listing' ),
		'MY' => __( 'Mykolaiv Oblast', 'classified-listing' ),
		'OD' => __( 'Odessa Oblast', 'classified-listing' ),
		'PL' => __( 'Poltava Oblast', 'classified-listing' ),
		'RV' => __( 'Rivne Oblast', 'classified-listing' ),
		'SM' => __( 'Sumy Oblast', 'classified-listing' ),
		'TP' => __( 'Ternopil Oblast', 'classified-listing' ),
		'KK' => __( 'Kharkiv Oblast', 'classified-listing' ),
		'KS' => __( 'Kherson Oblast', 'classified-listing' ),
		'KM' => __( 'Khmelnytskyi Oblast', 'classified-listing' ),
		'CK' => __( 'Cherkasy Oblast', 'classified-listing' ),
		'CH' => __( 'Chernihiv Oblast', 'classified-listing' ),
		'CV' => __( 'Chernivtsi Oblast', 'classified-listing' ),
	),
	'UG' => array( // Uganda districts. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:UG.
		'UG314' => __( 'Abim', 'classified-listing' ),
		'UG301' => __( 'Adjumani', 'classified-listing' ),
		'UG322' => __( 'Agago', 'classified-listing' ),
		'UG323' => __( 'Alebtong', 'classified-listing' ),
		'UG315' => __( 'Amolatar', 'classified-listing' ),
		'UG324' => __( 'Amudat', 'classified-listing' ),
		'UG216' => __( 'Amuria', 'classified-listing' ),
		'UG316' => __( 'Amuru', 'classified-listing' ),
		'UG302' => __( 'Apac', 'classified-listing' ),
		'UG303' => __( 'Arua', 'classified-listing' ),
		'UG217' => __( 'Budaka', 'classified-listing' ),
		'UG218' => __( 'Bududa', 'classified-listing' ),
		'UG201' => __( 'Bugiri', 'classified-listing' ),
		'UG235' => __( 'Bugweri', 'classified-listing' ),
		'UG420' => __( 'Buhweju', 'classified-listing' ),
		'UG117' => __( 'Buikwe', 'classified-listing' ),
		'UG219' => __( 'Bukedea', 'classified-listing' ),
		'UG118' => __( 'Bukomansimbi', 'classified-listing' ),
		'UG220' => __( 'Bukwa', 'classified-listing' ),
		'UG225' => __( 'Bulambuli', 'classified-listing' ),
		'UG416' => __( 'Buliisa', 'classified-listing' ),
		'UG401' => __( 'Bundibugyo', 'classified-listing' ),
		'UG430' => __( 'Bunyangabu', 'classified-listing' ),
		'UG402' => __( 'Bushenyi', 'classified-listing' ),
		'UG202' => __( 'Busia', 'classified-listing' ),
		'UG221' => __( 'Butaleja', 'classified-listing' ),
		'UG119' => __( 'Butambala', 'classified-listing' ),
		'UG233' => __( 'Butebo', 'classified-listing' ),
		'UG120' => __( 'Buvuma', 'classified-listing' ),
		'UG226' => __( 'Buyende', 'classified-listing' ),
		'UG317' => __( 'Dokolo', 'classified-listing' ),
		'UG121' => __( 'Gomba', 'classified-listing' ),
		'UG304' => __( 'Gulu', 'classified-listing' ),
		'UG403' => __( 'Hoima', 'classified-listing' ),
		'UG417' => __( 'Ibanda', 'classified-listing' ),
		'UG203' => __( 'Iganga', 'classified-listing' ),
		'UG418' => __( 'Isingiro', 'classified-listing' ),
		'UG204' => __( 'Jinja', 'classified-listing' ),
		'UG318' => __( 'Kaabong', 'classified-listing' ),
		'UG404' => __( 'Kabale', 'classified-listing' ),
		'UG405' => __( 'Kabarole', 'classified-listing' ),
		'UG213' => __( 'Kaberamaido', 'classified-listing' ),
		'UG427' => __( 'Kagadi', 'classified-listing' ),
		'UG428' => __( 'Kakumiro', 'classified-listing' ),
		'UG101' => __( 'Kalangala', 'classified-listing' ),
		'UG222' => __( 'Kaliro', 'classified-listing' ),
		'UG122' => __( 'Kalungu', 'classified-listing' ),
		'UG102' => __( 'Kampala', 'classified-listing' ),
		'UG205' => __( 'Kamuli', 'classified-listing' ),
		'UG413' => __( 'Kamwenge', 'classified-listing' ),
		'UG414' => __( 'Kanungu', 'classified-listing' ),
		'UG206' => __( 'Kapchorwa', 'classified-listing' ),
		'UG236' => __( 'Kapelebyong', 'classified-listing' ),
		'UG126' => __( 'Kasanda', 'classified-listing' ),
		'UG406' => __( 'Kasese', 'classified-listing' ),
		'UG207' => __( 'Katakwi', 'classified-listing' ),
		'UG112' => __( 'Kayunga', 'classified-listing' ),
		'UG407' => __( 'Kibaale', 'classified-listing' ),
		'UG103' => __( 'Kiboga', 'classified-listing' ),
		'UG227' => __( 'Kibuku', 'classified-listing' ),
		'UG432' => __( 'Kikuube', 'classified-listing' ),
		'UG419' => __( 'Kiruhura', 'classified-listing' ),
		'UG421' => __( 'Kiryandongo', 'classified-listing' ),
		'UG408' => __( 'Kisoro', 'classified-listing' ),
		'UG305' => __( 'Kitgum', 'classified-listing' ),
		'UG319' => __( 'Koboko', 'classified-listing' ),
		'UG325' => __( 'Kole', 'classified-listing' ),
		'UG306' => __( 'Kotido', 'classified-listing' ),
		'UG208' => __( 'Kumi', 'classified-listing' ),
		'UG333' => __( 'Kwania', 'classified-listing' ),
		'UG228' => __( 'Kween', 'classified-listing' ),
		'UG123' => __( 'Kyankwanzi', 'classified-listing' ),
		'UG422' => __( 'Kyegegwa', 'classified-listing' ),
		'UG415' => __( 'Kyenjojo', 'classified-listing' ),
		'UG125' => __( 'Kyotera', 'classified-listing' ),
		'UG326' => __( 'Lamwo', 'classified-listing' ),
		'UG307' => __( 'Lira', 'classified-listing' ),
		'UG229' => __( 'Luuka', 'classified-listing' ),
		'UG104' => __( 'Luwero', 'classified-listing' ),
		'UG124' => __( 'Lwengo', 'classified-listing' ),
		'UG114' => __( 'Lyantonde', 'classified-listing' ),
		'UG223' => __( 'Manafwa', 'classified-listing' ),
		'UG320' => __( 'Maracha', 'classified-listing' ),
		'UG105' => __( 'Masaka', 'classified-listing' ),
		'UG409' => __( 'Masindi', 'classified-listing' ),
		'UG214' => __( 'Mayuge', 'classified-listing' ),
		'UG209' => __( 'Mbale', 'classified-listing' ),
		'UG410' => __( 'Mbarara', 'classified-listing' ),
		'UG423' => __( 'Mitooma', 'classified-listing' ),
		'UG115' => __( 'Mityana', 'classified-listing' ),
		'UG308' => __( 'Moroto', 'classified-listing' ),
		'UG309' => __( 'Moyo', 'classified-listing' ),
		'UG106' => __( 'Mpigi', 'classified-listing' ),
		'UG107' => __( 'Mubende', 'classified-listing' ),
		'UG108' => __( 'Mukono', 'classified-listing' ),
		'UG334' => __( 'Nabilatuk', 'classified-listing' ),
		'UG311' => __( 'Nakapiripirit', 'classified-listing' ),
		'UG116' => __( 'Nakaseke', 'classified-listing' ),
		'UG109' => __( 'Nakasongola', 'classified-listing' ),
		'UG230' => __( 'Namayingo', 'classified-listing' ),
		'UG234' => __( 'Namisindwa', 'classified-listing' ),
		'UG224' => __( 'Namutumba', 'classified-listing' ),
		'UG327' => __( 'Napak', 'classified-listing' ),
		'UG310' => __( 'Nebbi', 'classified-listing' ),
		'UG231' => __( 'Ngora', 'classified-listing' ),
		'UG424' => __( 'Ntoroko', 'classified-listing' ),
		'UG411' => __( 'Ntungamo', 'classified-listing' ),
		'UG328' => __( 'Nwoya', 'classified-listing' ),
		'UG331' => __( 'Omoro', 'classified-listing' ),
		'UG329' => __( 'Otuke', 'classified-listing' ),
		'UG321' => __( 'Oyam', 'classified-listing' ),
		'UG312' => __( 'Pader', 'classified-listing' ),
		'UG332' => __( 'Pakwach', 'classified-listing' ),
		'UG210' => __( 'Pallisa', 'classified-listing' ),
		'UG110' => __( 'Rakai', 'classified-listing' ),
		'UG429' => __( 'Rubanda', 'classified-listing' ),
		'UG425' => __( 'Rubirizi', 'classified-listing' ),
		'UG431' => __( 'Rukiga', 'classified-listing' ),
		'UG412' => __( 'Rukungiri', 'classified-listing' ),
		'UG111' => __( 'Sembabule', 'classified-listing' ),
		'UG232' => __( 'Serere', 'classified-listing' ),
		'UG426' => __( 'Sheema', 'classified-listing' ),
		'UG215' => __( 'Sironko', 'classified-listing' ),
		'UG211' => __( 'Soroti', 'classified-listing' ),
		'UG212' => __( 'Tororo', 'classified-listing' ),
		'UG113' => __( 'Wakiso', 'classified-listing' ),
		'UG313' => __( 'Yumbe', 'classified-listing' ),
		'UG330' => __( 'Zombo', 'classified-listing' ),
	),
	'UM' => array(
		'81' => __( 'Baker Island', 'classified-listing' ),
		'84' => __( 'Howland Island', 'classified-listing' ),
		'86' => __( 'Jarvis Island', 'classified-listing' ),
		'67' => __( 'Johnston Atoll', 'classified-listing' ),
		'89' => __( 'Kingman Reef', 'classified-listing' ),
		'71' => __( 'Midway Atoll', 'classified-listing' ),
		'76' => __( 'Navassa Island', 'classified-listing' ),
		'95' => __( 'Palmyra Atoll', 'classified-listing' ),
		'79' => __( 'Wake Island', 'classified-listing' ),
	),
	'US' => array( // United States.
		'AL' => __( 'Alabama', 'classified-listing' ),
		'AK' => __( 'Alaska', 'classified-listing' ),
		'AZ' => __( 'Arizona', 'classified-listing' ),
		'AR' => __( 'Arkansas', 'classified-listing' ),
		'CA' => __( 'California', 'classified-listing' ),
		'CO' => __( 'Colorado', 'classified-listing' ),
		'CT' => __( 'Connecticut', 'classified-listing' ),
		'DE' => __( 'Delaware', 'classified-listing' ),
		'DC' => __( 'District Of Columbia', 'classified-listing' ),
		'FL' => __( 'Florida', 'classified-listing' ),
		'GA' => _x( 'Georgia', 'US state of Georgia', 'classified-listing' ),
		'HI' => __( 'Hawaii', 'classified-listing' ),
		'ID' => __( 'Idaho', 'classified-listing' ),
		'IL' => __( 'Illinois', 'classified-listing' ),
		'IN' => __( 'Indiana', 'classified-listing' ),
		'IA' => __( 'Iowa', 'classified-listing' ),
		'KS' => __( 'Kansas', 'classified-listing' ),
		'KY' => __( 'Kentucky', 'classified-listing' ),
		'LA' => __( 'Louisiana', 'classified-listing' ),
		'ME' => __( 'Maine', 'classified-listing' ),
		'MD' => __( 'Maryland', 'classified-listing' ),
		'MA' => __( 'Massachusetts', 'classified-listing' ),
		'MI' => __( 'Michigan', 'classified-listing' ),
		'MN' => __( 'Minnesota', 'classified-listing' ),
		'MS' => __( 'Mississippi', 'classified-listing' ),
		'MO' => __( 'Missouri', 'classified-listing' ),
		'MT' => __( 'Montana', 'classified-listing' ),
		'NE' => __( 'Nebraska', 'classified-listing' ),
		'NV' => __( 'Nevada', 'classified-listing' ),
		'NH' => __( 'New Hampshire', 'classified-listing' ),
		'NJ' => __( 'New Jersey', 'classified-listing' ),
		'NM' => __( 'New Mexico', 'classified-listing' ),
		'NY' => __( 'New York', 'classified-listing' ),
		'NC' => __( 'North Carolina', 'classified-listing' ),
		'ND' => __( 'North Dakota', 'classified-listing' ),
		'OH' => __( 'Ohio', 'classified-listing' ),
		'OK' => __( 'Oklahoma', 'classified-listing' ),
		'OR' => __( 'Oregon', 'classified-listing' ),
		'PA' => __( 'Pennsylvania', 'classified-listing' ),
		'RI' => __( 'Rhode Island', 'classified-listing' ),
		'SC' => __( 'South Carolina', 'classified-listing' ),
		'SD' => __( 'South Dakota', 'classified-listing' ),
		'TN' => __( 'Tennessee', 'classified-listing' ),
		'TX' => __( 'Texas', 'classified-listing' ),
		'UT' => __( 'Utah', 'classified-listing' ),
		'VT' => __( 'Vermont', 'classified-listing' ),
		'VA' => __( 'Virginia', 'classified-listing' ),
		'WA' => __( 'Washington', 'classified-listing' ),
		'WV' => __( 'West Virginia', 'classified-listing' ),
		'WI' => __( 'Wisconsin', 'classified-listing' ),
		'WY' => __( 'Wyoming', 'classified-listing' ),
		'AA' => __( 'Armed Forces (AA)', 'classified-listing' ),
		'AE' => __( 'Armed Forces (AE)', 'classified-listing' ),
		'AP' => __( 'Armed Forces (AP)', 'classified-listing' ),
	),
	'UY' => array( // Uruguay States.
		'UY-AR' => __( 'Artigas', 'classified-listing' ),
		'UY-CA' => __( 'Canelones', 'classified-listing' ),
		'UY-CL' => __( 'Cerro Largo', 'classified-listing' ),
		'UY-CO' => __( 'Colonia', 'classified-listing' ),
		'UY-DU' => __( 'Durazno', 'classified-listing' ),
		'UY-FS' => __( 'Flores', 'classified-listing' ),
		'UY-FD' => __( 'Florida', 'classified-listing' ),
		'UY-LA' => __( 'Lavalleja', 'classified-listing' ),
		'UY-MA' => __( 'Maldonado', 'classified-listing' ),
		'UY-MO' => __( 'Montevideo', 'classified-listing' ),
		'UY-PA' => __( 'Paysandú', 'classified-listing' ),
		'UY-RN' => __( 'Río Negro', 'classified-listing' ),
		'UY-RV' => __( 'Rivera', 'classified-listing' ),
		'UY-RO' => __( 'Rocha', 'classified-listing' ),
		'UY-SA' => __( 'Salto', 'classified-listing' ),
		'UY-SJ' => __( 'San José', 'classified-listing' ),
		'UY-SO' => __( 'Soriano', 'classified-listing' ),
		'UY-TA' => __( 'Tacuarembó', 'classified-listing' ),
		'UY-TT' => __( 'Treinta y Tres', 'classified-listing' ),
	),
	'VE' => array( // Venezuela States.
		'VE-A' => __( 'Capital', 'classified-listing' ),
		'VE-B' => __( 'Anzoátegui', 'classified-listing' ),
		'VE-C' => __( 'Apure', 'classified-listing' ),
		'VE-D' => __( 'Aragua', 'classified-listing' ),
		'VE-E' => __( 'Barinas', 'classified-listing' ),
		'VE-F' => __( 'Bolívar', 'classified-listing' ),
		'VE-G' => __( 'Carabobo', 'classified-listing' ),
		'VE-H' => __( 'Cojedes', 'classified-listing' ),
		'VE-I' => __( 'Falcón', 'classified-listing' ),
		'VE-J' => __( 'Guárico', 'classified-listing' ),
		'VE-K' => __( 'Lara', 'classified-listing' ),
		'VE-L' => __( 'Mérida', 'classified-listing' ),
		'VE-M' => __( 'Miranda', 'classified-listing' ),
		'VE-N' => __( 'Monagas', 'classified-listing' ),
		'VE-O' => __( 'Nueva Esparta', 'classified-listing' ),
		'VE-P' => __( 'Portuguesa', 'classified-listing' ),
		'VE-R' => __( 'Sucre', 'classified-listing' ),
		'VE-S' => __( 'Táchira', 'classified-listing' ),
		'VE-T' => __( 'Trujillo', 'classified-listing' ),
		'VE-U' => __( 'Yaracuy', 'classified-listing' ),
		'VE-V' => __( 'Zulia', 'classified-listing' ),
		'VE-W' => __( 'Federal Dependencies', 'classified-listing' ),
		'VE-X' => __( 'La Guaira (Vargas)', 'classified-listing' ),
		'VE-Y' => __( 'Delta Amacuro', 'classified-listing' ),
		'VE-Z' => __( 'Amazonas', 'classified-listing' ),
	),
	'VN' => array(),
	'YT' => array(),
	'ZA' => array( // South African states.
		'EC'  => __( 'Eastern Cape', 'classified-listing' ),
		'FS'  => __( 'Free State', 'classified-listing' ),
		'GP'  => __( 'Gauteng', 'classified-listing' ),
		'KZN' => __( 'KwaZulu-Natal', 'classified-listing' ),
		'LP'  => __( 'Limpopo', 'classified-listing' ),
		'MP'  => __( 'Mpumalanga', 'classified-listing' ),
		'NC'  => __( 'Northern Cape', 'classified-listing' ),
		'NW'  => __( 'North West', 'classified-listing' ),
		'WC'  => __( 'Western Cape', 'classified-listing' ),
	),
	'ZM' => array( // Zambia's Provinces. Ref: https://en.wikipedia.org/wiki/ISO_3166-2:ZM.
		'ZM-01' => __( 'Western', 'classified-listing' ),
		'ZM-02' => __( 'Central', 'classified-listing' ),
		'ZM-03' => __( 'Eastern', 'classified-listing' ),
		'ZM-04' => __( 'Luapula', 'classified-listing' ),
		'ZM-05' => __( 'Northern', 'classified-listing' ),
		'ZM-06' => __( 'North-Western', 'classified-listing' ),
		'ZM-07' => __( 'Southern', 'classified-listing' ),
		'ZM-08' => __( 'Copperbelt', 'classified-listing' ),
		'ZM-09' => __( 'Lusaka', 'classified-listing' ),
		'ZM-10' => __( 'Muchinga', 'classified-listing' ),
	),
	'ZW' => array( // Zimbabwe's states
		'BU' => __( 'Bulawayo Province', 'classified-listing' ),
		'HA' => __( 'Harare Province', 'classified-listing' ),
		'MA' => __( 'Manicaland', 'classified-listing' ),
		'MC' => __( 'Mashonaland Central Province', 'classified-listing' ),
		'ME' => __( 'Mashonaland East Province', 'classified-listing' ),
		'MW' => __( 'Mashonaland West Province', 'classified-listing' ),
		'MV' => __( 'Masvingo Province', 'classified-listing' ),
		'MN' => __( 'Matabeleland North Province', 'classified-listing' ),
		'MS' => __( 'Matabeleland South Province', 'classified-listing' ),
		'MI' => __( 'Midlands Province', 'classified-listing' ),
	),
);
