<?php
/**
 * Countries
 *
 * Returns an array of countries and codes.
 * Country codes and names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/displaynames/country-names).
 *
 * See https://github.com/unicode-org/cldr/blob/master/common/subdivisions/en.xml
 *
 * @package ClassifiedListing\i18n
 * @version 2.2.0
 */

defined('ABSPATH') || exit;

return array(
	'AF' => __('Afghanistan', 'classified-listing'),
	'AX' => __('Åland Islands', 'classified-listing'),
	'AL' => __('Albania', 'classified-listing'),
	'DZ' => __('Algeria', 'classified-listing'),
	'AS' => __('American Samoa', 'classified-listing'),
	'AD' => __('Andorra', 'classified-listing'),
	'AO' => __('Angola', 'classified-listing'),
	'AI' => __('Anguilla', 'classified-listing'),
	'AQ' => __('Antarctica', 'classified-listing'),
	'AG' => __('Antigua and Barbuda', 'classified-listing'),
	'AR' => __('Argentina', 'classified-listing'),
	'AM' => __('Armenia', 'classified-listing'),
	'AW' => __('Aruba', 'classified-listing'),
	'AU' => __('Australia', 'classified-listing'),
	'AT' => __('Austria', 'classified-listing'),
	'AZ' => __('Azerbaijan', 'classified-listing'),
	'BS' => __('Bahamas', 'classified-listing'),
	'BH' => __('Bahrain', 'classified-listing'),
	'BD' => __('Bangladesh', 'classified-listing'),
	'BB' => __('Barbados', 'classified-listing'),
	'BY' => __('Belarus', 'classified-listing'),
	'BE' => __('Belgium', 'classified-listing'),
	'PW' => __('Belau', 'classified-listing'),
	'BZ' => __('Belize', 'classified-listing'),
	'BJ' => __('Benin', 'classified-listing'),
	'BM' => __('Bermuda', 'classified-listing'),
	'BT' => __('Bhutan', 'classified-listing'),
	'BO' => __('Bolivia', 'classified-listing'),
	'BQ' => __('Bonaire, Saint Eustatius and Saba', 'classified-listing'),
	'BA' => __('Bosnia and Herzegovina', 'classified-listing'),
	'BW' => __('Botswana', 'classified-listing'),
	'BV' => __('Bouvet Island', 'classified-listing'),
	'BR' => __('Brazil', 'classified-listing'),
	'IO' => __('British Indian Ocean Territory', 'classified-listing'),
	'BN' => __('Brunei', 'classified-listing'),
	'BG' => __('Bulgaria', 'classified-listing'),
	'BF' => __('Burkina Faso', 'classified-listing'),
	'BI' => __('Burundi', 'classified-listing'),
	'KH' => __('Cambodia', 'classified-listing'),
	'CM' => __('Cameroon', 'classified-listing'),
	'CA' => __('Canada', 'classified-listing'),
	'CV' => __('Cape Verde', 'classified-listing'),
	'KY' => __('Cayman Islands', 'classified-listing'),
	'CF' => __('Central African Republic', 'classified-listing'),
	'TD' => __('Chad', 'classified-listing'),
	'CL' => __('Chile', 'classified-listing'),
	'CN' => __('China', 'classified-listing'),
	'CX' => __('Christmas Island', 'classified-listing'),
	'CC' => __('Cocos (Keeling) Islands', 'classified-listing'),
	'CO' => __('Colombia', 'classified-listing'),
	'KM' => __('Comoros', 'classified-listing'),
	'CG' => __('Congo (Brazzaville)', 'classified-listing'),
	'CD' => __('Congo (Kinshasa)', 'classified-listing'),
	'CK' => __('Cook Islands', 'classified-listing'),
	'CR' => __('Costa Rica', 'classified-listing'),
	'HR' => __('Croatia', 'classified-listing'),
	'CU' => __('Cuba', 'classified-listing'),
	'CW' => __('Cura&ccedil;ao', 'classified-listing'),
	'CY' => __('Cyprus', 'classified-listing'),
	'CZ' => __('Czech Republic', 'classified-listing'),
	'DK' => __('Denmark', 'classified-listing'),
	'DJ' => __('Djibouti', 'classified-listing'),
	'DM' => __('Dominica', 'classified-listing'),
	'DO' => __('Dominican Republic', 'classified-listing'),
	'EC' => __('Ecuador', 'classified-listing'),
	'EG' => __('Egypt', 'classified-listing'),
	'SV' => __('El Salvador', 'classified-listing'),
	'GQ' => __('Equatorial Guinea', 'classified-listing'),
	'ER' => __('Eritrea', 'classified-listing'),
	'EE' => __('Estonia', 'classified-listing'),
	'ET' => __('Ethiopia', 'classified-listing'),
	'FK' => __('Falkland Islands', 'classified-listing'),
	'FO' => __('Faroe Islands', 'classified-listing'),
	'FJ' => __('Fiji', 'classified-listing'),
	'FI' => __('Finland', 'classified-listing'),
	'FR' => __('France', 'classified-listing'),
	'GF' => __('French Guiana', 'classified-listing'),
	'PF' => __('French Polynesia', 'classified-listing'),
	'TF' => __('French Southern Territories', 'classified-listing'),
	'GA' => __('Gabon', 'classified-listing'),
	'GM' => __('Gambia', 'classified-listing'),
	'GE' => __('Georgia', 'classified-listing'),
	'DE' => __('Germany', 'classified-listing'),
	'GH' => __('Ghana', 'classified-listing'),
	'GI' => __('Gibraltar', 'classified-listing'),
	'GR' => __('Greece', 'classified-listing'),
	'GL' => __('Greenland', 'classified-listing'),
	'GD' => __('Grenada', 'classified-listing'),
	'GP' => __('Guadeloupe', 'classified-listing'),
	'GU' => __('Guam', 'classified-listing'),
	'GT' => __('Guatemala', 'classified-listing'),
	'GG' => __('Guernsey', 'classified-listing'),
	'GN' => __('Guinea', 'classified-listing'),
	'GW' => __('Guinea-Bissau', 'classified-listing'),
	'GY' => __('Guyana', 'classified-listing'),
	'HT' => __('Haiti', 'classified-listing'),
	'HM' => __('Heard Island and McDonald Islands', 'classified-listing'),
	'HN' => __('Honduras', 'classified-listing'),
	'HK' => __('Hong Kong', 'classified-listing'),
	'HU' => __('Hungary', 'classified-listing'),
	'IS' => __('Iceland', 'classified-listing'),
	'IN' => __('India', 'classified-listing'),
	'ID' => __('Indonesia', 'classified-listing'),
	'IR' => __('Iran', 'classified-listing'),
	'IQ' => __('Iraq', 'classified-listing'),
	'IE' => __('Ireland', 'classified-listing'),
	'IM' => __('Isle of Man', 'classified-listing'),
	'IL' => __('Israel', 'classified-listing'),
	'IT' => __('Italy', 'classified-listing'),
	'CI' => __('Ivory Coast', 'classified-listing'),
	'JM' => __('Jamaica', 'classified-listing'),
	'JP' => __('Japan', 'classified-listing'),
	'JE' => __('Jersey', 'classified-listing'),
	'JO' => __('Jordan', 'classified-listing'),
	'KZ' => __('Kazakhstan', 'classified-listing'),
	'KE' => __('Kenya', 'classified-listing'),
	'KI' => __('Kiribati', 'classified-listing'),
	'KW' => __('Kuwait', 'classified-listing'),
	'KG' => __('Kyrgyzstan', 'classified-listing'),
	'LA' => __('Laos', 'classified-listing'),
	'LV' => __('Latvia', 'classified-listing'),
	'LB' => __('Lebanon', 'classified-listing'),
	'LS' => __('Lesotho', 'classified-listing'),
	'LR' => __('Liberia', 'classified-listing'),
	'LY' => __('Libya', 'classified-listing'),
	'LI' => __('Liechtenstein', 'classified-listing'),
	'LT' => __('Lithuania', 'classified-listing'),
	'LU' => __('Luxembourg', 'classified-listing'),
	'MO' => __('Macao', 'classified-listing'),
	'MK' => __('North Macedonia', 'classified-listing'),
	'MG' => __('Madagascar', 'classified-listing'),
	'MW' => __('Malawi', 'classified-listing'),
	'MY' => __('Malaysia', 'classified-listing'),
	'MV' => __('Maldives', 'classified-listing'),
	'ML' => __('Mali', 'classified-listing'),
	'MT' => __('Malta', 'classified-listing'),
	'MH' => __('Marshall Islands', 'classified-listing'),
	'MQ' => __('Martinique', 'classified-listing'),
	'MR' => __('Mauritania', 'classified-listing'),
	'MU' => __('Mauritius', 'classified-listing'),
	'YT' => __('Mayotte', 'classified-listing'),
	'MX' => __('Mexico', 'classified-listing'),
	'FM' => __('Micronesia', 'classified-listing'),
	'MD' => __('Moldova', 'classified-listing'),
	'MC' => __('Monaco', 'classified-listing'),
	'MN' => __('Mongolia', 'classified-listing'),
	'ME' => __('Montenegro', 'classified-listing'),
	'MS' => __('Montserrat', 'classified-listing'),
	'MA' => __('Morocco', 'classified-listing'),
	'MZ' => __('Mozambique', 'classified-listing'),
	'MM' => __('Myanmar', 'classified-listing'),
	'NA' => __('Namibia', 'classified-listing'),
	'NR' => __('Nauru', 'classified-listing'),
	'NP' => __('Nepal', 'classified-listing'),
	'NL' => __('Netherlands', 'classified-listing'),
	'NC' => __('New Caledonia', 'classified-listing'),
	'NZ' => __('New Zealand', 'classified-listing'),
	'NI' => __('Nicaragua', 'classified-listing'),
	'NE' => __('Niger', 'classified-listing'),
	'NG' => __('Nigeria', 'classified-listing'),
	'NU' => __('Niue', 'classified-listing'),
	'NF' => __('Norfolk Island', 'classified-listing'),
	'MP' => __('Northern Mariana Islands', 'classified-listing'),
	'KP' => __('North Korea', 'classified-listing'),
	'NO' => __('Norway', 'classified-listing'),
	'OM' => __('Oman', 'classified-listing'),
	'PK' => __('Pakistan', 'classified-listing'),
	'PS' => __('Palestinian Territory', 'classified-listing'),
	'PA' => __('Panama', 'classified-listing'),
	'PG' => __('Papua New Guinea', 'classified-listing'),
	'PY' => __('Paraguay', 'classified-listing'),
	'PE' => __('Peru', 'classified-listing'),
	'PH' => __('Philippines', 'classified-listing'),
	'PN' => __('Pitcairn', 'classified-listing'),
	'PL' => __('Poland', 'classified-listing'),
	'PT' => __('Portugal', 'classified-listing'),
	'PR' => __('Puerto Rico', 'classified-listing'),
	'QA' => __('Qatar', 'classified-listing'),
	'RE' => __('Reunion', 'classified-listing'),
	'RO' => __('Romania', 'classified-listing'),
	'RU' => __('Russia', 'classified-listing'),
	'RW' => __('Rwanda', 'classified-listing'),
	'BL' => __('Saint Barth&eacute;lemy', 'classified-listing'),
	'SH' => __('Saint Helena', 'classified-listing'),
	'KN' => __('Saint Kitts and Nevis', 'classified-listing'),
	'LC' => __('Saint Lucia', 'classified-listing'),
	'MF' => __('Saint Martin (French part)', 'classified-listing'),
	'SX' => __('Saint Martin (Dutch part)', 'classified-listing'),
	'PM' => __('Saint Pierre and Miquelon', 'classified-listing'),
	'VC' => __('Saint Vincent and the Grenadines', 'classified-listing'),
	'SM' => __('San Marino', 'classified-listing'),
	'ST' => __('S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'classified-listing'),
	'SA' => __('Saudi Arabia', 'classified-listing'),
	'SN' => __('Senegal', 'classified-listing'),
	'RS' => __('Serbia', 'classified-listing'),
	'SC' => __('Seychelles', 'classified-listing'),
	'SL' => __('Sierra Leone', 'classified-listing'),
	'SG' => __('Singapore', 'classified-listing'),
	'SK' => __('Slovakia', 'classified-listing'),
	'SI' => __('Slovenia', 'classified-listing'),
	'SB' => __('Solomon Islands', 'classified-listing'),
	'SO' => __('Somalia', 'classified-listing'),
	'ZA' => __('South Africa', 'classified-listing'),
	'GS' => __('South Georgia/Sandwich Islands', 'classified-listing'),
	'KR' => __('South Korea', 'classified-listing'),
	'SS' => __('South Sudan', 'classified-listing'),
	'ES' => __('Spain', 'classified-listing'),
	'LK' => __('Sri Lanka', 'classified-listing'),
	'SD' => __('Sudan', 'classified-listing'),
	'SR' => __('Suriname', 'classified-listing'),
	'SJ' => __('Svalbard and Jan Mayen', 'classified-listing'),
	'SZ' => __('Swaziland', 'classified-listing'),
	'SE' => __('Sweden', 'classified-listing'),
	'CH' => __('Switzerland', 'classified-listing'),
	'SY' => __('Syria', 'classified-listing'),
	'TW' => __('Taiwan', 'classified-listing'),
	'TJ' => __('Tajikistan', 'classified-listing'),
	'TZ' => __('Tanzania', 'classified-listing'),
	'TH' => __('Thailand', 'classified-listing'),
	'TL' => __('Timor-Leste', 'classified-listing'),
	'TG' => __('Togo', 'classified-listing'),
	'TK' => __('Tokelau', 'classified-listing'),
	'TO' => __('Tonga', 'classified-listing'),
	'TT' => __('Trinidad and Tobago', 'classified-listing'),
	'TN' => __('Tunisia', 'classified-listing'),
	'TR' => __('Turkey', 'classified-listing'),
	'TM' => __('Turkmenistan', 'classified-listing'),
	'TC' => __('Turks and Caicos Islands', 'classified-listing'),
	'TV' => __('Tuvalu', 'classified-listing'),
	'UG' => __('Uganda', 'classified-listing'),
	'UA' => __('Ukraine', 'classified-listing'),
	'AE' => __('United Arab Emirates', 'classified-listing'),
	'GB' => __('United Kingdom (UK)', 'classified-listing'),
	'US' => __('United States (US)', 'classified-listing'),
	'UM' => __('United States (US) Minor Outlying Islands', 'classified-listing'),
	'UY' => __('Uruguay', 'classified-listing'),
	'UZ' => __('Uzbekistan', 'classified-listing'),
	'VU' => __('Vanuatu', 'classified-listing'),
	'VA' => __('Vatican', 'classified-listing'),
	'VE' => __('Venezuela', 'classified-listing'),
	'VN' => __('Vietnam', 'classified-listing'),
	'VG' => __('Virgin Islands (British)', 'classified-listing'),
	'VI' => __('Virgin Islands (US)', 'classified-listing'),
	'WF' => __('Wallis and Futuna', 'classified-listing'),
	'EH' => __('Western Sahara', 'classified-listing'),
	'WS' => __('Samoa', 'classified-listing'),
	'YE' => __('Yemen', 'classified-listing'),
	'ZM' => __('Zambia', 'classified-listing'),
	'ZW' => __('Zimbabwe', 'classified-listing'),
);
