<?php
if ( ! defined('ABSPATH') ) exit;

add_action('admin_menu', function(){
    add_options_page(
        __('Classic Menu Accessible (A11y) menu', 'classic-menu-accessible-a11y'), // EN default
        __('Classic Menu Accessible (A11y) menu', 'classic-menu-accessible-a11y'),
        'manage_options',
        'classic-menu-accessible-a11y',
        'classicmenua11y_render_settings_page'
    );
});

add_action('admin_init', function(){
    register_setting('classicmenua11y_group', 'classicmenua11y_options', [
        'type' => 'array',
        'sanitize_callback' => 'classicmenua11y_sanitize_options',
        'default' => []
    ]);

    // Sections (EN by default)
    add_settings_section('classicmenua11y_section_l1', __('Top level (main links)', 'classic-menu-accessible-a11y'), function(){
        echo '<p>'. esc_html__('Set colors for the top-level items. Use sufficient contrast.', 'classic-menu-accessible-a11y') .'</p>';
    }, 'classic-menu-accessible-a11y');

    add_settings_field('level1_text', __('Text', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_l1', ['key'=>'level1_text']);
    add_settings_field('level1_bg',   __('Background', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_l1', ['key'=>'level1_bg']);
    add_settings_field('level1_text_hover', __('Text (hover/focus)', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_l1', ['key'=>'level1_text_hover']);
    add_settings_field('level1_bg_hover',   __('Background (hover/focus)', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_l1', ['key'=>'level1_bg_hover']);

    add_settings_section('classicmenua11y_section_sub', __('Submenu', 'classic-menu-accessible-a11y'), function(){
        echo '<p>'. esc_html__('Set colors for submenu panels and links.', 'classic-menu-accessible-a11y') .'</p>';
    }, 'classic-menu-accessible-a11y');

    add_settings_field('sub_text', __('Text', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_sub', ['key'=>'sub_text']);
    add_settings_field('sub_bg',   __('Background', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_sub', ['key'=>'sub_bg']);
    add_settings_field('sub_text_hover', __('Text (hover/focus)', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_sub', ['key'=>'sub_text_hover']);
    add_settings_field('sub_bg_hover',   __('Background (hover/focus)', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_sub', ['key'=>'sub_bg_hover']);

    add_settings_section('classicmenua11y_section_ui', __('Icon, Typography & Mobile', 'classic-menu-accessible-a11y'), function(){
        echo '<p>'. esc_html__('Choose a simple icon, a legible font, and configure mobile hamburger colors.', 'classic-menu-accessible-a11y') .'</p>';
    }, 'classic-menu-accessible-a11y');

    add_settings_field('icon', __('Submenu icon', 'classic-menu-accessible-a11y'), 'classicmenua11y_icon_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_ui');
    add_settings_field('font_family', __('Menu typography', 'classic-menu-accessible-a11y'), 'classicmenua11y_font_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_ui');
    add_settings_field('text_size', __('Text size (px)', 'classic-menu-accessible-a11y'),'classicmenua11y_text_size_field','classic-menu-accessible-a11y','classicmenua11y_section_ui');


    add_settings_field('hamburger', __('Mobile hamburger icon color', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_ui', ['key'=>'hamburger']);
    add_settings_field('hamburger_bg', __('Mobile hamburger background', 'classic-menu-accessible-a11y'), 'classicmenua11y_color_field', 'classic-menu-accessible-a11y', 'classicmenua11y_section_ui', ['key'=>'hamburger_bg']);
    
});

function classicmenua11y_sanitize_options($input){
    $out = [];
    $keys = ['level1_text','level1_bg','level1_text_hover','level1_bg_hover','sub_text','sub_bg','sub_text_hover','sub_bg_hover','hamburger','hamburger_bg'];
    foreach ($keys as $k){
        if (isset($input[$k])) {
            $c = sanitize_hex_color($input[$k]);
            if ($c) $out[$k] = $c;
        }
    }
    // Icon
    $allowed_icons = ['chevron','plus','angle'];
    if (isset($input['icon']) && in_array($input['icon'], $allowed_icons, true)) {
        $out['icon'] = $input['icon'];
    }
    // Text size (px) with a minimum of 16
if (isset($input['text_size'])) {
    $size = intval($input['text_size']);
    $out['text_size'] = max(16, $size);
}
    // Font
    $allowed_fonts = [
        'system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif',
        'Arial, Helvetica, sans-serif',
        'Verdana, Geneva, Tahoma, sans-serif',
        'Tahoma, Segoe UI, sans-serif',
        'Georgia, serif'
    ];
    if (isset($input['font_family']) && in_array($input['font_family'], $allowed_fonts, true)) {
        $out['font_family'] = $input['font_family'];
    }
    return $out;
}

function classicmenua11y_color_field($args){
    $key = $args['key'];
    $opts = get_option('classicmenua11y_options', []);
    $val = isset($opts[$key]) ? $opts[$key] : '';
    printf('<input type="text" class="classicmenua11yc-color-field" name="classicmenua11y_options[%1$s]" value="%2$s" />', esc_attr($key), esc_attr($val));
    echo '<div class="classicmenua11yc-contrast" data-for="'. esc_attr($key) .'"></div>';
}

function classicmenua11y_icon_field(){
    $opts = get_option('classicmenua11y_options', []);
    $val = isset($opts['icon']) ? $opts['icon'] : 'chevron';
    echo '<select name="classicmenua11y_options[icon]">';
    $choices = ['chevron' => __('Chevron', 'classic-menu-accessible-a11y'), 'plus' => __('Plus', 'classic-menu-accessible-a11y'), 'angle' => __('Angle', 'classic-menu-accessible-a11y')];
    foreach ($choices as $k=>$label){
        printf('<option value="%s"%s>%s</option>', esc_attr($k), selected($val,$k,false), esc_html($label));
    }
    echo '</select>';
    echo '<p class="description">'. esc_html__('Simple, legible, decorative icons (aria-hidden).', 'classic-menu-accessible-a11y') .'</p>';
}

function classicmenua11y_font_field(){
    $opts = get_option('classicmenua11y_options', []);
    $val = isset($opts['font_family']) ? $opts['font_family'] : 'system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif';
    $choices = [
        'system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif' => __('System UI (recommended)', 'classic-menu-accessible-a11y'),
        'Arial, Helvetica, sans-serif' => 'Arial / Helvetica',
        'Verdana, Geneva, Tahoma, sans-serif' => 'Verdana / Tahoma',
        'Tahoma, Segoe UI, sans-serif' => 'Tahoma / Segoe UI',
        'Georgia, serif' => 'Georgia (serif)'
    ];
    echo '<select name="classicmenua11y_options[font_family]">';
    foreach ($choices as $stack=>$label){
        printf('<option value="%s"%s>%s</option>', esc_attr($stack), selected($val,$stack,false), esc_html($label));
    }
    echo '</select>';
    echo '<p class="description">'. esc_html__('Common, legible fonts with no external loading.', 'classic-menu-accessible-a11y') .'</p>';
}

function classicmenua11y_text_size_field(){
    $opts = get_option('classicmenua11y_options', []);
    $val  = isset($opts['text_size']) ? intval($opts['text_size']) : 16;
    if ($val < 16) $val = 16; // minimum AA

    echo '<input type="number" min="16" step="1" name="classicmenua11y_options[text_size]" value="' . esc_attr($val) . '" /> px';
    echo '<p class="description">' . esc_html__('Minimum 16px for readability (WCAG/RGAA).', 'classic-menu-accessible-a11y') . '</p>';
}


function classicmenua11y_render_settings_page(){
    echo '<div class="wrap classicmenua11yc-admin">';
    echo '<h1>'. esc_html__('Classic Menu Accessible (A11y) menu', 'classic-menu-accessible-a11y') .'</h1>';
    echo '<p>'. esc_html__('Configure colors (Normal / Hover), icon, typography and mobile. Live AA contrast checks on the right.', 'classic-menu-accessible-a11y') .'</p>';
    echo '<div class="classicmenua11yc-grid">';
    echo '<div class="classicmenua11yc-left">';
    echo '<div class="classicmenua11yc-tabbar" role="tablist">';
    echo '<button type="button" class="classicmenua11yc-tab is-active" data-tab="normal" role="tab" aria-selected="true">'. esc_html__('Normal', 'classic-menu-accessible-a11y') .'</button>';
    echo '<button type="button" class="classicmenua11yc-tab" data-tab="hover" role="tab" aria-selected="false">'. esc_html__('Hover/Focus', 'classic-menu-accessible-a11y') .'</button>';
    echo '</div>';
    echo '<form method="post" action="options.php" id="classic-menu-accessible-a11y">';
    settings_fields('classicmenua11y_group');
    do_settings_sections('classic-menu-accessible-a11y');
    submit_button();
    echo '</form>';
    echo '</div>';
    echo '<aside class="classicmenua11yc-right">';
    echo '<h2>'. esc_html__('Contrast indicators (preview)', 'classic-menu-accessible-a11y') .'</h2>';
    echo '<div id="classicmenua11yc-contrast-preview"></div>';
    echo '</aside>';
    echo '</div>';
    echo '</div>';
}

add_action('admin_enqueue_scripts', function($hook){
    if ($hook !== 'settings_page_classic-menu-accessible-a11y') return;
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('wp-color-picker');
    wp_enqueue_script('classicmenua11yc-admin', CLASSICMENUA11YC_PLUGIN_URL . 'admin/admin.js', ['wp-color-picker'], '1.0', true);
    wp_enqueue_style('classicmenua11yc-admin', CLASSICMENUA11YC_PLUGIN_URL . 'admin/admin.css', [], '1.0');
});


