<?php
if ( ! defined('ABSPATH') ) exit;

class CLASSICMENUA11YC_Disclosure_Walker extends Walker_Nav_Menu {

    public function start_lvl( &$output, $depth = 0, $args = null ) {
        $submenu_id = 'submenu-' . wp_unique_id();
        $output .= sprintf('<ul id="%1$s" class="a11y-submenu" hidden>',
            esc_attr($submenu_id)
        );
    }

    public function end_lvl( &$output, $depth = 0, $args = null ) {
        $output .= '</ul>';
    }

    public function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        $classes = empty($item->classes) ? [] : (array) $item->classes;
        $has_children = in_array('menu-item-has-children', $classes, true);

        $li_classes = array_map('sanitize_html_class', $classes);
        $li_classes[] = 'a11y-item';
        if ($has_children) $li_classes[] = 'has-children';
        $output .= '<li class="' . esc_attr(implode(' ', array_filter($li_classes))) . '">';

        // Link
        $atts = [
            'href'  => ! empty($item->url) ? $item->url : '#',
            'id'    => 'link-' . $item->ID,
            'class' => 'a11y-link',
        ];
        if (in_array('current-menu-item', $classes, true) || in_array('current_page_item', $classes, true)) {
            $atts['aria-current'] = 'page';
        }
        $output .= '<a' . $this->attrs($atts) . '>' . esc_html($item->title) . '</a>';

        // Disclosure button
        if ($has_children) {
            $btn_id  = 'btn-' . $item->ID;
            $ctrl_id = 'submenu-pending-' . $item->ID; // replaced later

            // Icon choice from options
            $opts = get_option('classicmenua11y_options', []);
            $which = isset($opts['icon']) ? $opts['icon'] : 'chevron'; // chevron|plus|angle

            $button  = sprintf(
                '<button type="button" class="a11y-toggle" id="%1$s" aria-expanded="false" aria-controls="%2$s" aria-label="%3$s" data-icon="%4$s"><span class="a11y-toggle__icon" aria-hidden="true"></span></button>',
                esc_attr($btn_id),
                esc_attr($ctrl_id),
                /* translators: %s: parent menu item label */
                esc_attr( sprintf( __('Show submenu of “%s”', 'classic-menu-accessible-a11y'), $item->title ) ),
                esc_attr( $which )
            );
            $output .= $button;
        }
    }

    public function end_el( &$output, $item, $depth = 0, $args = null ) {
        $output .= '</li>';
    }

    public function walk( $elements, $max_depth, ...$args ) {
        $output = parent::walk( $elements, $max_depth, ...$args );
        $output = preg_replace_callback(
            '/(<button[^>]+aria-controls=")submenu-pending-(\d+)(")/',
            function ($m) use (&$output) {
                $pos = strpos($output, $m[0]);
                if ($pos !== false && preg_match('/<ul id="(submenu-\w+)"/', $output, $um, 0, $pos)) {
                    return $m[1] . $um[1] . $m[3];
                }
                return $m[0];
            },
            $output
        );
        return $output;
    }

    private function attrs($attrs) {
        $html = '';
        foreach ($attrs as $k => $v) {
            $html .= ' ' . $k . '="' . esc_attr($v) . '"';
        }
        return $html;
    }
}
