<?php
/**
 * Requires PHP: 7.4
 * Requires at least: 5.8
 * Plugin Name: Classic Menu Accessible (A11y)
 * Description: Menus déroulants accessibles conformes RGAA niveau AA et bonnes pratiques WCAG, basés sur le pattern Disclosure (WAI-ARIA). Ajoute le bon balisage, la gestion clavier et les attributs ARIA.
 * Version: 1.0.0
 * Author: Techniweb
 * Author URI: https://www.techniweb-agence.fr/
 * License: GPL-2.0+
 * Text Domain: classic-menu-accessible-a11y
 * Domain Path: /languages
 */
if ( ! defined('ABSPATH') ) exit;

// i18n
add_action('init', function(){
    if ( ! is_textdomain_loaded('classic-menu-accessible-a11y') ) {
        load_textdomain('classic-menu-accessible-a11y', WP_LANG_DIR . '/plugins/classic-menu-accessible-a11y-' . get_locale() . '.mo');
    }
});

// Defines (guarded)
if ( ! defined('CLASSICMENUA11YC_PLUGIN_URL') ) define('CLASSICMENUA11YC_PLUGIN_URL', plugin_dir_url(__FILE__));
if ( ! defined('CLASSICMENUA11YC_PLUGIN_PATH') ) define('CLASSICMENUA11YC_PLUGIN_PATH', plugin_dir_path(__FILE__));

require_once CLASSICMENUA11YC_PLUGIN_PATH . 'inc/class-disclosure-walker.php';
require_once CLASSICMENUA11YC_PLUGIN_PATH . 'inc/settings.php';

// Enqueue CSS/JS (front)
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('classicmenua11yc-css', CLASSICMENUA11YC_PLUGIN_URL . 'assets/css/a11y.css', [], '1.0', 'all');
    wp_enqueue_script('classicmenua11yc-nav', CLASSICMENUA11YC_PLUGIN_URL . 'assets/js/disclosure-nav.js', [], '1.0', true);
// === NEW: inject text size from settings (min 16px) ===
    $opts = get_option('classicmenua11y_options', []);
    $size = isset($opts['text_size']) ? intval($opts['text_size']) : 16;
    if ($size < 16) { $size = 16; }

    $inline_css = "
        .a11y-nav__list,
        .a11y-nav__list a { font-size: {$size}px; }
    ";
    // lie l'inline CSS à la feuille 'maw-css'
    wp_add_inline_style('classicmenua11yc-css', $inline_css);
}, 20);

// Inject CSS variables from settings
add_action('wp_head', function(){
    $opts = get_option('classicmenua11y_options', []);
    $vars = [
        '--classicmenua11yc-l1-text'      => isset($opts['level1_text']) ? sanitize_hex_color($opts['level1_text']) : '',
        '--classicmenua11yc-l1-bg'        => isset($opts['level1_bg']) ? sanitize_hex_color($opts['level1_bg']) : '',
        '--classicmenua11yc-l1-text-h'    => isset($opts['level1_text_hover']) ? sanitize_hex_color($opts['level1_text_hover']) : '',
        '--classicmenua11yc-l1-bg-h'      => isset($opts['level1_bg_hover']) ? sanitize_hex_color($opts['level1_bg_hover']) : '',
        '--classicmenua11yc-sub-text'     => isset($opts['sub_text']) ? sanitize_hex_color($opts['sub_text']) : '',
        '--classicmenua11yc-sub-bg'       => isset($opts['sub_bg']) ? sanitize_hex_color($opts['sub_bg']) : '',
        '--classicmenua11yc-sub-text-h'   => isset($opts['sub_text_hover']) ? sanitize_hex_color($opts['sub_text_hover']) : '',
        '--classicmenua11yc-sub-bg-h'     => isset($opts['sub_bg_hover']) ? sanitize_hex_color($opts['sub_bg_hover']) : '',
        '--classicmenua11yc-font-family'  => isset($opts['font_family']) ? esc_attr($opts['font_family']) : '',
        '--classicmenua11yc-hamburger'    => isset($opts['hamburger']) ? sanitize_hex_color($opts['hamburger']) : '',
        '--classicmenua11yc-hamburger-bg' => isset($opts['hamburger_bg']) ? sanitize_hex_color($opts['hamburger_bg']) : '',
    ];
    $inline = '';
    foreach ($vars as $k => $v) { if ($v) { $inline .= $k . ':' . $v . ';'; } }
    if ($inline) {
        printf("<style id='classicmenua11yc-vars'>:root{%s}</style>", esc_html($inline));
    }
}, 30);

// Skip link
add_action('wp_body_open', function () {
    echo '<a class="a11y-skip" href="#maincontent">' . esc_html__('Skip to main content', 'classic-menu-accessible-a11y') . '</a>';
});

// Replace menus (front)
add_filter('wp_nav_menu_args', function ($args) {
    if (is_admin()) return $args;

    // Force container as <nav> and keep theme classes + our class
    $args['container'] = 'nav';
    $existing_container_class = isset($args['container_class']) ? $args['container_class'] : '';
    $args['container_class'] = trim($existing_container_class . ' a11y-disclosure');

    // Walker
    $args['walker'] = new CLASSICMENUA11YC_Disclosure_Walker();

    // Accordion default true (no admin setting per request)
    $args['items_wrap'] = '<ul class="a11y-nav__list" data-accordion="true">%3$s</ul>';
    $args['menu_class'] = trim(($args['menu_class'] ?? '') . ' a11y-menu');
    return $args;
}, 20);

// Add aria-label if missing
add_filter('wp_nav_menu', function ($nav_menu, $args) {
    if (strpos($nav_menu, '<nav') !== false && strpos($nav_menu, 'aria-label=') === false) {
        /* translators: %s: theme location slug */
        $label = !empty($args->theme_location) ? sprintf(__('Menu %s', 'classic-menu-accessible-a11y'), esc_html($args->theme_location)) : __('Navigation', 'classic-menu-accessible-a11y');
        $nav_menu = preg_replace('/<nav(\s+)/', '<nav aria-label="' . esc_attr($label) . '"$1', $nav_menu, 1);
    }
    return $nav_menu;
}, 10, 2);

// Pass minimal options (reserved)
add_action('wp_footer', function(){
    echo '<script>(function(){try{document.documentElement.setAttribute("data-classicmenua11yc","{}");}catch(e){}})();</script>';
}, 99);