(function($){function hexToRgb(hex){if(!hex)return null;hex=(''+hex).trim().replace('#','');if(hex.length===3){hex=hex.split('').map(function(c){return c+c}).join('')}
if(!/^[0-9a-fA-F]{6}$/.test(hex))return null;var num=parseInt(hex,16);return{r:(num>>16)&255,g:(num>>8)&255,b:num&255}}
function luminance(rgb){function srgb(c){c/=255;return c<=0.03928?c/12.92:Math.pow((c+0.055)/1.055,2.4)}
var R=srgb(rgb.r),G=srgb(rgb.g),B=srgb(rgb.b);return 0.2126*R+0.7152*G+0.0722*B}
function contrastRatio(hex1,hex2){var a=hexToRgb(hex1),b=hexToRgb(hex2);if(!a||!b)return null;var L1=luminance(a),L2=luminance(b);var lighter=Math.max(L1,L2),darker=Math.min(L1,L2);return Math.round(((lighter+0.05)/(darker+0.05))*100)/100}
function passLevel(ratio,size){if(ratio==null)return{AA:!1,AAA:!1};if(size==='large'){return{AA:ratio>=3.0,AAA:ratio>=4.5}}
return{AA:ratio>=4.5,AAA:ratio>=7.0}}
function readColor(key){var $inp=$('input[name="classicmenua11y_options['+key+']"]');return($inp.val()||'').trim()}
function readInt(key,min){var $inp=$('input[name="classicmenua11y_options['+key+']"]');var v=parseInt(($inp.val()||'').trim(),10);if(isNaN(v))v=(typeof min==='number')?min:0;if(typeof min==='number'&&v<min)v=min;return v}
function badge(cls,text){return'<span class="classicmenua11yc-badge '+cls+'">'+text+'</span>'}
function renderIndicator($el,keyText,keyBg){var fg=readColor(keyText);var bg=readColor(keyBg);var r=contrastRatio(fg,bg);var normal=passLevel(r,'normal');var large=passLevel(r,'large');var html='';if(r==null){html+=badge('warn','Invalid colors')}else{html+=badge(normal.AA?'ok':'warn','AA normal: '+(normal.AA?'OK':'Fail'));html+=badge(normal.AAA?'ok':'warn','AAA normal: '+(normal.AAA?'OK':'Fail'));html+=badge(large.AA?'ok':'warn','AA large: '+(large.AA?'OK':'Fail'));html+=badge(large.AAA?'ok':'warn','AAA large: '+(large.AAA?'OK':'Fail'));html+=badge('ok',(r.toFixed(2))+':1')}
$el.html(html)}
function updateIndicators(){$('[data-for="level1_text"]').each(function(){renderIndicator($(this),'level1_text','level1_bg')});$('[data-for="level1_text_hover"]').each(function(){renderIndicator($(this),'level1_text_hover','level1_bg_hover')});$('[data-for="sub_text"]').each(function(){renderIndicator($(this),'sub_text','sub_bg')});$('[data-for="sub_text_hover"]').each(function(){renderIndicator($(this),'sub_text_hover','sub_bg_hover')})}
function renderPreview(){var l1_txt=readColor('level1_text')||'#111111';var l1_bg=readColor('level1_bg')||'#ffffff';var l1_txt_h=readColor('level1_text_hover')||l1_txt;var l1_bg_h=readColor('level1_bg_hover')||l1_bg;var sub_txt=readColor('sub_text')||'#111111';var sub_bg=readColor('sub_bg')||'#ffffff';var sub_txt_h=readColor('sub_text_hover')||sub_txt;var sub_bg_h=readColor('sub_bg_hover')||sub_bg;var textSize=readInt('text_size',16);function card(title,fg,bg){var ratio=contrastRatio(fg,bg);var ratioTxt=ratio?ratio.toFixed(2)+':1':'—';return''+'<div class="classicmenua11yc-preview" style="margin:8px 0;border:1px solid #ddd;border-radius:6px;overflow:hidden;">'+'<div class="classicmenua11yc-l1" style="padding:10px 12px;background:'+bg+';color:'+fg+';font-size:'+textSize+'px;line-height:1.5;">'+'<strong>'+title+'</strong> · <span>'+ratioTxt+'</span>'+'</div>'+'<div class="classicmenua11yc-sub" style="padding:10px 12px;background:'+bg+';color:'+fg+';font-size:'+textSize+'px;line-height:1.5;">'+'Aa Bb Cc 123 — Preview'+'</div>'+'</div>'}
var html=''+card('Level 1 — normal',l1_txt,l1_bg)+card('Level 1 — hover/focus',l1_txt_h,l1_bg_h)+card('Submenu — normal',sub_txt,sub_bg)+card('Submenu — hover/focus',sub_txt_h,sub_bg_h);$('#classicmenua11yc-contrast-preview').html(html);var $smallPrev=$('#classicmenua11yc-text-size-preview');if($smallPrev.length){$smallPrev.css('font-size',textSize+'px')}}
function bindColorPickers(){$('.classicmenua11yc-color-field').each(function(){var $input=$(this);if(!$input.data('wpColorPicker')){$input.wpColorPicker({change:function(event,ui){if(ui&&ui.color){$input.val(ui.color.toString())}
updateIndicators();renderPreview()},clear:function(){updateIndicators();renderPreview()}})}
$input.on('input change',function(){updateIndicators();renderPreview()});$input.on('click',function(){var $holder=$input.closest('.wp-picker-container').find('.wp-picker-holder');if($holder.length){$holder.off('.classicmenua11yc').on('click.classicmenua11yc','.iris-palette',function(){setTimeout(function(){var iris=$input.data('a8cIris');if(iris&&iris._color){$input.val(iris._color.toString())}
updateIndicators();renderPreview()},0)})}})})}
$(function(){$('tr#level1_text_hover, tr#level1_bg_hover, tr#sub_text_hover, tr#sub_bg_hover').show();bindColorPickers();updateIndicators();renderPreview();var $textSizeField=$('.classicmenua11yc-text-size-field');if($textSizeField.length){$textSizeField.on('input change',function(){var v=parseInt($(this).val(),10);if(isNaN(v)||v<16)v=16;$(this).val(v);renderPreview()})}})})(jQuery)