<?php
// Create the admin menu and settings page
function christmas_snow_add_admin_menu() {
    add_menu_page(
        'Christmas Snow Settings',         // Page title
        'Snow Effects',                  // Menu title
        'manage_options',                 // Capability required
        'christmas-snow-settings',           // Menu slug
        'christmas_snow_settings_page', // Callback function
        'dashicons-welcome-widgets-menus',           // Icon (optional)
        100
    );
}
add_action('admin_menu', 'christmas_snow_add_admin_menu');

// Function to render the settings page content
function christmas_snow_settings_page() {
    // Check user capabilities
    if (!current_user_can('manage_options')) {
        return;
    }
    $options = get_option('christmas_snow_options');
    ?>
    <div class="wrap">
        <h1>Christmas Snow Effects Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('christmas_snow_group');
            do_settings_sections('christmas-snow-settings');
            submit_button('Save Settings');
            ?>
        </form>
    </div>
    <?php
}

// Register plugin settings
function christmas_snow_register_settings() {
    register_setting('christmas_snow_group', 'christmas_snow_options', 'christmas_snow_sanitize_options');

    // Section for plugin general setting
    add_settings_section(
        'christmas_snow_general_section', // ID of the section
        'General Settings',               // Title
        'christmas_snow_general_section_callback', // Callback function
        'christmas-snow-settings'         // Page
    );
   // Enable snow
    add_settings_field(
    'enable_snow',                        // ID
    'Enable Snow',                     // Title
    'christmas_snow_enable_snow_callback', // Callback function
    'christmas-snow-settings',         // Page
    'christmas_snow_general_section'    // Section
    );
   // Font size field
   add_settings_field(
    'font_size',                            // ID
    'Snowflake Font Size',                    // Title
    'christmas_snow_font_size_callback',    // Callback function
    'christmas-snow-settings',             // Page
    'christmas_snow_general_section'        // Section
    );
   // Color field
    add_settings_field(
        'snow_color',                    // ID
        'Snowflake Color',                // Title
        'christmas_snow_color_callback',  // Callback
        'christmas-snow-settings',            // Page
        'christmas_snow_general_section' // Section
    );

    // Music option field
     add_settings_field(
        'music_option',                // ID
        'Music Option',                // Title
        'christmas_snow_music_callback',  // Callback
        'christmas-snow-settings',            // Page
        'christmas_snow_general_section' // Section
    );

   // Animation speed field
    add_settings_field(
        'animation_speed',                 // ID
        'Animation Speed',                 // Title
        'christmas_snow_animation_speed_callback',   // Callback
        'christmas-snow-settings',            // Page
        'christmas_snow_general_section' // Section
    );
    
    // Apply to field
    add_settings_field(
        'apply_to',               // ID
        'Apply Snow To',           // Title
        'christmas_snow_apply_to_callback', // Callback
        'christmas-snow-settings',   // Page
        'christmas_snow_general_section' // Section
    );
   // Single page select field
    add_settings_field(
        'selected_page',                  // ID
        'Select Page',                // Title
        'christmas_snow_select_page_callback',    // Callback function
         'christmas-snow-settings',             // Page
        'christmas_snow_general_section'        // Section
     );
     // Add settings field for enabling Santa
    add_settings_field(
        'enable_santa',                        // ID
        'Enable Santa Claus Animation',         // Title
        'christmas_snow_enable_santa_callback', // Callback function
        'christmas-snow-settings',              // Page
        'christmas_snow_general_section'        // Section
    );

}
add_action('admin_init', 'christmas_snow_register_settings');

// Callback function for general section
function christmas_snow_general_section_callback() {
    echo '<p>Customize the snow effect.</p>';
}
// Enable snow callback
function christmas_snow_enable_snow_callback() {
     $options = get_option('christmas_snow_options');
     $enabled = isset($options['enable_snow']) ? intval($options['enable_snow']) : 0;
    ?>
    <input type="checkbox" name="christmas_snow_options[enable_snow]" id="enable_snow" value="1" <?php checked(1, $enabled); ?> />
    <label for="enable_snow">Enable snow effect.</label>
    <?php
}

// Enable Santa
function christmas_snow_enable_santa_callback() {
    $options = get_option('christmas_snow_options');
    $enabled = isset($options['enable_santa']) ? intval($options['enable_santa']) : 0;
    ?>
    <input type="checkbox" name="christmas_snow_options[enable_santa]" id="enable_santa" value="1" <?php checked(1, $enabled); ?> />
    <label for="enable_santa">Enable Santa Claus animation on the frontend.</label>
    <?php
}

// Font size callback
function christmas_snow_font_size_callback() {
    $options = get_option('christmas_snow_options');
    $fontSize = isset($options['font_size']) ? esc_attr($options['font_size']) : '16px';
    ?>
    <input type="text" name="christmas_snow_options[font_size]" value="<?php echo esc_attr($fontSize); ?>" class="regular-text" />
    <p class="description">Enter the font size in pixels (e.g., 20px)</p>
    <?php
}
// Color callback function
function christmas_snow_color_callback() {
    $options = get_option('christmas_snow_options');
    $color = isset($options['snow_color']) ? esc_attr($options['snow_color']) : '#ffffff';
    ?>
    <input type="text" name="christmas_snow_options[snow_color]" value="<?php echo esc_attr($color); ?>" class="christmas-snow-color-field" data-default-color="#ffffff"/>
      <p class="description">Choose a color for the snowflakes.</p>
    <?php
}

// Music callback function
function christmas_snow_music_callback() {
    $options = get_option('christmas_snow_options');
    $selected_option = isset($options['music_option']) ? esc_attr($options['music_option']) : 'none';
    ?>
    <select name="christmas_snow_options[music_option]">
          <option value="none" <?php selected('none', $selected_option); ?>>None</option>
          <option value="jinglebells" <?php selected('jinglebells', $selected_option); ?>>Jingle Bells</option>
          <option value="weWishYouAMerryChristmas" <?php selected('weWishYouAMerryChristmas', $selected_option); ?>>We wish you a merry Christmas</option>
          <option value="christmasholidays" <?php selected('christmasholidays', $selected_option); ?>>Christmas Holiday</option>
          <option value="whitechristmaspiano" <?php selected('whitechristmaspiano', $selected_option); ?>>White Christmas Piano</option>
          <option value="thegiftofloveandlight" <?php selected('thegiftofloveandlight', $selected_option); ?>>The Gift of Love & Light</option>
          <option value="snowandchristmas" <?php selected('snowandchristmas', $selected_option); ?>>Snow & Christmas</option>
          <option value="cozychristmaseve" <?php selected('cozychristmaseve', $selected_option); ?>>Cozy Christmas Eve</option>
          <!-- Add more options here -->
    </select>
    <p class="description">Select a music to play along with the snow.</p>
    <?php
}


// Animation speed callback function
function christmas_snow_animation_speed_callback() {
    $options = get_option('christmas_snow_options');
    $speed = isset($options['animation_speed']) ? esc_attr($options['animation_speed']) : 'normal';
    ?>
    <select name="christmas_snow_options[animation_speed]">
        <option value="low" <?php selected('low', $speed); ?>>Low</option>
        <option value="normal" <?php selected('normal', $speed); ?>>Normal</option>
        <option value="fast" <?php selected('fast', $speed); ?>>Fast</option>
    </select>
    <p class="description">Select the animation speed.</p>
    <?php
}


// Apply to callback
function christmas_snow_apply_to_callback() {
    $options = get_option('christmas_snow_options');
    $apply_to = isset($options['apply_to']) ? esc_attr($options['apply_to']) : 'all';
    ?>
    <select name="christmas_snow_options[apply_to]" id="apply_to_select">
        <option value="all" <?php selected('all', $apply_to); ?>>All Website</option>
        <option value="single" <?php selected('single', $apply_to); ?>>Single Page</option>
    </select>
    <p class="description">Choose where to display the snow.</p>
    <?php
}

// Single page select callback
function christmas_snow_select_page_callback(){
    $options = get_option('christmas_snow_options');
    $selected_page = isset($options['selected_page']) ? intval($options['selected_page']) : 0;
     $pages = get_pages();
    ?>
    <select name="christmas_snow_options[selected_page]" id="selected_page_select">
        <option value="0" <?php selected(0, $selected_page); ?>>-- Select a page --</option>
        <?php
        foreach ($pages as $page) {
            echo '<option value="' . esc_attr($page->ID) . '"' . selected($page->ID, $selected_page, false) . '>' . esc_html($page->post_title) . '</option>';
        }
        ?>
    </select>
    <p class="description">Select the page on which the snow effect will be applied.</p>
    <?php
}

// Sanitize settings
function christmas_snow_sanitize_options($input) {
    $sanitized_input = array();
    if (isset($input['enable_snow'])) {
        $sanitized_input['enable_snow'] = intval($input['enable_snow']);
    }
    if (isset($input['font_size'])) {
        $sanitized_input['font_size'] = sanitize_text_field($input['font_size']);
    }
     if (isset($input['snow_color'])) {
        $sanitized_input['snow_color'] = sanitize_hex_color($input['snow_color']);
    }
    if (isset($input['music_option'])) {
         $sanitized_input['music_option'] = sanitize_text_field($input['music_option']);
    }
   if (isset($input['animation_speed'])) {
      $allowed_speeds = array('low', 'normal', 'fast');
     $sanitized_input['animation_speed'] = in_array($input['animation_speed'], $allowed_speeds, true) ? $input['animation_speed'] : 'normal';
   }
     if (isset($input['apply_to'])) {
        $sanitized_input['apply_to'] = sanitize_text_field($input['apply_to']);
    }
    if (isset($input['selected_page'])) {
        $sanitized_input['selected_page'] = intval($input['selected_page']);
    }
    if (isset($input['enable_santa'])) {
        $sanitized_input['enable_santa'] = intval($input['enable_santa']);
    }
    return $sanitized_input;
}
?>