<?php
/**
 *
 * Plugin Name: Christmas Snow Effects
 * Plugin URI:  https://wordpress.org/plugins/christmas-snow-effects
 * Description: This plugin allows you to add a snow effect to your website with a moving Santa Claus image. It includes an option to enable or disable the snow and customize the snowflakes' appearance.
 * Version:     1.1
 * Author:      DyXperts
 * Author URI:  https://profiles.wordpress.org/dyexperts/
 * License:     GPLv2 or later
 * License URI: http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * Text Domain: christmas-snow-effects
 * Domain Path: 
 * #
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License version 2, as published by the Free Software Foundation. You may NOT assume
 * that you can use any other version of the GPL.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */


// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Include the settings page and save settings
include_once plugin_dir_path(__FILE__) . 'includes/admin-settings.php';

// Enqueue styles and scripts for front-end if enabled and needed
function christmas_snow_enqueue_scripts() {
    $options = get_option('christmas_snow_options');

   

    // Check if snow is enabled
    if (isset($options['enable_snow']) && $options['enable_snow'] == 1) {
        // Enqueue the snow effect script
        wp_enqueue_script('christmas-snow', plugins_url('assets/js/snow.js', __FILE__), array('jquery'), '1.0.0', true);
        // Enqueue the snow style
        wp_enqueue_style('christmas-snow-style', plugins_url('assets/css/snow.css', __FILE__), array(), '1.0.0');
        
        $santa_image_url = plugin_dir_url(__FILE__) . 'assets/santas.gif'; // Adjust to the correct path of the Santa image in the assets folder

        // Pass settings to JavaScript
        $settings = array(
            'fontSize' => isset($options['font_size']) ? esc_attr($options['font_size']) : '20px',
            'color' => isset($options['snow_color']) ? esc_attr($options['snow_color']) : '#ffffff',
            'musicOption' => isset($options['music_option']) ? esc_attr($options['music_option']) : 'none',
            'animationSpeed' => isset($options['animation_speed']) ? esc_attr($options['animation_speed']) : 'normal',
            'applyTo' => isset($options['apply_to']) ? esc_attr($options['apply_to']) : 'all',
            'pageId' => isset($options['selected_page']) ? intval($options['selected_page']) : 0,  // Get the selected page ID
            'cssRules' => christmas_snow_generate_css_rules(),
            'enableSanta' => get_option('christmas_snow_options')['enable_santa'] ?? 0, // Pass the enable_santa option
            'santaImageUrl' => $santa_image_url, // URL for Santa image
        );
        wp_localize_script('christmas-snow', 'christmasSnowSettings', $settings);

        // Enqueue inline style for dynamic css
        add_action('wp_head', 'christmas_snow_dynamic_css', 10);
    }
}
add_action('wp_enqueue_scripts', 'christmas_snow_enqueue_scripts');

// Generate dynamic CSS rules based on user settings
function christmas_snow_generate_css_rules() {
    $options = get_option('christmas_snow_options');
    $fontSize = isset($options['font_size']) ? esc_attr($options['font_size']) : '20px';
    $color = isset($options['snow_color']) ? esc_attr($options['snow_color']) : '#ffffff';
    $animationSpeed = isset($options['animation_speed']) ? esc_attr($options['animation_speed']) : 'normal';

    // Determine animation duration based on selected speed
    $animationDuration = '15s'; // default value
    if ($animationSpeed === 'low') {
        $animationDuration = '25s';
    } elseif ($animationSpeed === 'fast') {
        $animationDuration = '8s';
    }

    $css =  ".snowflake {
            font-size: {$fontSize};
            color: {$color};
            animation-duration: {$animationDuration};
            position: absolute;
            top: -10%;
            pointer-events: none;
            white-space: nowrap;
            animation-name: fall;
            animation-timing-function: linear;
            animation-iteration-count: infinite;
            opacity: 0.8;
            }
           
           @keyframes fall {
               0% {
                  top: -10%;
                  opacity: 0.8;
              }
                100% {
                top: 100%;
                opacity: 0.3;
               }
            }
             ";
    return $css;
}

// Add music URL to JavaScript
function christmas_snow_add_music_url() {
    $music_url = plugin_dir_url(__FILE__) . 'assets/audio/';
    wp_localize_script('christmas-snow', 'christmas_snow_music_url', array('musicURL' => $music_url));
}
add_action('wp_enqueue_scripts', 'christmas_snow_add_music_url');

// Enqueue styles and scripts for admin panel
function christmas_snow_enqueue_admin_scripts($hook) {
    if ('toplevel_page_christmas-snow-settings' !== $hook) {
        return;
    }
    // Enqueue the color picker
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_script( 'wp-color-picker' );
    wp_enqueue_script('christmas-snow-admin', plugins_url('assets/js/admin.js', __FILE__), array('jquery','wp-color-picker'), '1.0.0', true);
    wp_enqueue_style('christmas-snow-admin-style', plugins_url('assets/css/admin.css', __FILE__), array(), '1.0.0');

}

add_action('admin_enqueue_scripts', 'christmas_snow_enqueue_admin_scripts');

// Enqueuw Dashicon
function christmas_snow_enqueue_dashicons() {
    // Only enqueue the stylesheet in the admin area
    if (is_admin()) {
        wp_enqueue_style('dashicons');
    }
}
add_action('admin_enqueue_scripts', 'christmas_snow_enqueue_dashicons');


// Add inline style to head
function christmas_snow_dynamic_css(){

    $options = get_option('christmas_snow_options');

    if(isset($options['enable_snow']) && $options['enable_snow'] == 1){

        $css_rules =  christmas_snow_generate_css_rules();

        $sanitized_css = esc_html($css_rules);

        wp_add_inline_style('christmas-snow-style', $sanitized_css);
    }
}

// Run this function on plugin activation
register_activation_hook(__FILE__, 'christmas_snow_activation');

function christmas_snow_activation(){
    // Set default options
    $default_options = array(
        'enable_snow' => 0, // disabled by default
        'font_size' => '20px',
        'snow_color' => '#000',
        'music_option' => 'none',
        'animation_speed' => 'normal',
        'apply_to' => 'all',
        'selected_page' => 0,
    );
    add_option('christmas_snow_options', $default_options);
}

// Run this function on plugin deactivation
register_deactivation_hook(__FILE__, 'christmas_snow_deactivation');

function christmas_snow_deactivation() {
    // Reset settings or any clean-up code
    delete_option('christmas_snow_options'); // Optional: Delete plugin options on deactivation
}