jQuery(document).ready(function($) {
    var settings = window.christmasSnowSettings;
  
    if (!settings) {
        console.error('Christmas Snow settings not found');
        return;
    }
  
    var musicOption = settings.musicOption;
    var applyTo = settings.applyTo;
    var pageId = settings.pageId;
    var santaImageUrl = settings.santaImageUrl;
    var animationSpeed = settings.animationSpeed;
    var enableSanta = settings.enableSanta;
    console.log(santaImageUrl);
    console.log(enableSanta);
  
    // Check if snow should be applied to this page
    if (applyTo === 'all' || (applyTo === 'single' && $('body.page-id-' + pageId ).length > 0 )) {
  
        // Function to create snowflakes
        function createSnowflakes() {
            var snowflakeCount = 150; // Number of snowflakes
            var pageHeight = document.documentElement.scrollHeight - 100; // Get full height of the page, including scrollable content
            var snowflake_container = $('<div class="snow-container"></div>');
            snowflake_container.css('height', pageHeight);
            
            $('body').append(snowflake_container);
  
            // Loop to create multiple snowflakes
            for (let i = 0; i < snowflakeCount; i++) {
                var snowflake = $('<div class="snowflake">❅</div>');
                var randomDuration = Math.random() * 12 + 2;
                if(animationSpeed == "low")
                {
                    var randomDuration = Math.random() * 5 + 10; // Random fall duration 10s to 15s)
                }
                else if(animationSpeed == "normal")
                {
                    var randomDuration = Math.random() * 6 + 8; // Random delay between 8s and 14s
                }
                else if(animationSpeed == "high")
                {
                    var randomDuration = Math.random() * 6 + 2; // Random delay between 2s and 8s
                }
                // Randomize snowflake's size, horizontal position, animation delay, and duration
                var randomSize = Math.random() * 15 + 10; // Snowflake size between 10px and 25px
                var randomLeft = Math.random() * 100; // Random position (0% to 100%) horizontally across the page
                var randomDelay = Math.random() * 10; // Random delay before snowflake starts falling
               
  
                // Apply styles to the snowflake
                snowflake.css({
                    'font-size': settings.fontSize, // Set font size from settings
                    'left': randomLeft + '%', // Set position of snowflake across the screen
                    'top': -randomSize + 'px', // Start snowflake just above the page
                    'position': 'absolute',
                    'animation-delay': randomDelay + 's',
                    'animation-duration': randomDuration + 's',
                    'color': settings.color, // Set color from settings
                    'pointer-events': 'none', // Prevent snowflakes from being interactive
                    'z-index': 9999, // Ensure snowflakes appear above other content
                    'height' : 'max-content',         
                });
  
                // Append the snowflake to the body
                $('.snow-container').append(snowflake);
            }
        }   
        $(document).ready(function() {
        if (enableSanta == "1" || enableSanta === 1) {
            createSanta();
        }});

        // Function to create Santa Claus moving from right to left and left to right
        function createSanta() {
                // Create the Santa Claus image element
                var santa_container = jQuery('<div class="santa-container"></div>');
                jQuery('body').append(santa_container);
                var santaclaus = jQuery('<img src="'+santaImageUrl+'" class="santa" alt="Santa Claus" />');
                santaclaus.css({
                    'position': 'fixed',
                    'bottom': '10px',                    
                    'z-index': '9999',
                    'left': '-100px', // Start off-screen to the left
                    'transition': 'left 5s linear' // Smooth transition for movement
                });
                jQuery('.santa-container').append(santaclaus);
        }
        
        // Call createSnowflakes function on page load
        $(document).ready(function() {
              createSnowflakes(); // Create snowflakes initially              
        });
  
        $(window).on('resize', function() {
          var pageHeight = $(document).height(); // Recalculate the page height
          $('.snow-container').css('height', pageHeight); // Adjust snow container height
        });
  
        // Music functionality (if any selected)
        if (musicOption !== 'none' && typeof window.christmas_snow_music_url !== 'undefined') {
            var musicSrc = window.christmas_snow_music_url.musicURL;
            var music = new Audio(musicSrc + musicOption + '.mp3');
            music.loop = true;
  
            // Play music on first click
            function playMusic() {
                music.play();
                document.removeEventListener('click', playMusic);
            }
            document.addEventListener('click', playMusic);
        }
            
    }
  });
  