document.addEventListener('DOMContentLoaded', function () {
  const estadoField = document.querySelector('#billing_estado');
  const distritoField = document.querySelector('#billing_distrito');

  if (!estadoField || !distritoField) {
    console.error('No se encontraron los campos de Estado o Distrito en el checkout.');
    return;
  }

  function cargarEstados() {
    fetch(customShippingAjax.ajax_url + '?action=get_states&nonce=' + customShippingAjax.nonce)
      .then((response) => response.json())
      .then((data) => {
        estadoField.innerHTML = '<option value="">Selecciona región de destino</option>';
        if (data.success) {
          Object.entries(data.data).forEach(([key, value]) => {
            const option = document.createElement('option');
            option.value = key;
            option.textContent = value;
            estadoField.appendChild(option);
          });
        } else {
          estadoField.innerHTML = '<option value="">Error al cargar las regiones</option>';
        }
      })
      .catch((error) => {
        console.error('Error en la carga de estados:', error);
        estadoField.innerHTML = '<option value="">Error al cargar estados</option>';
      });
  }

  cargarEstados();

  estadoField.addEventListener('change', function () {
    const estadoSeleccionado = this.value;
    distritoField.innerHTML = '<option value="">Cargando comunas...</option>';

    if (!estadoSeleccionado) {
      distritoField.innerHTML = '<option value="">Selecciona la región de destino</option>';
      return;
    }

    fetch(customShippingAjax.ajax_url + '?action=get_districts&estado=' + encodeURIComponent(estadoSeleccionado) + '&nonce=' + customShippingAjax.nonce)
      .then((response) => response.json())
      .then((data) => {
        distritoField.innerHTML = '<option value="">Selecciona comuna de destino</option>';
        if (data.success) {
          Object.entries(data.data).forEach(([key, value]) => {
            const option = document.createElement('option');
            option.value = key;
            option.textContent = value;
            distritoField.appendChild(option);
          });
        } else {
          distritoField.innerHTML = '<option value="">Error al cargar distritos</option>';
        }
      })
      .catch((error) => {
        console.error('Error en la carga de distritos:', error);
        distritoField.innerHTML = '<option value="">Error al cargar distritos</option>';
      });
  });

  distritoField.addEventListener('change', function () {
    jQuery('body').trigger('update_checkout');
  });
});
