document.addEventListener('DOMContentLoaded', function () {
  const estadoSelect = document.getElementById('origin_state');
  const distritoSelect = document.getElementById('origin_district');

  function cargarEstados() {
    fetch(mcAdminAjax.ajax_url + '?action=get_states&nonce=' + mcAdminAjax.nonce)
      .then((res) => res.json())
      .then((data) => {
        estadoSelect.innerHTML = '<option value="">Selecciona una región</option>';
        if (data.success) {
          Object.entries(data.data).forEach(([key, value]) => {
            const opt = document.createElement('option');
            opt.value = key;
            opt.textContent = value;
            if (mcAdminAjax.selected_state === key) opt.selected = true;
            estadoSelect.appendChild(opt);
          });

          if (mcAdminAjax.selected_state) {
            cargarDistritos(mcAdminAjax.selected_state);
          }
        } else {
          estadoSelect.innerHTML = '<option value="">Error al cargar estados</option>';
        }
      });
  }

  function cargarDistritos(estado) {
    fetch(mcAdminAjax.ajax_url + '?action=get_districts&estado=' + encodeURIComponent(estado) + '&nonce=' + mcAdminAjax.nonce)
      .then((res) => res.json())
      .then((data) => {
        distritoSelect.innerHTML = '<option value="">Selecciona una comuna</option>';
        if (data.success) {
          Object.entries(data.data).forEach(([key, value]) => {
            const opt = document.createElement('option');
            opt.value = key;
            opt.textContent = value;
            if (mcAdminAjax.selected_district === key) opt.selected = true;
            distritoSelect.appendChild(opt);
          });
        } else {
          distritoSelect.innerHTML = '<option value="">Error al cargar distritos</option>';
        }
      });
  }

  estadoSelect.addEventListener('change', function () {
    cargarDistritos(this.value);
  });

  cargarEstados();
});
