<?php
if ( ! defined( 'ABSPATH' ) ) exit;
class multicourier_ProductDimensionAggregator {

    private $products;
    private $min_length;
    private $min_width;
    private $min_height;
    private $min_weight;

    public function __construct(array $products) {
        $this->products = $products;

        $this->min_length = multicourier_shipping_get_setting('default_length', 12);
        $this->min_width  = multicourier_shipping_get_setting('default_width', 10);
        $this->min_height = multicourier_shipping_get_setting('default_height', 18);
        $this->min_weight = multicourier_shipping_get_setting('default_weight', 2);
    }

    public function getFinalDimensions() {
        $max_length = 0;
        $max_width  = 0;
        $max_height = 0;
        $total_weight = 0;

        foreach ($this->products as $product) {
            $length = floatval($product['length']);
            $width  = floatval($product['width']);
            $height = floatval($product['height']);
            $weight = floatval($product['weight']);
            $qty    = intval($product['quantity']);

            $max_length = max($max_length, $length);
            $max_width  = max($max_width, $width);
            $max_height = max($max_height, $height);
            $total_weight += $weight * $qty;
        }

        return [
            'length' => max($max_length, $this->min_length),
            'width'  => max($max_width, $this->min_width),
            'height' => max($max_height, $this->min_height),
            'weight' => max($total_weight, $this->min_weight),
        ];
    }
}
