<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action('wp_ajax_get_states', 'multicourier_get_states');
add_action('wp_ajax_nopriv_get_states', 'multicourier_get_states'); 

add_action('wp_ajax_get_districts', 'multicourier_get_districts');
add_action('wp_ajax_nopriv_get_districts', 'multicourier_get_districts');

function multicourier_get_states() {
    check_ajax_referer('multicourier_nonce', 'nonce');
    
    $service = new multicourier_CustomShippingService();
    $states = $service->getStates();

    if (is_wp_error($states)) {
        $status_code = 500; 
        if ($states->get_error_code() === 'not_found') {
            $status_code = 404; 
        }

        wp_send_json_error([
            'message' => $states->get_error_message(), 
            'code' => $states->get_error_code()
            ],
            $status_code
        );
        return;
    }

    if (empty($states)) {
        wp_send_json_error(
            ['message' => 'No se encontraron distritos', 'code' => 'not_found'],
            404
        );
        return;
    }

    wp_send_json_success($states);
}

function multicourier_get_districts() {
    check_ajax_referer('multicourier_nonce', 'nonce');
    
    if (!isset($_GET['estado'])) {
        wp_send_json_error(['message' => 'Estado no proporcionado']);
    }

    $state = sanitize_text_field($_GET['estado']);

    $service = new multicourier_CustomShippingService();
    $districts = $service->getDistricts($state);
   
    if (is_wp_error($districts)) {
        $status_code = 500; 
        if ($districts->get_error_code() === 'not_found') {
            $status_code = 404; 
        }

        wp_send_json_error([
            'message' => $districts->get_error_message(), 
            'code' => $districts->get_error_code()
            ],
            $status_code
        );
        return;
    }


    if (empty($districts)) {
        wp_send_json_error(
            ['message' => 'No se encontraron distritos', 'code' => 'not_found'],
            404
        );
        return;
    }
    
    wp_send_json_success($districts);
}
