<?php
if (!defined('ABSPATH')) {
    exit;
}

final class Cheqpay_Link_Blocks extends Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType {

    protected $name = 'cheqpay_link';

    public function initialize() {
        $this->settings = get_option('woocommerce_cheqpay_link_settings', array());
    }

    public function is_active() {
        $gateway = WC()->payment_gateways()->payment_gateways()['cheqpay_link'] ?? null;
        return $gateway && $gateway->is_available();
    }

    public function get_payment_method_script_handles() {
        $script_url = CHEQPAY_LINK_PLUGIN_URL . 'build/index.js';
        $script_asset_path = CHEQPAY_LINK_PLUGIN_PATH . 'build/index.asset.php';
        $script_asset = file_exists($script_asset_path)
            ? require $script_asset_path
            : array(
                'dependencies' => array(),
                'version' => CHEQPAY_LINK_VERSION
            );

        $payment_method = $this->get_setting('payment_method', 'payment_link');

        // Register VGS Collect.js if card payment is enabled
        if ($payment_method === 'card_payment') {
            wp_register_script(
                'vgs-collect-js',
                'https://js.verygoodvault.com/vgs-collect/2.18.0/vgs-collect.js',
                array(),
                '2.18.0',
                true
            );
            $script_asset['dependencies'][] = 'vgs-collect-js';
        }

        wp_register_script(
            'cheqpay-payment-gateway-blocks',
            $script_url,
            $script_asset['dependencies'],
            $script_asset['version'],
            true
        );

        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('cheqpay-payment-gateway-blocks', 'cheqpay-payment-gateway');
        }

        return array('cheqpay-payment-gateway-blocks');
    }

    public function get_payment_method_data() {
        $title = html_entity_decode($this->get_setting('title', __('DEFAULT_PAYMENT_TITLE', 'cheqpay-payment-gateway')));
        $description = html_entity_decode($this->get_setting('description', __('DEFAULT_PAYMENT_DESCRIPTION', 'cheqpay-payment-gateway')));
        $payment_method = $this->get_setting('payment_method', 'payment_link');
        $environment = $this->get_setting('environment', 'sandbox');

        // API URL based on environment
        $api_url = ($environment === 'production') ? CHEQPAY_LINK_API_URL_PRODUCTION : CHEQPAY_LINK_API_URL_SANDBOX;

        // VGS configuration
        $vgs_vault_id = ($environment === 'production') ? CHEQPAY_VGS_VAULT_ID_PRODUCTION : CHEQPAY_VGS_VAULT_ID_SANDBOX;
        $vgs_environment = ($environment === 'production') ? 'live' : 'sandbox';

        $visa_svg = 'data:image/svg+xml;base64,' . base64_encode('<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"> <g class="nc-icon-wrapper"> <rect x="2" y="7" width="28" height="18" rx="3" ry="3" fill="#1434cb" stroke-width="0"></rect> <path d="m27,7H5c-1.657,0-3,1.343-3,3v12c0,1.657,1.343,3,3,3h22c1.657,0,3-1.343,3-3v-12c0-1.657-1.343-3-3-3Zm2,15c0,1.103-.897,2-2,2H5c-1.103,0-2-.897-2-2v-12c0-1.103.897-2,2-2h22c1.103,0,2,.897,2,2v12Z" stroke-width="0" opacity=".15"></path> <path d="m27,8H5c-1.105,0-2,.895-2,2v1c0-1.105.895-2,2-2h22c1.105,0,2,.895,2,2v-1c0-1.105-.895-2-2-2Z" fill="#fff" opacity=".2" stroke-width="0"></path> <path d="m13.392,12.624l-2.838,6.77h-1.851l-1.397-5.403c-.085-.332-.158-.454-.416-.595-.421-.229-1.117-.443-1.728-.576l.041-.196h2.98c.38,0,.721.253.808.69l.738,3.918,1.822-4.608h1.84Z" fill="#fff" stroke-width="0"></path> <path d="m20.646,17.183c.008-1.787-2.47-1.886-2.453-2.684.005-.243.237-.501.743-.567.251-.032.943-.058,1.727.303l.307-1.436c-.421-.152-.964-.299-1.638-.299-1.732,0-2.95.92-2.959,2.238-.011.975.87,1.518,1.533,1.843.683.332.912.545.909.841-.005.454-.545.655-1.047.663-.881.014-1.392-.238-1.799-.428l-.318,1.484c.41.188,1.165.351,1.947.359,1.841,0,3.044-.909,3.05-2.317" fill="#fff" stroke-width="0"></path> <path d="m25.423,12.624h-1.494c-.337,0-.62.195-.746.496l-2.628,6.274h1.839l.365-1.011h2.247l.212,1.011h1.62l-1.415-6.77Zm-2.16,4.372l.922-2.542.53,2.542h-1.452Z" fill="#fff" stroke-width="0"></path> <path fill="#fff" stroke-width="0" d="M15.894 12.624L14.446 19.394 12.695 19.394 14.143 12.624 15.894 12.624z"></path> </g> </svg>');
        $mastercard_svg = 'data:image/svg+xml;base64,' . base64_encode('<svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"> <g class="nc-icon-wrapper"> <rect x="2" y="7" width="28" height="18" rx="3" ry="3" fill="#fff" stroke-width="0"></rect> <path d="m27,7H5c-1.657,0-3,1.343-3,3v12c0,1.657,1.343,3,3,3h22c1.657,0,3-1.343,3-3v-12c0-1.657-1.343-3-3-3Zm2,15c0,1.103-.897,2-2,2H5c-1.103,0-2-.897-2-2v-12c0-1.103.897-2,2-2h22c1.103,0,2,.897,2,2v12Z" stroke-width="0" opacity=".15"></path> <path d="m27,8H5c-1.105,0-2,.895-2,2v1c0-1.105.895-2,2-2h22c1.105,0,2,.895,2,2v-1c0-1.105-.895-2-2-2Z" fill="#fff" opacity=".2" stroke-width="0"></path> <path fill="#ff5f00" stroke-width="0" d="M13.597 11.677H18.407V20.32H13.597z"></path> <path d="m13.902,15.999c0-1.68.779-3.283,2.092-4.322-2.382-1.878-5.849-1.466-7.727.932-1.863,2.382-1.451,5.833.947,7.712,2,1.573,4.795,1.573,6.795,0-1.329-1.038-2.107-2.642-2.107-4.322Z" fill="#eb001b" stroke-width="0"></path> <path d="m24.897,15.999c0,3.039-2.459,5.497-5.497,5.497-1.237,0-2.428-.412-3.39-1.176,2.382-1.878,2.795-5.329.916-7.727-.275-.336-.58-.657-.916-.916,2.382-1.878,5.849-1.466,7.712.932.764.962,1.176,2.153,1.176,3.39Z" fill="#f79e1b" stroke-width="0"></path> </g> </svg>');

        // Build icons array
        $icons = array();

        // Only show Cheqpay icon for Mexico
        $base_country = WC()->countries->get_base_country();
        if ($base_country === 'MX') {
            $cheqpay_svg = 'data:image/svg+xml;base64,' . base64_encode('<svg width="32" height="100%" viewBox="0 0 1422 375" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M625.468 83.0351C638.966 80.0776 654.529 78.5679 669.158 81.4169C677.949 83.1293 687.011 85.9515 693.375 92.2861C693.375 92.2861 693.375 86.8204 693.375 84.3447H755.767V374.111C738.839 367.878 722.836 357.869 706.547 350.147C696.599 345.432 694.497 339.729 694.497 329.435V284.88C678.226 296.315 661.4 296.031 644.775 295.403C632.352 294.93 619.919 292.636 609.428 285.372C597.855 277.358 590.61 266.03 590.469 251.771C590.059 210.177 590.29 168.577 590.225 126.977C590.195 104.664 604.262 87.6793 625.468 83.0351ZM672.104 133.924C652.919 133.924 652.126 148.299 652.126 151.283C652.126 154.266 652.111 216.294 652.111 219.812C652.111 223.331 651 240.727 672.014 240.727C693.028 240.726 693.367 224.294 693.367 219.814V187.643C693.367 175.525 693.428 163.407 693.428 151.29C693.428 145.705 691.289 133.924 672.104 133.924Z" fill="#01467F"/> <path d="M874.717 81.4169C889.345 78.5678 904.909 80.0775 918.407 83.0351C939.613 87.6794 953.679 104.664 953.649 126.977C953.584 168.577 953.816 210.177 953.406 251.771C953.265 266.03 946.019 277.358 934.446 285.372C923.955 292.636 911.522 294.93 899.1 295.403C882.474 296.031 865.648 296.315 849.377 284.88V329.435C849.377 339.729 847.276 345.432 837.327 350.147C821.038 357.869 805.035 367.878 788.108 374.111V84.3447H850.499V92.2861C856.863 85.9514 865.925 83.1293 874.717 81.4169ZM871.771 133.924C852.586 133.924 850.446 145.705 850.446 151.29C850.446 163.407 850.508 175.525 850.508 187.643V219.814C850.508 224.294 850.846 240.727 871.861 240.727C892.875 240.726 891.763 223.331 891.763 219.812C891.763 216.294 891.748 154.266 891.748 151.283C891.748 148.299 890.956 133.924 871.771 133.924Z" fill="#01467F"/> <path d="M362.478 290.801L299.876 290.837V283.899C299.876 241.161 300.098 156.255 300.098 156.255C300.098 156.255 301.303 136.355 279.488 136.355C257.673 136.355 258.466 155.709 258.466 155.709V290.866L196.975 291.017V0.882629C204.604 4.25424 211.868 7.33908 219.019 10.6649C225.101 13.4918 228.321 14.8826 237.097 19.4884C252.252 27.4416 258.087 38.4522 258.415 54.0393C258.66 65.6999 258.466 77.3674 258.466 90.0495C269.469 80.7135 281.811 80.5778 293.967 80.5778C309.435 80.5778 319.199 80.5778 331.435 84.8945C349.021 91.0981 358.903 103.315 361.387 121.555C362.158 127.247 362.423 133.046 362.434 138.794C362.512 187.129 362.478 235.466 362.478 283.804V290.801Z" fill="#01467F"/> <path d="M1038.03 83.0687C1058.9 79.2339 1079.76 78.7804 1100.43 84.8821C1125.74 92.3567 1140.85 109.504 1146.09 134.768C1148.64 147.022 1149.33 159.82 1149.47 172.385C1149.94 212.911 1149.62 253.442 1149.62 293.969C1129.19 293.969 1086.8 293.969 1086.8 293.969V284.899C1086.8 284.899 1075.19 292.028 1063.23 293.118C1046.04 294.686 1028.81 294.773 1014.57 289.174C998.576 282.889 984.517 268.408 984.283 251.342C984.122 239.589 984.389 227.727 984.389 215.973C984.389 193.363 996.001 167.223 1021.09 167.223C1046.17 167.223 1085.34 167.223 1085.34 167.223V146.578C1085.34 142.789 1083.56 134.073 1065.15 134.073C1046.81 134.073 1046.18 146.544 1046.17 146.628C1046.17 146.628 1004.9 146.628 984.263 146.628C986.048 129.735 991.313 114.136 1002.7 101.775C1012.11 91.553 1024.41 85.5698 1038.03 83.0687ZM1085.49 208.252C1085.49 208.252 1067.11 208.252 1057.61 208.252C1048.1 208.252 1045.2 215.734 1044.93 223.877C1044.68 231.123 1047.85 238.354 1056.67 240.177C1065.5 242 1085.42 242.904 1085.42 230.683C1085.42 225.009 1085.49 208.252 1085.49 208.252Z" fill="#01467F"/> <path d="M450.492 82.7717C472.976 78.9538 495.268 78.7337 516.972 87.1008C538.835 95.5307 552.712 111.806 556.414 134.243C559.84 155.014 558.886 208.41 558.886 208.41H455.79C455.79 215.219 455.904 222.527 457.424 229.181C459.264 237.227 466.082 240.88 473.672 241.626C481.644 242.408 489.227 240.835 494.386 233.403C495.639 231.595 496.292 229.548 496.296 229.534L558.886 229.569C546.92 263.672 527.021 292.594 488.891 295.171C488.782 295.18 451.489 298.365 432.151 287.186C413.621 276.473 404.32 264.911 397.734 244.567C394.344 234.096 394.346 225.969 394.147 216.616C393.673 194.232 392.997 171.766 394.339 149.447C396.351 115.983 413.945 88.9821 450.492 82.7717ZM475.903 134.26C454.749 134.26 455.861 150.243 455.861 151.321C455.861 157.169 455.746 161.261 455.746 166.541H497.103C497.103 160.485 497.063 157.245 497.063 151.288C497.063 147.777 497.057 134.26 475.903 134.26Z" fill="#01467F"/> <path d="M104.307 208.883H166.621C166.621 237.041 162.022 262.332 138.069 280.59C127.603 288.567 115.289 292.324 102.544 294.275C85.3204 296.912 68.1663 296.126 51.1975 291.686C26.2912 285.163 10.5507 269.337 4.18821 244.707C1.80972 235.5 0.780169 225.749 0.574599 216.212C0.0955023 194.025 -0.522906 171.755 0.766578 149.629C2.73393 115.897 20.4537 89.0636 56.7037 82.7989C79.3571 78.8843 101.871 78.6587 123.694 87.1937C145.449 95.705 157.936 112.298 162.783 134.546C165.008 144.771 166.234 155.383 166.616 166.405H104.297C104.297 162.825 104.142 155.498 104.142 155.498C104.142 155.498 104.278 134.778 83.0121 134.934C61.7465 135.09 62.3288 154.327 62.3288 154.327L62.39 221.518C62.39 221.518 62.0074 243.107 82.0948 242.798C102.182 242.489 103.489 221.518 103.489 221.518C103.489 221.518 104.256 213.653 104.307 208.883Z" fill="#01467F"/> <path d="M1330.33 278.654C1331.01 277.323 1330.07 275.737 1328.57 275.737C1318.61 275.737 1288.36 275.737 1272.49 275.737C1249.18 275.534 1244.55 285.196 1243.95 286.751C1243.9 286.894 1243.84 287.029 1243.77 287.163L1206.06 355.006C1205.32 356.339 1206.28 357.977 1207.81 357.977H1237.25C1237.25 357.977 1258.25 358.057 1267.8 357.875C1274.54 357.746 1281.64 357.584 1287.77 353.229C1295.83 347.503 1303.19 331.132 1303.19 331.132L1330.33 278.654Z" fill="#01467F"/> <path d="M1167.89 86.4507C1167.89 86.4507 1204.05 86.508 1222.1 86.508C1245.97 86.2874 1255.07 102.448 1261 121.443C1275.33 167.307 1302.03 260.99 1302.03 260.99H1277.52C1277.52 260.99 1257.75 261.071 1248.75 260.888C1242.41 260.759 1235.73 260.598 1229.96 256.242C1222.36 250.517 1218.36 242.542 1215.43 234.146C1198.4 185.322 1183.23 135.821 1167.89 86.4507Z" fill="#219D73"/> <path d="M1421.94 6C1413.38 33.5429 1404.88 61.1264 1396.07 88.6104C1380.96 137.265 1365.99 186.034 1349.2 234.146C1346.27 242.542 1342.27 250.517 1334.68 256.242C1329.52 260.134 1323.64 260.675 1317.92 260.839L1294.86 183.117C1288.47 161.566 1298.12 142.989 1304.75 121.743C1304.76 121.72 1304.77 121.697 1304.78 121.674C1312.85 93.9166 1322.17 62.2948 1328.83 40.9912C1334.76 21.997 1343.87 5.83606 1367.73 6.05664C1385.75 6.05664 1421.82 6.00019 1421.94 6Z" fill="#219D73"/> </svg>');
            $icons[] = array(
                'id' => 'cheqpay',
                'src' => $cheqpay_svg,
                'alt' => 'Cheqpay'
            );
        }

        $icons[] = array(
            'id' => 'visa',
            'src' => $visa_svg,
            'alt' => 'Visa'
        );
        $icons[] = array(
            'id' => 'mastercard',
            'src' => $mastercard_svg,
            'alt' => 'Mastercard'
        );

        return array(
            'title' => $title,
            'description' => $description,
            'supports' => array('products'),
            'paymentMethod' => $payment_method,
            'isTestMode' => ($environment === 'sandbox'),
            'apiUrl' => $api_url,
            'vgsVaultId' => $vgs_vault_id,
            'vgsEnvironment' => $vgs_environment,
            'vgsCname' => CHEQPAY_VGS_CNAME,
            'i18n' => array(
                'ERROR_CARD_NUMBER_INVALID' => __('ERROR_CARD_NUMBER_INVALID', 'cheqpay-payment-gateway'),
                'ERROR_CARD_EXPIRY_INVALID' => __('ERROR_CARD_EXPIRY_INVALID', 'cheqpay-payment-gateway'),
                'ERROR_CARD_CVC_INVALID' => __('ERROR_CARD_CVC_INVALID', 'cheqpay-payment-gateway'),
                'PAYMENT_FAILED_FORM_NOT_INITIALIZED' => __('PAYMENT_FAILED_FORM_NOT_INITIALIZED', 'cheqpay-payment-gateway'),
                'PAYMENT_FAILED_FORM_LOADING' => __('PAYMENT_FAILED_FORM_LOADING', 'cheqpay-payment-gateway'),
                'PAYMENT_FAILED_CARD_PROCESSING' => __('PAYMENT_FAILED_CARD_PROCESSING', 'cheqpay-payment-gateway'),
                'PAYMENT_FAILED_CARD_DETAILS' => __('PAYMENT_FAILED_CARD_DETAILS', 'cheqpay-payment-gateway'),
                'LABEL_CARD_NUMBER' => __('LABEL_CARD_NUMBER', 'cheqpay-payment-gateway'),
                'LABEL_EXPIRY_DATE' => __('LABEL_EXPIRY_DATE', 'cheqpay-payment-gateway'),
                'LABEL_CVC' => __('LABEL_CVC', 'cheqpay-payment-gateway'),
                'MESSAGE_LOADING_PAYMENT_FORM' => __('MESSAGE_LOADING_PAYMENT_FORM', 'cheqpay-payment-gateway'),
                'PLACEHOLDER_CARD_NUMBER' => __('PLACEHOLDER_CARD_NUMBER', 'cheqpay-payment-gateway'),
                'PLACEHOLDER_EXPIRY_DATE' => __('PLACEHOLDER_EXPIRY_DATE', 'cheqpay-payment-gateway'),
                'PLACEHOLDER_CVC' => __('PLACEHOLDER_CVC', 'cheqpay-payment-gateway'),
            ),
            'icons' => $icons,
            'iframe' => array(
                'colorBackground' => $this->get_setting('color_background', '#ffffff'),
                'colorText' => $this->get_setting('color_text', '#333333'),
                'colorBorder' => $this->get_setting('color_border', '#e0e0e0'),
                'colorBorderSelected' => $this->get_setting('color_border_selected', '#0F172A'),
                'colorPlaceholder' => $this->get_setting('color_placeholder', '#64748B'),
                'radiusBorder' => $this->get_setting('radius_border', '8px'),
            ),
        );
    }

    protected function get_setting($key, $default = '') {
        return isset($this->settings[$key]) ? $this->settings[$key] : $default;
    }
}
