<?php

namespace CheerlinkAIChat\Utils;

if (!defined('WPINC')) {
    die('File loaded directly. Exiting.');
}

/**
 * Provide the methods for wordpress basic information.
 */
class WPInfoHelper {

    /**
     *  Get Timezone.
     *
     * @return string
     */
    function get_wordpress_timezone_info() {
        $timezone_string = get_option('timezone_string');
        $gmt_offset = get_option('gmt_offset');

        if (!empty($timezone_string)) {
            $timezone = new DateTimeZone($timezone_string);
            return [
                'timezone_string' => $timezone_string,
                'gmt_offset' => $gmt_offset,
                'timezone_object' => $timezone
            ];
        } elseif ($gmt_offset !== '') {
            $offset = floatval($gmt_offset) * 3600; // turn to seconds
            $timezone = timezone_name_from_abbr('', $offset, 0);
            return [
                'timezone_string' => $timezone,
                'gmt_offset' => $gmt_offset,
                'timezone_object' => new DateTimeZone($timezone)
            ];
        }

        return null; // if not set timezone.
    }
}