<?php

namespace CheerlinkAIChat\Utils;

if (!defined('WPINC')) {
    die('File loaded directly. Exiting.');
}

class UUIDHelper
{
    /**
     * Gen UUID v4
     *
     * @return string
     */
    public static function generateUUID()
    {
        if (function_exists('openssl_random_pseudo_bytes')) {
            $data = openssl_random_pseudo_bytes(16);
        } else {
            //
            $data = "";
            for ($i = 0; $i < 16; $i++) {
                $data .= chr(wp_rand(0, 255));
            }
        }

        //
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);

        //
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }
}
