<?php
class ChatRag_Frontend {
    
    public function __construct() {
        add_action('wp_footer', array($this, 'add_chatbot_script'));
    }
    
    public function add_chatbot_script() {
        $agent_id = get_option('chatrag_agent_id');
        
        // Don't load if no agent ID
        if (empty($agent_id)) {
            return;
        }
        
        ?>
        <!-- Chatrag AI Agent -->
        <script 
            src="https://chatrag.co/embed.min.js" 
            data-agent-id="<?php echo esc_attr($agent_id); ?>" 
            defer
        ></script>
        <!-- End Chatrag AI Agent -->
        <?php
    }
}