<?php
class ChatRag_Admin {
    
    public function __construct() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
        add_action('admin_init', array($this, 'register_settings'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_scripts'));
    }
    
    public function add_admin_menu() {
        add_options_page(
            'ChatRag Settings',
            'ChatRag',
            'manage_options',
            'chatrag',
            array($this, 'admin_page_html')
        );
    }
    
    public function register_settings() {
        register_setting('chatrag_settings', 'chatrag_agent_id', array(
            'sanitize_callback' => 'sanitize_text_field'
        ));
        
        add_settings_section(
            'chatrag_main_section',
            'Chatrag Configuration',
            array($this, 'section_callback'),
            'chatrag'
        );
        
        add_settings_field(
            'chatrag_agent_id',
            'Agent ID',
            array($this, 'agent_id_field_callback'),
            'chatrag',
            'chatrag_main_section'
        );
    }
    
    public function section_callback() {
        echo '<p>Enter your ChatRAG settings below. You can find your Agent ID in your <a href="https://chatrag.co/agents" target="_blank">ChatRAG dashboard</a>.</p>';
        echo '<p>This plugin uses the ChatRAG external service. By using this plugin, you agree to ChatRAG\'s <a href="https://chatrag.co/terms" target="_blank">Terms of Service</a> and <a href="https://chatrag.co/privacy" target="_blank">Privacy Policy</a>.</p>';
    }
    
    public function agent_id_field_callback() {
        $agent_id = get_option('chatrag_agent_id');
        echo '<input type="text" name="chatrag_agent_id" value="' . esc_attr($agent_id) . '" class="regular-text" placeholder="Enter your Agent ID">';
        echo '<p class="description">Your unique Agent ID from Chatrag</p>';
        
        // Show embed code if agent ID exists
        if (!empty($agent_id)) {
            echo '<div style="margin-top: 10px; background: #f6f7f7; padding: 10px; border-radius: 4px;">';
            echo '<strong>Embed Code:</strong><br>';
            echo '<code>&lt;script src="https://chatrag.co/embed.min.js" data-agent-id="' . esc_attr($agent_id) . '" defer&gt;&lt;/script&gt;</code>';
            echo '</div>';
        }
    }
    
    public function admin_page_html() {
        if (!current_user_can('manage_options')) {
            return;
        }
        ?>
        <div class="wrap">
            <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
            
            <?php if (empty(get_option('chatrag_agent_id'))) : ?>
                <div class="notice notice-warning">
                    <p><strong>Setup Required:</strong> Please enter your Agent ID to activate the chatbot.</p>
                </div>
            <?php endif; ?>
            
            <form action="options.php" method="post">
                <?php
                settings_fields('chatrag_settings');
                do_settings_sections('chatrag');
                submit_button('Save Settings');
                ?>
            </form>
            
            <div class="chatrag-instructions">
                <h3>How to get your Agent ID:</h3>
                <ol>
                    <li>Log into your <a href="https://chatrag.co/agents" target="_blank">Chatrag dashboard</a></li>
                    <li>Select the agent you want to embed</li>
                    <li>Copy your unique Agent ID</li>
                    <li>Paste it in the field above and save</li>
                </ol>
            </div>
        </div>
        <?php
    }
    
    public function enqueue_admin_scripts($hook) {
        if ('settings_page_chatrag' !== $hook) {
            return;
        }
        
        wp_enqueue_style(
            'chatrag-admin-css',
            CHATRAG_PLUGIN_URL . 'assets/css/chatrag-admin.css',
            array(),
            CHATRAG_VERSION
        );
    }
}