<?php
/**
 * Plugin Name: ChatRAG
 * Description: Integrate ChatRAG AI agents into your WordPress site with a simple script embed.
 * Version: 1.0.0
 * Author: Guna
 * Author URI: https://chatrag.co
 * License: GPL v2 or later
 * Text Domain: chatrag
 * Requires at least: 5.6
 * Tested up to: 6.9
 * Requires PHP: 7.4
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('CHATRAG_VERSION', '1.0.0');
define('CHATRAG_PLUGIN_URL', plugin_dir_url(__FILE__));
define('CHATRAG_PLUGIN_PATH', plugin_dir_path(__FILE__));

// Include required files
require_once CHATRAG_PLUGIN_PATH . 'includes/class-chatrag-admin.php';
require_once CHATRAG_PLUGIN_PATH . 'includes/class-chatrag-frontend.php';

// Initialize plugin classes
function chatrag_init() {
    new ChatRag_Admin();
    new ChatRag_Frontend();
}
add_action('plugins_loaded', 'chatrag_init');

// Activation hook
register_activation_hook(__FILE__, 'chatrag_activate');
function chatrag_activate() {
    // Set default option
    add_option('chatrag_agent_id', '');
}

// Deactivation hook
register_deactivation_hook(__FILE__, 'chatrag_deactivate');
function chatrag_deactivate() {
    // Optional: Add cleanup if needed in future
}