<?php

/**
 * Fired when the plugin is uninstalled.
 *
 * When populating this file, consider the following flow
 * of control:
 *
 * - This method should be static
 * - Check if the $_REQUEST content actually is the plugin name
 * - Run an admin referrer check to make sure it goes through authentication
 * - Verify the output of $_GET makes sense
 * - Repeat with other user roles. Best directly by using the links/query string parameters.
 * - Repeat things for multisite. Once for a single site in the network, once sitewide.
 *
 * This file may be updated more in future version of the Boilerplate; however, this is the
 * general skeleton and outline for how the file should work.
 *
 * For more information, see the following discussion:
 * https://github.com/tommcfarlin/WordPress-Plugin-Boilerplate/pull/123#issuecomment-28541913
 *
 * @link       https://chatolia.com
 * @since      1.0.0
 *
 * @package    Chatolia
 */

// If uninstall not called from WordPress, then exit.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

// Remove plugin options on uninstall.
// Multisite: remove per-site option on each site and any network option if used later.

// Option name used by the plugin to store settings.
$chatolia_option_name = 'chatolia_settings';

if ( is_multisite() ) {
    // Iterate over all sites to delete the per-site option.
    $chatolia_sites = get_sites( array( 'fields' => 'ids' ) );
    if ( $chatolia_sites && is_array( $chatolia_sites ) ) {
        foreach ( $chatolia_sites as $chatolia_site_id ) {
            switch_to_blog( $chatolia_site_id );
            delete_option( $chatolia_option_name );
            restore_current_blog();
        }
    }

    // Cleanup potential network-wide default (not currently used, reserved for future use).
    delete_site_option( $chatolia_option_name );
} else {
    delete_option( $chatolia_option_name );
}
