<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://chatolia.com
 * @since             1.0.0
 * @package           Chatolia
 *
 * @wordpress-plugin
 * Plugin Name:       Chatolia
 * Plugin URI:        https://chatolia.com
 * Description:       Easily embed and manage your AI chatbots on any WordPress site. With Chatolia, you can create, train, and deploy fully customizable AI assistants powered by leading LLMs, all from the cloud. This plugin provides a simple interface to connect your Chatolia account, insert chatbot widgets, and control appearance or behavior using shortcodes or Gutenberg blocks.
 * Version:           1.1.3
 * Author:            Senol Sahin
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       chatolia
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'CHATOLIA_VERSION', '1.1.3' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-chatolia-activator.php
 */
function chatolia_activate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-chatolia-activator.php';
	Chatolia_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-chatolia-deactivator.php
 */
function chatolia_deactivate() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-chatolia-deactivator.php';
	Chatolia_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'chatolia_activate' );
register_deactivation_hook( __FILE__, 'chatolia_deactivate' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-chatolia.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function chatolia_run() {

	$plugin = new Chatolia();
	$plugin->run();

}
chatolia_run();
