<?php
/**
 * Admin settings page markup.
 *
 * @link       https://chatolia.com
 * @since      1.0.0
 *
 * @package    Chatolia
 * @subpackage Chatolia/admin/partials
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="wrap chatolia-admin-page">
    <h1 class="wp-heading-inline">
        <?php echo esc_html__( 'Chatolia', 'chatolia' ); ?>
    </h1>
    <hr class="wp-header-end">

    <div id="poststuff">
        <div id="post-body" class="metabox-holder columns-2">
            <!-- Main Content Area -->
            <div id="post-body-content">
                
                <!-- Settings Form -->
                <div class="postbox">
                    <div class="postbox-header">
                        <h2 class="hndle">
                            <span class="dashicons dashicons-admin-settings"></span>
                            <?php echo esc_html__( 'Configuration', 'chatolia' ); ?>
                        </h2>
                    </div>
                    <div class="inside">
                        <?php settings_errors( 'chatolia_settings' ); ?>
                        <div class="notice notice-info is-dismissible" style="margin: 0 0 15px 0;">
                            <p>
                                <?php
                                if ( ! empty( $showing_demo_preview ) ) {
                                    echo wp_kses_post(
                                        sprintf(
                                            /* translators: %1$s: tutorial URL, %2$s: token dashboard URL */
                                            __( 'You are seeing the demo preview until you add a token. To connect and customize your own bot (data, training, settings), <a href="%2$s" target="_blank" rel="noopener noreferrer">get your token</a>. Need help? <a href="%1$s" target="_blank" rel="noopener noreferrer">View the setup tutorial</a>.', 'chatolia' ),
                                            esc_url( 'https://docs.chatolia.com/agents/deploy#wordpress' ),
                                            esc_url( 'https://www.chatolia.com/dashboard/settings/tokens' )
                                        )
                                    );
                                } else {
                                    echo wp_kses_post(
                                        sprintf(
                                            /* translators: %1$s: tutorial URL */
                                            __( 'Need help to customize or train your bot? <a href="%1$s" target="_blank" rel="noopener noreferrer">View the setup tutorial</a>.', 'chatolia' ),
                                            esc_url( 'https://docs.chatolia.com/agents/deploy#wordpress' )
                                        )
                                    );
                                }
                                ?>
                            </p>
                        </div>
                        <form method="post" action="<?php echo esc_url( admin_url( 'options.php' ) ); ?>">
                            <?php
                            settings_fields( 'chatolia_settings_group' );
                            do_settings_sections( 'chatolia' );
                            submit_button( esc_html__( 'Save Changes', 'chatolia' ), 'primary large' );
                            ?>
                            <?php if ( ! empty( $agent_id ) ) : ?>
                                <div class="chatolia-shortcode-inline" style="margin-top:12px;">
                                    <label for="chatolia-shortcode-field"><strong><?php echo esc_html__( 'Embed on specific pages', 'chatolia' ); ?>:</strong></label>
                                    <input type="text" id="chatolia-shortcode-field" value="[chatolia]" readonly onclick="this.select();" aria-label="<?php echo esc_attr__( 'Chatolia shortcode', 'chatolia' ); ?>" />
                                    <span class="description"><?php echo esc_html__( 'Copy and paste this shortcode into any page or post.', 'chatolia' ); ?></span>
                                </div>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>

            </div>

            <!-- Sidebar -->
            <div id="postbox-container-1" class="postbox-container">
                
                <!-- Preview -->
                <div class="postbox">
                    <div class="postbox-header">
                        <h2 class="hndle">
                            <span class="dashicons dashicons-visibility"></span>
                            <?php echo esc_html__( 'Preview', 'chatolia' ); ?>
                        </h2>
                    </div>
                    <div class="inside">
                        <iframe
                            class="chatolia-preview-frame"
                            title="<?php echo esc_attr__( 'Chatolia Preview', 'chatolia' ); ?>"
                            src="<?php echo esc_url( $preview_url ); ?>"
                            sandbox="<?php echo esc_attr( 'allow-scripts allow-same-origin' ); ?>"
                            loading="<?php echo esc_attr( 'lazy' ); ?>"
                        ></iframe>
                    </div>
                </div>
            </div>
        </div>
        <br class="clear">
    </div>
</div>
