(function() {
    // Se o objeto de dados do PHP não existir, o script não executa.
    if (typeof cblc_params === 'undefined') {
        return;
    }

    // Espera a página carregar completamente para manipular os elementos.
    document.addEventListener('DOMContentLoaded', function() {
        const modal = document.getElementById('wa-lead-modal');
        const btn = document.getElementById('wa-float-button');
        const span = document.getElementById('wa-modal-close');
        const form = document.getElementById('wa-lead-form');

        // A função de máscara foi removida daqui para suportar telefones internacionais.

        if (btn && modal) { btn.onclick = () => { modal.style.display = "flex"; } }
        if (span) { span.onclick = () => { modal.style.display = "none"; } }
        window.onclick = (event) => { if (event.target == modal) { modal.style.display = "none"; } }

        if (form) {
            form.addEventListener('submit', function(event) {
                event.preventDefault();
                const submitButton = this.querySelector('button');
                submitButton.textContent = cblc_params.sending;
                submitButton.disabled = true;

                if (typeof dataLayer !== 'undefined') {
                    dataLayer.push({
                        'event': 'whatsapp_lead_submitted',
                        'lead_source': 'CBLC Plugin',
                        'user_data': {
                            'email': this.elements.email ? this.elements.email.value : undefined,
                            'phone_number': this.elements.phone ? this.elements.phone.value.replace(/\D/g, '') : undefined,
                            'first_name': this.elements.name ? this.elements.name.value.split(' ')[0] : undefined
                        }
                    });
                }
                
                const formData = new FormData(this);
                formData.append('action', 'cblc_save_lead');
                formData.append('_wpnonce', cblc_params.nonce);

                fetch(cblc_params.ajax_url, {
                    method: 'POST',
                    body: formData
                })
                .finally(() => {
                    const nameInput = this.elements.name;
                    const userName = nameInput ? nameInput.value : '';
                    const waLink = `https://wa.me/${cblc_params.phoneNumber}?text=${encodeURIComponent(`Hello, my name is ${userName}. ${cblc_params.defaultMessage}`)}`;
                    window.open(waLink, '_blank');
                    
                    modal.style.display = 'none';
                    submitButton.textContent = cblc_params.startConversation;
                    submitButton.disabled = false;
                    form.reset();
                });
            });
        }
    });
})();