<?php
/**
 * Plugin Activator
 *
 * @package Charity_Campaigns
 * @since 1.0.0
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin activation class.
 *
 * @since 1.0.0
 */
class Charity_Campaigns_Activator {

	/**
	 * Activate the plugin.
	 *
	 * @since 1.0.0
	 */
	public static function activate() {
		// Flush rewrite rules
		flush_rewrite_rules();

		// Set default options
		self::set_default_options();
	}

	/**
	 * Deactivate the plugin.
	 *
	 * @since 1.0.0
	 */
	public static function deactivate() {
		// Flush rewrite rules
		flush_rewrite_rules();
	}

	/**
	 * Set default plugin options.
	 *
	 * @since 1.0.0
	 */
	private static function set_default_options() {
		// Add any default options here if needed
		if ( ! get_option( 'charity_campaigns_version' ) ) {
			add_option( 'charity_campaigns_version', CCFS_VERSION );
		}
	}
}
