<?php
/**
 * Plugin Name: Charity Campaigns & Fundraising System
 * Description: Create fundraising campaigns and accept donations via Stripe using a simple shortcode.
 * Version: 1.0.0
 * Author: Rolly Bueno
 * Author URI: https://rollybueno.com
 * Requires at least: 6.2
 * Tested up to: 6.8
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: charity-campaigns
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants
define( 'CCFS_VERSION', '1.0.0' );
define( 'CCFS_PLUGIN_FILE', __FILE__ );
define( 'CCFS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'CCFS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * Main plugin class.
 *
 * @since 1.0.0
 */
class Charity_Campaigns {

	/**
	 * Plugin instance.
	 *
	 * @since 1.0.0
	 * @var Charity_Campaigns
	 */
	private static $instance = null;

	/**
	 * Post types instance.
	 *
	 * @since 1.0.0
	 * @var Charity_Campaigns_Post_Types
	 */
	private $post_types = null;

	/**
	 * Metaboxes instance.
	 *
	 * @since 1.0.0
	 * @var Charity_Campaigns_Metaboxes
	 */
	private $metaboxes = null;

	/**
	 * Admin menu instance.
	 *
	 * @since 1.0.0
	 * @var Charity_Campaigns_Admin_Menu
	 */
	private $admin_menu = null;

	/**
	 * Stripe instance.
	 *
	 * @since 1.0.0
	 * @var Charity_Campaigns_Stripe_Simple
	 */
	private $stripe = null;

	/**
	 * Get plugin instance.
	 *
	 * @since 1.0.0
	 * @return Charity_Campaigns
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor.
	 *
	 * @since 1.0.0
	 */
	private function __construct() {
		$this->load_dependencies();
	}

	/**
	 * Load plugin dependencies.
	 *
	 * @since 1.0.0
	 */
	private function load_dependencies() {
		require_once CCFS_PLUGIN_DIR . 'includes/class-post-types.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-activator.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-metaboxes.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-functions.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-admin-menu.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-donations-service.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-admin-columns.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-settings.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-shortcodes.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-stripe-simple.php';
		require_once CCFS_PLUGIN_DIR . 'includes/class-help.php';

		$this->post_types = new Charity_Campaigns_Post_Types();
		$this->metaboxes  = new Charity_Campaigns_Metaboxes();
		$this->admin_menu = new Charity_Campaigns_Admin_Menu();
		$this->stripe     = new Charity_Campaigns_Stripe_Simple();
		// Initialize donations service (hooks inside constructor)
		new Charity_Campaigns_Donations_Service();
		// Initialize admin columns (hooks inside constructor)
		new Charity_Campaigns_Admin_Columns();
		// Initialize settings (hooks inside constructor)
		new Charity_Campaigns_Settings();
		// Initialize shortcodes (hooks inside constructor)
		new Charity_Campaigns_Shortcodes();
	}
}

// Register activation and deactivation hooks
register_activation_hook( __FILE__, array( 'Charity_Campaigns_Activator', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'Charity_Campaigns_Activator', 'deactivate' ) );

// Initialize the plugin
Charity_Campaigns::get_instance();
