/**
 * Settings JavaScript for Charity Campaigns
 *
 * @package CCFS
 * @since 1.0.0
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        // Logo upload functionality
        $('#upload-logo').on('click', function(e) {
            e.preventDefault();
            
            var mediaUploader = wp.media({
                title: 'Choose Organization Logo',
                button: {
                    text: 'Choose Logo'
                },
                multiple: false
            });
            
            mediaUploader.on('select', function() {
                var attachment = mediaUploader.state().get('selection').first().toJSON();
                $('#organization_logo').val(attachment.url);
            });
            
            mediaUploader.open();
        });
    });

})(jQuery);
