<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
class Yeekit_EL_CS_Frontend
{
    public function __construct()
    {
        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);
        add_action('wp_ajax_yeekit_cs_get_datas', [$this, 'ajax_get_options']);
        add_action('wp_ajax_nopriv_yeekit_cs_get_datas', [$this, 'ajax_get_options']);
    }
    public function enqueue_scripts()
    {
        wp_enqueue_script(
            'yeekit-el-chained-selects',
            YEEKIT_EL_CS_PLUGIN_URL . 'assets/chained-selects.js',
            ['jquery'],
            "2.0.1",
            true
        );
        wp_localize_script('yeekit-el-chained-selects', 'yeekitChained_el', [
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('yeekit_chained_el_nonce'),
            'i18n_select' => __('-- Select --', 'chained-selects-for-elementor-forms'),
        ]);
    }
    private function get_form_settings($post_id, $form_id)
    {
        $settings = [];
        $data = get_post_meta($post_id, '_elementor_data', true);
        if (! $data) {
            return [];
        }
        $data = json_decode($data, true);
        if (! is_array($data)) {
            return [];
        }
        return $this->search_form_settings_recursive($data, $form_id);
    }
    private function search_form_settings_recursive($elements, $form_id)
    {
        foreach ($elements as $element) {
            // If this is the correct form widget by ID
            if (
                isset($element['widgetType']) && $element['widgetType'] === 'form' &&
                isset($element['id']) && $element['id'] === $form_id
            ) {
                return $element['settings']['form_fields'] ?? [];
            }
            // If there are child elements, search recursively
            if (!empty($element['elements']) && is_array($element['elements'])) {
                $found = $this->search_form_settings_recursive($element['elements'], $form_id);
                if (!empty($found)) {
                    return $found;
                }
            }
        }
        return [];
    }
    public function ajax_get_options()
    {
        check_ajax_referer('yeekit_chained_el_nonce', 'nonce');
        global $wpdb;
        $form_id      = sanitize_text_field(wp_unslash($_POST['form_id'] ?? ''));
        $field_id      = sanitize_text_field(wp_unslash($_POST['field_id'] ?? ''));
        $post_id  = absint($_POST['post_id'] ?? 0);
        $parent_values = [];
        if (!empty($_POST['parent_values']) && is_array($_POST['parent_values'])) {
            foreach ($_POST['parent_values'] as $k => $v) {
                if (is_array($v)) {
                    $sanitized_array = [];
                    foreach ($v as $item) {
                        $sanitized_array[] = sanitize_text_field(wp_unslash($item));
                    }
                    //$parent_values[sanitize_key($k)] = implode('',$sanitized_array);
                    $parent_values[sanitize_key($k)] = $sanitized_array;
                } else {
                    $parent_values[sanitize_key($k)] = sanitize_text_field(wp_unslash($v));
                }
            }
        }
        $results_return = [];
        if (! $form_id) {
            wp_send_json_success($results_return);
        }
        $fields = $this->get_form_settings($post_id, $form_id);
        foreach ($fields as $field) {
            if (empty($field['custom_id'])) {
                continue;
            }
            if($field['custom_id'] != $field_id){
                continue; 
            }
            if (in_array($field['custom_id'], array_keys($parent_values), true)) {
                continue; // skip parent field, don't reload its options
            }
            $options = [];
            if (!empty($field['yeekit_chained_source']) && $field['yeekit_chained_source'] === 'database') {
                $table  = esc_sql($field['yeekit_chained_db_table']);
                $column = esc_sql($field['yeekit_chained_db_column']);
                $key_col     = '';
                // Custom KEY column
                if (
                    !empty($field['yeekit_chained_db_column_key']) &&
                    $field['yeekit_chained_db_column_key'] === 'yes' &&
                    !empty($field['yeekit_chained_db_column_key_data'])
                ) {
                    $key_col = esc_sql($field['yeekit_chained_db_column_key_data']);
                }
                $where_clauses = [];
                $where_values = [];
                if (!empty($field['yeekit_chained_db_wheres']) && is_array($field['yeekit_chained_db_wheres'])) {
                    foreach ($field['yeekit_chained_db_wheres'] as $where_condition) {
                        $parent_field = $where_condition['yeekit_chained_db_where_parent_field'] ?? '';
                        $operator = strtoupper($where_condition['yeekit_chained_db_where_operator'] ?? '=');
                        $where_column = esc_sql($where_condition['yeekit_chained_db_where_column'] ?? '');
                        $parent_val = '';
                        if ($parent_field) {
                            $parent_val = $parent_values[$parent_field] ?? $parent_field;
                            // Normalize array or scalar parent values for SQL operators
                            if (is_array($parent_val)) {
                                // Remove empty values to avoid invalid comparisons
                                $parent_val = array_values(array_filter($parent_val, function ($v) {
                                    return $v !== '' && $v !== null;
                                }));
                                // If operator is not IN, convert array → single scalar value
                                if (strtoupper($operator) !== 'IN') {
                                    $parent_val = !empty($parent_val) ? reset($parent_val) : '';
                                }
                            } else {
                                // Ensure clean scalar
                                $parent_val = trim((string) $parent_val);
                            }
                        }
                        if ($parent_val === '') {
                            // no value for this where condition, skip it
                            //continue;
                        }
                        if ($operator === 'IN') {
                            $vals = is_array($parent_val) ? $parent_val : explode(',', $parent_val);
                            $placeholders = implode(',', array_fill(0, count($vals), '%s'));
                            $where_clauses[] = "{$where_column} IN ({$placeholders})";
                            foreach ($vals as $v) {
                                $where_values[] = $v;
                            }
                        } elseif ($operator === 'LIKE') {
                            $where_clauses[] = "{$where_column} LIKE %s";
                            $where_values[] = '%' . $parent_val . '%';
                        } elseif (in_array($operator, ['=', '>', '<'])) {
                            $where_clauses[] = "{$where_column} {$operator} %s";
                            $where_values[] = $parent_val;
                        } else {
                            // default equal
                            $where_clauses[] = "{$where_column} = %s";
                            $where_values[] = $parent_val;
                        }
                    }
                }
                if (!empty($where_clauses)) {
                    $where = '';
                    if (!empty($where_clauses)) {
                        $where = 'WHERE ' . implode(' AND ', $where_clauses);
                    }
                    if ($key_col !== '') {
                        $sql = "SELECT DISTINCT {$column}, {$key_col} FROM {$table} {$where} ORDER BY {$column} ASC LIMIT 200";
                    } else {
                        $sql = "SELECT DISTINCT {$column} FROM {$table} {$where} ORDER BY {$column} ASC LIMIT 200";
                    }
                    $results = $wpdb->get_results($wpdb->prepare($sql, ...$where_values), ARRAY_A);
                    foreach ($results as $row) {
                        if (is_array($row)) {
                            $display = isset($row[$column]) ? trim($row[$column]) : '';
                            $key_val = isset($row[$key_col]) ? trim($row[$key_col]) : $display;
                        } else {
                            $display = trim($row);
                            $key_val = $display;
                        }
                        if ($display !== '') {
                            $options[] = [
                                'value' => sanitize_text_field($key_val),
                                'label' => esc_html($display)
                            ];
                        }
                    }
                }
            }
            if (!empty($field['yeekit_chained_source']) && ($field['yeekit_chained_source'] === 'csv' || $field['yeekit_chained_source'] == "google_sheets")) {
                $csv_key = trim($field['yeekit_chained_csv_key']);
                $csv_content = '';
                if (empty($csv_key)) {
                    $results_return[$field['custom_id']] = $options;
                    continue;
                }
                if ($field['yeekit_chained_source'] == "google_sheets") {
                    if (preg_match('/\/d\/([^\/]+)\//', $csv_key, $match)) {
                        $file_id = $match[1];
                        // Default gid=0
                        $gid = 0;
                        if (preg_match('/gid=([0-9]+)/', $csv_key, $gMatch)) {
                            $gid = $gMatch[1];
                        }
                        $csv_key = "https://docs.google.com/spreadsheets/d/{$file_id}/export?format=csv&gid={$gid}";
                    }
                }
                // Check if it's a URL
                if (filter_var($csv_key, FILTER_VALIDATE_URL)) {
                    // Remote file
                    $response = wp_remote_get($csv_key);
                    if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                        $csv_content = wp_remote_retrieve_body($response);
                    }
                } else {
                    // Local path
                    if (file_exists($csv_key)) {
                        $csv_content = file_get_contents($csv_key);
                    } elseif (file_exists(ABSPATH . $csv_key)) {
                        $csv_content = file_get_contents(ABSPATH . $csv_key);
                    }
                }
                if ($csv_content) {
                    $lines = explode("\n", $csv_content);
                    $rows = array_map('str_getcsv', $lines);
                    $header = array_shift($rows);
                    $col_index = array_search($field['yeekit_chained_db_column'], $header);
                    if ($col_index !== false) {
                        foreach ($rows as $row) {
                            if (!is_array($row) || empty($row)) continue;
                            $skip = false;
                            if (!empty($field['yeekit_chained_db_wheres']) && is_array($field['yeekit_chained_db_wheres'])) {
                                foreach ($field['yeekit_chained_db_wheres'] as $where_condition) {
                                    $parent_field = $where_condition['yeekit_chained_db_where_parent_field'] ?? '';
                                    $operator = strtoupper($where_condition['yeekit_chained_db_where_operator'] ?? '=');
                                    $where_column = $where_condition['yeekit_chained_db_where_column'] ?? '';
                                    $parent_val = '';
                                    if ($parent_field) {
                                        $parent_val = $parent_values[$parent_field] ?? $parent_field;
                                    }
                                    if ($parent_val === '') {
                                        // $skip = true;
                                        // break;
                                    }
                                    $where_index = array_search($where_column, $header);
                                    if ($where_index === false || !isset($row[$where_index])) {
                                        $skip = true;
                                        break;
                                    }
                                    $cell_val = $row[$where_index];
                                    if ($operator === 'IN') {
                                        $vals = is_array($parent_val) ? $parent_val : explode(',', $parent_val);
                                        if (!in_array($cell_val, $vals)) {
                                            $skip = true;
                                            break;
                                        }
                                    } elseif ($operator === 'LIKE') {
                                        if (stripos($cell_val, $parent_val) === false) {
                                            $skip = true;
                                            break;
                                        }
                                    } elseif ($operator === '=') {
                                        if ($cell_val != $parent_val) {
                                            $skip = true;
                                            break;
                                        }
                                    } elseif ($operator === '>') {
                                        if ($cell_val <= $parent_val) {
                                            $skip = true;
                                            break;
                                        }
                                    } elseif ($operator === '<') {
                                        if ($cell_val >= $parent_val) {
                                            $skip = true;
                                            break;
                                        }
                                    } else {
                                        if ($cell_val != $parent_val) {
                                            $skip = true;
                                            break;
                                        }
                                    }
                                }
                            }
                            if ($skip) continue;
                            $val = sanitize_text_field($row[$col_index]);
                            if ($val !== '') {
                                $key_val = $val;
                                // If custom key is enabled for CSV
                                if (
                                    !empty($field['yeekit_chained_db_column_key']) &&
                                    $field['yeekit_chained_db_column_key'] === 'yes' &&
                                    !empty($field['yeekit_chained_db_column_key_data'])
                                ) {
                                    $key_col = $field['yeekit_chained_db_column_key_data'];
                                    $key_index = array_search($key_col, $header);
                                    if ($key_index !== false && isset($row[$key_index])) {
                                        $key_val = trim($row[$key_index]);
                                    }
                                }
                                $options[] = [
                                    'value' => sanitize_text_field($key_val),
                                    'label' => esc_html($val)
                                ];
                            }
                            if (!empty($options)) {
                                $options = array_map('unserialize', array_unique(array_map('serialize', $options)));
                                // Limit to 200 (same as database)
                                $options = array_slice($options, 0, 1000);
                            }
                        }
                    }
                }
            }
            if (!empty($field['yeekit_chained_source']) && $field['yeekit_chained_source'] === 'manual') {
                $datas = $field["yeekit_chained_db_wheres_manual"];
                if (is_array($datas) && count($datas) > 0) {
                    $options = "";
                    foreach ($datas as $data) {
                        $parent_id = $data["yeekit_chained_db_where_parent_field"];
                        $operator = $data["yeekit_chained_db_where_operator"];
                        $value = $data["yeekit_chained_db_where_value"];
                        $data_options = $data["yeekit_chained_db_where_options"];
                        if (in_array($parent_id, array_keys($parent_values), true)) {
                            switch ($operator) {
                                case "=":
                                    if ($parent_values[$parent_id] == $value) {
                                        $options = $data_options;
                                    }
                                    break;
                                case ">":
                                    if ($parent_values[$parent_id] > $value) {
                                        $options = $data_options;
                                    }
                                    break;
                                case "<":
                                    if ($parent_values[$parent_id] < $value) {
                                        $options = $data_options;
                                    }
                                    break;
                                case "!=":
                                    if ($parent_values[$parent_id] != $value) {
                                        $options = $data_options;
                                    }
                                    break;
                            }
                        }
                    }
                    if ($options != "") {
                        $options = $this->textarea_to_select_options($options);
                    }
                }
            }
            $results_return[$field['custom_id']] = $options;
        }
        wp_send_json_success($results_return);
    }
    function textarea_to_select_options($raw_textarea)
    {
        $options = [];
        if (!empty($raw_textarea)) {
            $lines = preg_split('/\r\n|\r|\n/', trim($raw_textarea));
            foreach ($lines as $line) {
                $line = trim($line);
                if ($line === '') {
                    continue;
                }
                if (strpos($line, '|') !== false) {
                    list($key, $label) = array_map('trim', explode('|', $line, 2));
                } else {
                    $key = $label = $line;
                }
                $options[] = [
                    'value' => sanitize_text_field($key),
                    'label' => esc_html($label)
                ];
            }
        }
        return $options;
    }
}
new Yeekit_EL_CS_Frontend;
