<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
class Yeekit_EL_CS_Backend
{
    function __construct()
    {
        add_action('elementor/element/form/section_form_fields/before_section_end', array($this, "settings"), 10, 2);
        add_filter('elementor_pro/forms/render/item', array($this, "render_dynamic_field_value"), 9999, 3);
        add_action('elementor/editor/after_enqueue_scripts', array($this, "remove_cache_editor"));
        add_action("elementor/controls/register", array($this, 'register_controls'));
    }
    public function register_controls($controls_manager)
    {
        include YEEKIT_EL_CS_PLUGIN_PATH . 'backend/controls-options.php';
        include YEEKIT_EL_CS_PLUGIN_PATH . 'backend/select.php';
        $controls_manager->register(new \Yeekit_EL_CS_Control());
        $controls_manager->register(new \Yeekit_EL_CS_Control_Select());
    }
    function remove_cache_editor()
    {
        \Elementor\Plugin::$instance->files_manager->clear_cache();
    }
    function settings($widget, $args)
    {
        $elementor = \Elementor\Plugin::instance();
        $control_data = $elementor->controls_manager->get_control_from_stack($widget->get_unique_name(), 'form_fields');
        if (is_wp_error($control_data)) {
            return;
        }
        $field_controls = [
            'yeekit_chained_source_2' => [
                'name'    => 'yeekit_chained_source_2',
                'label'   => __('Chained Selects Source', 'chained-selects-for-elementor-forms'),
                'type'    => "yeekit_select_cs",
                'options' => [
                    ''         => __('To use radio or checkbox fields, please use the Pro version.', 'chained-selects-for-elementor-forms'),
                ],
                'options_pro' => array(
                    'database' => __('Database (Pro)', 'chained-selects-for-elementor-forms'),
                    'manual'   => __('Manual (Pro)', 'chained-selects-for-elementor-forms'),
                    'csv' => __('CSV File (Pro)', 'chained-selects-for-elementor-forms'),
                    'google_sheets' => __('Google Sheets (Pro)', 'chained-selects-for-elementor-forms'),
                ),
                'default'      => '',
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
                'condition'    => [
                    'field_type' => array('radio','checkbox'),
                ],
            ],
            'yeekit_chained_source' => [
                'name'    => 'yeekit_chained_source',
                'label'   => __('Chained Selects Source', 'chained-selects-for-elementor-forms'),
                'type'    => "yeekit_select_cs",
                'options' => [
                    ''         => __('Default', 'chained-selects-for-elementor-forms'),
                    'database' => __('Database', 'chained-selects-for-elementor-forms'),
                    'manual'   => __('Manual', 'chained-selects-for-elementor-forms'),
                ],
                'options_pro' => array(
                    'csv' => __('CSV File (Pro)', 'chained-selects-for-elementor-forms'),
                    'google_sheets' => __('Google Sheets (Pro)', 'chained-selects-for-elementor-forms'),
                ),
                'default'      => '',
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
                'condition'    => [
                    'field_type' => 'select',
                ],
            ],
            'yeekit_chained_csv_key' => [
                'name'      => 'yeekit_chained_csv_key',
                'label'     => __('File URL/Path', 'chained-selects-for-elementor-forms'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'yeekit_chained_source' => ['csv','google_sheets'],
                ],
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            'yeekit_chained_db_table' => [
                'name'      => 'yeekit_chained_db_table',
                'label'     => __('Database Table', 'chained-selects-for-elementor-forms'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'yeekit_chained_source' => 'database',
                ],
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            'yeekit_chained_db_column' => [
                'name'      => 'yeekit_chained_db_column',
                'label'     => __('Database Column', 'chained-selects-for-elementor-forms'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'yeekit_chained_source!' => '',
                    'yeekit_chained_source' => ["database", "csv","google_sheets"]
                ],
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            'yeekit_chained_db_column_key' => [
                'name'      => 'yeekit_chained_db_column_key',
                'label'     => __('Custom Column KEY', 'chained-selects-for-elementor-forms'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'default'  => 'no',
                'condition' => [
                    'yeekit_chained_source!' => '',
                    'yeekit_chained_source' => ["database", "csv","google_sheets"]
                ],
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            'yeekit_chained_db_column_key_data' => [
                'name'      => 'yeekit_chained_db_column_key_data',
                'label'     => __('Column KEY', 'chained-selects-for-elementor-forms'),
                'type'      => \Elementor\Controls_Manager::TEXT,
                'condition' => [
                    'yeekit_chained_source!'       => '',
                    'yeekit_chained_db_column_key' => 'yes',
                    'yeekit_chained_source'        => ["database", "csv","google_sheets"]
                ],
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
            ],
            // Replace yeekit_dynamic_array_parent with three separate controls:
            'yeekit_chained_db_wheres' => array(
                'name'         => 'yeekit_chained_db_wheres',
                'label'        => esc_html__('Where Query', "chained-selects-for-elementor-forms"),
                'type'         => 'yeekit_el_cs_repeater',
                'tab'          => 'content',
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
                'fields'       => [
                    [
                        'name'        => 'yeekit_chained_db_where_column',
                        'label'       => esc_html__('Column', "chained-selects-for-elementor-forms"),
                        'type'        => \Elementor\Controls_Manager::TEXT,
                        'default'     => '',
                    ],
                    [
                        'name'        => 'yeekit_chained_db_where_operator',
                        'label'       => esc_html__('Operator', "chained-selects-for-elementor-forms"),
                        'type'  => \Elementor\Controls_Manager::SELECT,
                        'default'     => '=',
                        'options' => [
                            '='  => '=',
                            'IN' => 'IN',
                            'LIKE' => 'LIKE',
                            '>' => '>',
                            '<' => '<',
                        ],
                    ],
                    [
                        'name'        => 'yeekit_chained_db_where_parent_field',
                        'label'       => esc_html__('Parent Field ID', "chained-selects-for-elementor-forms"),
                        'type'        => \Elementor\Controls_Manager::TEXT,
                        'default'     => '',
                    ],
                ],
                'condition' => [
                    'yeekit_chained_source!' => '',
                    'yeekit_chained_source' => ["database", "csv","google_sheets"]
                ],
                'style_transfer' => false,
                'title_field'    => '{{{ yeekit_chained_db_where_column  }}}',
            ),
            'yeekit_chained_db_wheres_manual' => array(
                'name'         => 'yeekit_chained_db_wheres_manual',
                'label'        => esc_html__('Where', "chained-selects-for-elementor-forms"),
                'type'         => 'yeekit_el_cs_repeater',
                'tab'          => 'content',
                'inner_tab'    => 'form_fields_advanced_tab',
                'tabs_wrapper' => 'form_fields_tabs',
                'fields'       => [
                    [
                        'name'        => 'yeekit_chained_db_where_parent_field',
                        'label'       => esc_html__('Parent Field ID', "chained-selects-for-elementor-forms"),
                        'type'        => \Elementor\Controls_Manager::TEXT,
                        'default'     => '',
                    ],
                    [
                        'name'        => 'yeekit_chained_db_where_operator',
                        'label'       => esc_html__('Operator', "chained-selects-for-elementor-forms"),
                        'type'  => \Elementor\Controls_Manager::SELECT,
                        'default'     => '=',
                        'options' => [
                            '='  => '=',
                            '!=' => '!=',
                            '>' => '>',
                            '<' => '<',
                        ],
                    ],
                    [
                        'name'        => 'yeekit_chained_db_where_value',
                        'label'       => esc_html__('Value', "chained-selects-for-elementor-forms"),
                        'type'        => \Elementor\Controls_Manager::TEXT,
                        'default'     => '',
                    ],
                    [
                        'name'        => 'yeekit_chained_db_where_options',
                        'label'       => esc_html__('Options', "chained-selects-for-elementor-forms"),
                        'type'        => \Elementor\Controls_Manager::TEXTAREA,
                        'default'     => '',
                    ],
                ],
                'condition' => [
                    'yeekit_chained_source!' => '',
                    'yeekit_chained_source' => ["manual"]
                ],
                'style_transfer' => false,
                'title_field'    => '{{{ yeekit_chained_db_where_value  }}}',
            ),
        ];
        $control_data['fields'] = $this->inject_field_controls($control_data['fields'], $field_controls);
        $widget->update_control('form_fields', $control_data);
    }
    function render_dynamic_field_value($item, $item_index, $form)
    {
        $data_where = !empty($item['yeekit_chained_db_wheres']) ? $item['yeekit_chained_db_wheres'] : [];
        $options = [];
        // CSV source
        $fields_supports = array('select','radio','checkbox');
        $item['css_classes'] .= ' field-id-' . sanitize_html_class($item['custom_id']);
        if ( in_array($item['field_type'],$fields_supports) && !empty($item['yeekit_chained_source'])) {
            // Add parent field CSS classes for each where condition
            if (!empty($data_where)) {
                if ($item['yeekit_chained_source'] != "manual") {
                    foreach ($data_where as $where) {
                        if (!empty($where['yeekit_chained_db_where_parent_field'])) {
                            $item['css_classes'] .= ' yeekit-cs-parent-' . sanitize_html_class($where['yeekit_chained_db_where_parent_field']);
                        }
                    }
                }
            }
            // CSV source (supports remote URL or local file, header mapping, and WHERE filtering)
            if (!empty($item['yeekit_chained_csv_key']) && ($item['yeekit_chained_source'] === 'csv' || $item['yeekit_chained_source'] == "google_sheets")  ) {
                $csv_key = trim($item['yeekit_chained_csv_key']);
                if ($item['yeekit_chained_source'] == "google_sheets") {
                    if (preg_match('/\/d\/([^\/]+)\//', $csv_key, $match)) {
                        $file_id = $match[1];
                        // Default gid=0
                        $gid = 0;
                        if (preg_match('/gid=([0-9]+)/', $csv_key, $gMatch)) {
                            $gid = $gMatch[1];
                        }
                        $csv_key = "https://docs.google.com/spreadsheets/d/{$file_id}/export?format=csv&gid={$gid}";
                    }
                }
                $csv_content = '';
                // Fetch remote CSV or read local file
                if (filter_var($csv_key, FILTER_VALIDATE_URL)) {
                    $response = wp_remote_get($csv_key);
                    if (!is_wp_error($response) && wp_remote_retrieve_response_code($response) === 200) {
                        $csv_content = wp_remote_retrieve_body($response);
                    }
                } else {
                    if (file_exists($csv_key)) {
                        $csv_content = file_get_contents($csv_key);
                    } elseif (file_exists(ABSPATH . $csv_key)) {
                        $csv_content = file_get_contents(ABSPATH . $csv_key);
                    }
                }
                if ($csv_content) {
                    // Normalize newlines and parse CSV lines
                    $lines = preg_split('/\r\n|\r|\n/', $csv_content);
                    $rows = array_map('str_getcsv', $lines);
                    if (!empty($rows)) {
                        // Determine header and column indexes (if headers exist)
                        $header = array_map('trim', $rows[0]);
                        $has_header = false;
                        $col_index = null;
                        if (!empty($item['yeekit_chained_db_column'])) {
                            $col_index = array_search($item['yeekit_chained_db_column'], $header);
                            if ($col_index === false) {
                                $col_index = array_search(strtolower($item['yeekit_chained_db_column']), array_map('strtolower', $header));
                            }
                        }
                        if ($col_index !== null) {
                            $has_header = true;
                        } elseif (!empty($header)) {
                            $has_header = true;
                        }
                        // Prepare where indexes and parent values for all conditions
                        $where_conditions = [];
                        if (!empty($data_where)) {
                            foreach ($data_where as $where_item) {
                                $where_column = !empty($where_item['yeekit_chained_db_where_column']) ? $where_item['yeekit_chained_db_where_column'] : '';
                                $where_index = null;
                                if ($where_column !== '') {
                                    $where_index = array_search($where_column, $header);
                                    if ($where_index === false) {
                                        $where_index = array_search(strtolower($where_column), array_map('strtolower', $header));
                                    }
                                }
                                $operator = isset($where_item['yeekit_chained_db_where_operator']) ? $where_item['yeekit_chained_db_where_operator'] : '=';
                                $parent_field_id = !empty($where_item['yeekit_chained_db_where_parent_field']) ? $where_item['yeekit_chained_db_where_parent_field'] : '';
                                $parent_val = '';
                                if ($parent_field_id !== '') {
                                    $parent_val = $this->get_default_value_by_id($parent_field_id, $form);
                                }
                                $parent_vals = [];
                                if ($operator === 'IN' && $parent_val !== '') {
                                    if (!is_array($parent_val)) {
                                        if (strpos($parent_val, "\n") !== false) {
                                            $parent_vals = preg_split('/\r\n|\r|\n/', $parent_val);
                                        } elseif (strpos($parent_val, ',') !== false) {
                                            $parent_vals = array_map('trim', explode(',', $parent_val));
                                        } else {
                                            $parent_vals = [trim($parent_val)];
                                        }
                                    } else {
                                        $parent_vals = $parent_val;
                                    }
                                    // sanitize
                                    $parent_vals = array_values(array_filter(array_map('sanitize_text_field', $parent_vals), function ($v) {
                                        return $v !== '';
                                    }));
                                }
                                $where_conditions[] = [
                                    'index' => $where_index,
                                    'operator' => $operator,
                                    'parent_val' => $parent_val,
                                    'parent_vals' => $parent_vals
                                ];
                            }
                        }
                        // Iterate rows (skip header if we detected it)
                        $start = $has_header ? 1 : 0;
                        for ($i = $start; $i < count($rows); $i++) {
                            $row = $rows[$i];
                            if (!is_array($row) || empty($row)) {
                                continue;
                            }
                            // Filtering by all where conditions
                            $skip = false;
                            foreach ($where_conditions as $cond) {
                                if ($cond['index'] === null || $cond['parent_val'] === '') {
                                    continue;
                                }
                                $cell = isset($row[$cond['index']]) ? trim($row[$cond['index']]) : '';
                                $match = false;
                                if ($cond['operator'] === 'IN') {
                                    $match = in_array($cell, $cond['parent_vals'], true);
                                } elseif ($cond['operator'] === 'LIKE') {
                                    $match = ($cell !== '' && stripos($cell, $cond['parent_val']) !== false);
                                } else {
                                    // =, >, < (note: >/< as string compare; convert if numeric)
                                    if (is_numeric($cell) && is_numeric($cond['parent_val'])) {
                                        switch ($cond['operator']) {
                                            case '>':
                                                $match = ($cell > $cond['parent_val']);
                                                break;
                                            case '<':
                                                $match = ($cell < $cond['parent_val']);
                                                break;
                                            default:
                                                $match = ($cell === $cond['parent_val']);
                                        }
                                    } else {
                                        $match = ($cell === $cond['parent_val']);
                                    }
                                }
                                if (! $match) {
                                    $skip = true;
                                    break;
                                }
                            }
                            if ($skip) {
                                continue;
                            }
                            // Pick the display value (by configured column if present, else first column)
                            if ($col_index !== null) {
                                $val = isset($row[$col_index]) ? trim($row[$col_index]) : '';
                            } else {
                                $val = isset($row[0]) ? trim($row[0]) : '';
                            }
                            if ($val !== '') {
                                $key_val = $val;
                                if (
                                    !empty($item['yeekit_chained_db_column_key']) &&
                                    $item['yeekit_chained_db_column_key'] === 'yes' &&
                                    !empty($item['yeekit_chained_db_column_key_data']) &&
                                    isset($header)
                                ) {
                                    $key_col = $item['yeekit_chained_db_column_key_data'];
                                    $key_index = array_search($key_col, $header);
                                    if ($key_index !== false && isset($row[$key_index])) {
                                        $key_val = trim($row[$key_index]);
                                    }
                                }
                                $options[] = [
                                    'value' => sanitize_text_field($key_val),
                                    'label' => esc_html($val)
                                ];
                            }
                        }
                        // Remove duplicates like DISTINCT
                        if (!empty($options)) {
                            $options = array_map('unserialize', array_unique(array_map('serialize', $options)));
                            // Limit to 200 (same as database)
                            $options = array_slice($options, 0, 1000);
                        }
                    }
                }
            }
            // Database source
            if (
                $item['yeekit_chained_source'] === 'database'
                && !empty($item['yeekit_chained_db_table'])
                && !empty($item['yeekit_chained_db_column'])
            ) {
                global $wpdb;
                $table  = esc_sql($item['yeekit_chained_db_table']);
                $column = esc_sql($item['yeekit_chained_db_column']);
                $where_clauses = [];
                $where_values = [];
                if (!empty($data_where)) {
                    foreach ($data_where as $where) {
                        $where_column = !empty($where['yeekit_chained_db_where_column']) ? $where['yeekit_chained_db_where_column'] : '';
                        $operator = isset($where['yeekit_chained_db_where_operator']) ? $where['yeekit_chained_db_where_operator'] : '=';
                        $parent_field_id = !empty($where['yeekit_chained_db_where_parent_field']) ? $where['yeekit_chained_db_where_parent_field'] : '';
                        if ($where_column !== '' && $parent_field_id !== '') {
                            $parent_val = $this->get_default_value_by_id($parent_field_id, $form);
                            if ($parent_val !== '') {
                                if ($operator === 'IN') {
                                    if (!is_array($parent_val)) {
                                        $parent_val = array_map('trim', explode(',', $parent_val));
                                    }
                                    $parent_val = array_values(array_filter(array_map('sanitize_text_field', $parent_val), function ($v) {
                                        return $v !== '';
                                    }));
                                    if (!empty($parent_val)) {
                                        $placeholders = implode(',', array_fill(0, count($parent_val), '%s'));
                                        $where_clauses[] = "{$where_column} IN ($placeholders)";
                                        foreach ($parent_val as $v) {
                                            $where_values[] = $v;
                                        }
                                    }
                                } elseif ($operator === 'LIKE') {
                                    $where_clauses[] = "{$where_column} LIKE %s";
                                    $where_values[] = '%' . $parent_val . '%';
                                } elseif ($operator === '>' || $operator === '<') {
                                    $where_clauses[] = "{$where_column} {$operator} %s";
                                    $where_values[] = $parent_val;
                                } else {
                                    $where_clauses[] = "{$where_column} = %s";
                                    $where_values[] = $parent_val;
                                }
                            }
                        }
                    }
                }
                $where = '';
                $key_column = '';
                if (
                    !empty($item['yeekit_chained_db_column_key']) &&
                    $item['yeekit_chained_db_column_key'] === 'yes' &&
                    !empty($item['yeekit_chained_db_column_key_data'])
                ) {
                    // Mark that a custom key column is required.
                    $key_column = esc_sql($item['yeekit_chained_db_column_key_data']);
                }
                if (!empty($where_clauses)) {
                    $where = 'WHERE ' . implode(' AND ', $where_clauses);
                }
                if ($key_column != "") {
                    $sql = "SELECT DISTINCT {$column}, {$key_column} FROM {$table} {$where} LIMIT 200";
                } else {
                    $sql = "SELECT DISTINCT {$column} FROM {$table} {$where} LIMIT 200";
                }
                // If custom key is enabled
                if (!empty($where_values)) {
                    $results = $wpdb->get_results($wpdb->prepare($sql, ...$where_values),ARRAY_A);
                } else {
                    $results = $wpdb->get_results($sql,ARRAY_A);
                }
                foreach ($results as $row) {
                    if (is_array($row)) {
                        $display = isset($row[$column]) ? trim($row[$column]) : '';
                        $key_val = isset($row[$key_column]) ? trim($row[$key_column]) : $display;
                    } else {
                        $display = trim($row);
                        $key_val = $display;
                    }
                    if ($display !== '') {
                        $options[] = [
                            'value' => sanitize_text_field($key_val),
                            'label' => esc_html($display)
                        ];
                    }
                }
            }
            //type manual
            if (
                $item['yeekit_chained_source'] === 'manual'
                && !empty($item['yeekit_chained_db_wheres_manual'])
            ) {
                $data_where = !empty($item['yeekit_chained_db_wheres_manual']) ? $item['yeekit_chained_db_wheres_manual'] : [];
                foreach ($data_where as $where) {
                    $parent_field_id = !empty($where['yeekit_chained_db_where_parent_field']) ? $where['yeekit_chained_db_where_parent_field'] : '';
                    $item['css_classes'] .= ' field-id-' . sanitize_html_class($item['custom_id']);
                    // Add parent field CSS classes for each where condition
                    if (!empty($where['yeekit_chained_db_where_parent_field'])) {
                        $item['css_classes'] .= ' yeekit-cs-parent-' . sanitize_html_class($where['yeekit_chained_db_where_parent_field']);
                    }
                }
            }
            //change select
            if ($item['yeekit_chained_source'] === '' && !empty($item['field_options'])) {
                $lines = preg_split('/\r\n|\r|\n/', $item['field_options']);
                foreach ($lines as $line) {
                    $line = trim($line);
                    if ($line !== '') {
                        $options[] = [
                            'value' => sanitize_title($line),
                            'label' => esc_html($line)
                        ];
                    }
                }
            }
            // Convert options array to value|label pairs, newline-delimited
            if (!empty($options)) {
                $lines = [];
                foreach ($options as $opt) {
                    $val = isset($opt['value']) ? $opt['value'] : '';
                    $lab = isset($opt['label']) ? $opt['label'] : '';
                    if ($val !== '' || $lab !== '') {
                        $lines[] = $lab . '|' . $val;
                    }
                }
                $item['field_options'] = implode("\n", $lines);
            }
        }
        return $item;
    }
    function get_default_value_by_id($parent_field_key, $form)
    {
        $settings = $form->get_settings_for_display();
        if (!empty($settings['form_fields']) && is_array($settings['form_fields'])) {
            $parent_val = $parent_field_key;
            foreach ($settings['form_fields'] as $f) {
                $candidates = [];
                if (isset($f['id'])) $candidates[] = (string)$f['id'];
                if (isset($f['custom_id'])) $candidates[] = (string)$f['custom_id'];
                if (isset($f['name'])) $candidates[] = (string)$f['name'];
                if (isset($f['field_id'])) $candidates[] = (string)$f['field_id'];
                if (in_array((string)$parent_field_key, $candidates, true)) {
                    // Check keys that may contain default/selected/value
                    if (isset($f['value']) && $f['value'] !== '') {
                        $parent_val = $f['value'];
                    } elseif (isset($f['field_value']) && $f['field_value'] !== '') {
                        $parent_val = $f['field_value'];
                    } elseif (isset($f['default']) && $f['default'] !== '') {
                        $parent_val = $f['default'];
                    } elseif (isset($f['selected']) && $f['selected'] !== '') {
                        $parent_val = $f['selected'];
                    } elseif (isset($f['field_default']) && $f['field_default'] !== '') {
                        $parent_val = $f['field_default'];
                    }
                    break;
                }
            }
        }
        return $parent_val;
    }
    function inject_field_controls($array, $controls_to_inject)
    {
        $keys = array_keys($array);
        $key_index = array_search('required', $keys) + 1;
        return array_merge(
            array_slice($array, 0, $key_index, true),
            $controls_to_inject,
            array_slice($array, $key_index, null, true)
        );
    }
}
new Yeekit_EL_CS_Backend;
