(function ($) {
    "use strict";
    $(document).ready(function () {
        // handle one parent select change: find children and load via AJAX
        function handleSelectChange($select) {
            var $form = $select.closest('form');
            var formId = $form.find('input[name="form_id"]').val() || 0;
            var postId = $form.find('input[name="post_id"]').val() || 0;
            var $wrapper = $select.closest('.elementor-field, .elementor-field-group, .elementor-field-subgroup');
            // get parentId from wrapper class "field-id-xxx"
            var parentId = '';
            var wrapperClasses = ($wrapper.attr('class') || '').split(/\s+/);
            $.each(wrapperClasses, function (i, c) {
                if (c.indexOf('field-id-') === 0) {
                    parentId = c.replace('field-id-', '');
                }
            });
            if (!parentId) return;
            // get parent value
            var parentVal = $select.val();
            // find children (class can be on wrapper or on select)
            var $children = $('.elementor-form .yeekit-cs-parent-' + parentId);
            if (!$children.length) return;
            $children.each(function () {
                var $childSelect = $(this);
                var $childWrapper = $childSelect;
                // find child fieldId from wrapper or select class "field-id-xxx"
                var fieldId = '';
                var childWrapperClasses = ($childWrapper.attr('class') || '').split(/\s+/);
                $.each(childWrapperClasses, function (i, c) {
                    if (c.indexOf('field-id-') === 0) {
                        fieldId = c.replace('field-id-', '');
                    }
                });
                if (!fieldId) return;
                // find form/post id for this child (fallback to parent's form/post)
                var $formForChild = $childSelect.closest('form');
                var formIdChild = $formForChild.find('input[name="form_id"]').val() || formId;
                var postIdChild = $formForChild.find('input[name="post_id"]').val() || postId;
                // collect all parent values for this child
                var parentValues = {};
                var childClasses = ($childWrapper.attr('class') || '').split(/\s+/).concat(($childSelect.attr('class') || '').split(/\s+/));
                $.each(childClasses, function (i, c) {
                    if (c.indexOf('yeekit-cs-parent-') === 0) {
                        var pid = c.replace('yeekit-cs-parent-', '');
                        // Find parent field wrapper
                        var $parentWrapper = $('.elementor-form .field-id-' + pid);
                        // Detect input type inside wrapper (select, radio, checkbox)
                        var $pSelect = null;
                        // PRIORITY: select > checked radio > checked checkbox
                        if ($parentWrapper.find('select').length) {
                            $pSelect = $parentWrapper.find('select');
                        } else if ($parentWrapper.find('input[type="radio"]').length) {
                            $pSelect = $parentWrapper.find('input[type="radio"]:checked');
                        } else if ($parentWrapper.find('input[type="checkbox"]').length) {
                            // For multiple checkbox, collect all checked
                            var $checked = $parentWrapper.find('input[type="checkbox"]:checked');
                            if ($checked.length) {
                                // Create a pseudo element to store multiple values
                                $pSelect = $('<div>').data('values', $checked.map(function () { return $(this).val(); }).get());
                            } else {
                                $pSelect = $('<div>').data('values', []);
                            }
                        }
                        // If no matching element, skip
                        if (!$pSelect || !$pSelect.length) {
                            return;
                        }
                        // Store parent value(s)
                        if ($pSelect.is('select') || $pSelect.is('input[type="radio"]')) {
                            parentValues[pid] = $pSelect.val();
                        } else {
                            // Checkbox multiple values
                            parentValues[pid] = $pSelect.data('values');
                        }
                    }
                });
                // ajax to get options
                $.ajax({
                    url: yeekitChained_el.ajaxurl,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        action: 'yeekit_cs_get_datas',
                        nonce: yeekitChained_el.nonce,
                        field_id: fieldId,
                        form_id: formIdChild,
                        post_id: postIdChild,
                        parent_values: parentValues
                    },
                    beforeSend: function () {
                        $childSelect.find("input,select").prop('disabled', true).addClass('loading');
                    },
                    success: function (response) {
                        if (response && response.success && response.data) {
                            $.each(response.data, function (fieldId, options) {
                                var $wrapper  = $('.elementor-form .field-id-' + fieldId);
                                var $select   = $wrapper.closest('.elementor-field-type-select');
                                var $radios   = $wrapper.closest('.elementor-field-type-radio');
                                var $checkbox = $wrapper.closest('.elementor-field-type-checkbox');
                                if ($select.length) {
                                    var $select_input = $select.find('select');
                                    var currentVal = $select.val();
                                    $select_input.empty().append('<option value="">' + yeekitChained_el.i18n_select + '</option>');
                                    $.each(options, function (i, val) {
                                        var opt = $('<option>', { value: val.value, text: val.label });
                                        if (currentVal && currentVal == val.value) {
                                            opt.prop('selected', true);
                                        }
                                        $select_input.append(opt);
                                    });
                                    if ($select_input.val() && !$select_input.data('triggered-once')) {
                                        $select_input.data('triggered-once', true);
                                        $select_input.trigger('change');
                                    }
                                } else if ($radios.length) {
                                    var name = $radios.find('input').first().attr('name');
                                    if (!name) {
                                        name = 'form_fields[' + fieldId + ']';
                                    }
                                    var html = '';
                                    $.each(options, function (i, val) {
                                        html += `<span class="elementor-field-option">
                                                    <input type="radio" value="${val.value}" name="${name}">
                                                    <label>${val.value}</label>
                                                </span>`
                                    });
                                    $wrapper.html(html);
                                    // Auto-trigger change once if a radio is already checked
                                    var $checkedRadio = $wrapper.find('input[type="radio"]:checked');
                                    if ($checkedRadio.length && !$wrapper.data('triggered-once')) {
                                        $wrapper.data('triggered-once', true);
                                        $checkedRadio.first().trigger('change');
                                    }
                                } else if ($checkbox.length) {
                                    var name = $checkbox.find('input').first().attr('name');
                                    if (!name) {
                                        name = 'form_fields[' + fieldId + '][]';
                                    }
                                    var html = '';
                                    $.each(options, function (i, val) {
                                        html += `<span class="elementor-field-option">
                                                    <input type="checkbox" value="${val.value}" id="form-field-year-${i}" name="${name}">
                                                    <label for="form-field-year-${i}">${val.value}</label>
                                                </span>`;
                                    });
                                    $wrapper.html(html);
                                    // Auto-trigger change once if any checkbox is already checked
                                    var $checkedCheckbox = $wrapper.find('input[type="checkbox"]:checked');
                                    if ($checkedCheckbox.length && !$wrapper.data('triggered-once')) {
                                        $wrapper.data('triggered-once', true);
                                        $checkedCheckbox.first().trigger('change');
                                    }
                                }
                            });
                        }
                    },
                    complete: function () {
                        $childSelect.find("input, select").prop('disabled', false).removeClass('loading');
                        console.log(1);
                    },
                    error: function (xhr, status, err) {
                        $childSelect.find("input, select").prop('disabled', false).removeClass('loading');
                    }
                });
            });
        }
        // register change handler FIRST (select, radio, checkbox)
        $(document).on('change', '.elementor-form select, .elementor-form input[type="radio"], .elementor-form input[type="checkbox"]', function () {
            handleSelectChange($(this));
        });
        // on DOM ready: find selects that already have a value and are parents, then call handler
        $('.elementor-form select, .elementor-form input[type="radio"], .elementor-form input[type="checkbox"]').each(function () {
            var $this = $(this);
            // For radio / checkbox, only care if checked
            if ($this.is('input[type="radio"], input[type="checkbox"]')) {
                if (!$this.is(':checked')) {
                    return;
                }
            } else {
                // For select, skip if no value
                if (!$this.val()) return;
            }
            var $wrapper = $this.closest('.elementor-field-subgroup, .elementor-field');
            var wrapperClasses = ($wrapper.attr('class') || '').split(/\s+/);
            var parentId = '';
            $.each(wrapperClasses, function (i, c) {
                if (c.indexOf('field-id-') === 0) {
                    parentId = c.replace('field-id-', '');
                }
            });
            if (!parentId) return;
             console.log(parentId);
            var $children = $('.elementor-form .yeekit-cs-parent-' + parentId + ' select, .elementor-form .yeekit-cs-parent-' + parentId + ' input');
            console.log($children);
            if ($children.length) {
                handleSelectChange($this);
            }
        });
    });
})(jQuery);