(function($) {

    // check for centralHubb.sdk
    if (typeof $.fn.centralHubb  === 'undefined') {
        $.fn.centralHubb = {
            sdk : {}
        };
    }

    // centralHubbb.sdk.placements
    $.fn.centralHubb.sdk.placements = function( elements, options ) {

        // define options
        options = $.extend( {}, {}, options );

        // define plugin
        let plugin = {
            baseUrl: null,
            placementObjects : [],
            preDefinedData : {},
            clickFlag: false,
            init : function()
            {
                // define self
                let self = this;

                //  check for phpVars.apiBaseUrl
                if (typeof phpVars.apiBaseUrl != 'undefined') {

                    // set base url
                    this.baseUrl = phpVars.apiBaseUrl;
                }

                // set preDefinedData
                this.preDefinedData = {

                };

                // initPlacements
                self.initPlacements();

                // initEvents
                self.initEvents();
            },
            initPlacements : function()
            {
                // define self
                let self = this;

                // loop over elements argument
                elements.each(function() {

                    // define element
                    let el = $(this);

                    // append placementObject ids
                    self.placementObjects.push({
                        id : el.attr('data-id'),
                    });
                });

                // initBanners
                this.initBanners();
            },
            initBanners : function()
            {
                // define self
                let self = this;

                // define url
                let url = self.baseUrl + '/analytics/placeholders/placements';

                // set tokens
                let tokens = [];

                // check for placementObjects
                if(self.placementObjects && self.placementObjects.length) {

                    // loop over placementObjects
                    for (let i in self.placementObjects) {

                        // push token to array
                        tokens.push(self.placementObjects[i].id);
                    }
                }

                // set preDefinedData.Tokens
                self.preDefinedData.tokens = tokens.join(',');

                // request placements
                $.ajax({
                    url: url,
                    data: self.preDefinedData,
                    type: 'get'
                }).done(function(response) {

                    // check for data
                    if(response.data) {

                        // loop over data
                        $.each(response.data, function (placeholderId, banners) {

                            // placeRotateBanners
                            self.placeRotateBanners(placeholderId, banners);
                        });
                    }

                });
            },
            initEvents : function() {

                // define self
                let self = this;

                // onClick central-hubb-image-playlist a
                $(document).on("click", '.central-hubb-image-playlist a', function(event) {

                    event.preventDefault();
                    event.stopPropagation();

                    // prevent default
                    event.preventDefault();

                    // define href
                    let href = $(this).attr('href');

                    // define target
                    let target = $(this).attr('target');

                    // define token
                    let token = $(this).closest('.central-hubb-image-playlist').attr('data-placement');

                    // track click
                    self.trackClick(token, href, target);

                    // return false
                    return false;

                });
            },
            trackImpression : function(tokens) {

                // set preDefinedData.type
                this.preDefinedData.type = 'image-impression';

                // set preDefinedData.tokens
                this.preDefinedData.tokens = tokens;

                // request:post /analytics/events : impression
                $.ajax({
                    url: this.baseUrl + '/analytics/events',
                    type: 'post',
                    data: this.preDefinedData
                }).done(function(response) {

                    // debug response
                    // console.log(response);
                });
            },
            trackClick : function(tokens, redirectUrl, redirectTarget) {

                // set preDefinedData.type
                this.preDefinedData.type = 'image-click';

                // set preDefinedData.tokens
                this.preDefinedData.tokens = tokens;

                // check redirectTarget
                if(redirectTarget === '_blank') {

                    // open url in new tab
                    window.open(redirectUrl, redirectTarget);

                    // request:post /analytics/events : click
                    $.ajax({
                        url: this.baseUrl + '/analytics/events',
                        type: 'post',
                        data: this.preDefinedData
                    }).done(function(response) {

                        // debug response
                        // console.log(response);
                    });

                } else {

                    // request:post /analytics/events : click
                    $.ajax({
                        url: this.baseUrl + '/analytics/events',
                        type: 'post',
                        data: this.preDefinedData
                    }).done(function(response) {

                        // debug response
                        // console.log(response);

                        // open url in parent tab
                        window.open(redirectUrl, redirectTarget);
                    });
                }
            },
            placeRotateBanners : function(placeholderId, banners)
            {
                // define self
                let self = this;

                // define random banner
                let banner = banners[Math.floor(Math.random() * banners.length)];

                // define bannerHtml
                let bannerHtml = '<a href="' + banner.href + '" target="' + banner.link_type + '"><img src="' + banner.src + '"></a>';

                // set placeholder html
                $('div[data-id="' + placeholderId + '"]').html(bannerHtml);

                // set placeholder data-placement attribute = placement token
                $('div[data-id="' + placeholderId + '"]').attr('data-placement', banner.placement_token);

                // track impression
                self.trackImpression(banner.placement_token);

                // check display_timer
                if(banner.display_timer != 0) {

                    // set count down
                    self.countDown(placeholderId, banner.display_timer, banners);
                }
            },
            countDown : function(placeholderId, delayTimer, banners)
            {
                // define self
                let self = this;

                // define i
                let i = delayTimer / 1000;

                // define type
                let type = 'placeholder_objects';

                // clearInterval
                clearInterval(window.document[type+'_'+placeholderId]);

                // setInterval
                window.document[type+'_'+placeholderId] = setInterval(function() {

                    // placeRotateBanners
                    self.placeRotateBanners(placeholderId, banners)
                }, delayTimer);
            },
        };

        // plugin.init
        return plugin.init();
    };

    // init centralHubb.sdk.placements
    $.fn.centralHubb.sdk.placements($('.central-hubb-image-playlist'));

})( jQuery );
