<?php
if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
$api_key = get_post_meta($post->id(), '_mailchimp_api_key', true);

// Fetch all Mailchimp fields
$mailchimp_response = class_ccf7_mailchimp_Integration_object()->ccf7mc_mailchimp_api_response('/merge-fields', $api_key);

$mailchimp_fields = isset($mailchimp_response['fields']) ? $mailchimp_response['fields'] : []; // Ensure we only get fields


// Get the Contact Form 7 form content and extract the shortcodes
$cf7_shortcodes = class_ccf7_mailchimp_Integration_object()->ccf7mc_get_contact_from7_fields($post->id());

// Retrieve saved Mailchimp settings
$saved_mailchimp_settings = get_post_meta($post->ID(), '_mailchimp_field_mappings', true) ?: []; // Default to empty array if not set

// Create a nonce field for security
$nonce = wp_create_nonce('save_mailchimp_settings');

if (class_ccf7_mailchimp_Integration_object()->ccf7mc_verify_mailchimp_api_key($api_key)) {
?>

    <!-- WordPress form-table class for default styling -->
    <table class="form-table params-mailchimp">
        <thead>
            <tr>
                <th><?php esc_html_e('Mailchimp Field', 'centous-integration-for-contact-form-7-and-mailchimp'); ?></th>
                <th><?php esc_html_e('Contact Form 7 Field', 'centous-integration-for-contact-form-7-and-mailchimp'); ?></th>
            </tr>
        </thead>
        <tbody>
            <!-- Nonce field -->
            <input type="hidden" name="mailchimp_settings_nonce" value="<?php echo esc_attr($nonce); ?>">

            <?php foreach ($mailchimp_fields as $mailchimp_field) :
                // Access the necessary properties from each field
                $field_key = $mailchimp_field['tag']; // Assuming 'tag' is used as the key
                $saved_value = isset($saved_mailchimp_settings[$field_key]) ? $saved_mailchimp_settings[$field_key] : '';
            ?>
                <tr>
                    <td><?php echo esc_html($mailchimp_field['name']); ?></td> <!-- Display the field name -->
                    <td>
                        <!-- WordPress default styling for selects -->
                        <select id="mailchimp_settings_<?php echo esc_attr($field_key); ?>" name="mailchimp_settings[<?php echo esc_attr($field_key); ?>]" class="regular-text">
                            <option value=""><?php esc_html_e('Select a form field', 'centous-integration-for-contact-form-7-and-mailchimp'); ?></option>
                            <?php foreach ($cf7_shortcodes as $shortcode) : ?>
                                <option value="<?php echo esc_attr($shortcode); ?>" <?php selected($saved_value, $shortcode); ?>>
                                    <?php echo esc_html($shortcode); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php
}
?>