<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\RebelCode\WordPress\Http\Middleware;

use CelerSearch\Vendor\Psr\Http\Message\RequestInterface;
use CelerSearch\Vendor\Psr\Http\Message\ResponseInterface;
use CelerSearch\Vendor\RebelCode\Psr7\MimeType;
use CelerSearch\Vendor\RebelCode\Psr7\Utils;
use CelerSearch\Vendor\RebelCode\WordPress\Http\Middleware;
/**
 * Prepares requests that contain a body, adding the Content-Length and Content-Type headers.
 * @internal
 */
class PrepareBody extends Middleware
{
    /** @inheritDoc */
    public function handle(RequestInterface $request) : ResponseInterface
    {
        // Don't do anything if the request has no body
        if ($request->getBody()->getSize() === 0) {
            return $this->next($request);
        }
        $modify = [];
        // Add a default content-type if possible.
        if (!$request->hasHeader('Content-Type')) {
            if ($uri = $request->getBody()->getMetadata('uri')) {
                if (\is_string($uri) && ($type = MimeType::fromFilename($uri))) {
                    $modify['set_headers']['Content-Type'] = $type;
                }
            }
        }
        // Add a default content-length or transfer-encoding header.
        if (!$request->hasHeader('Content-Length') && !$request->hasHeader('Transfer-Encoding')) {
            $size = $request->getBody()->getSize();
            if ($size !== null) {
                $modify['set_headers']['Content-Length'] = $size;
            } else {
                $modify['set_headers']['Transfer-Encoding'] = 'chunked';
            }
        }
        return $this->next(Utils::modifyRequest($request, $modify));
    }
}
