<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\RebelCode\WordPress\Http\Middleware;

use CelerSearch\Vendor\Psr\Http\Message\RequestInterface;
use CelerSearch\Vendor\Psr\Http\Message\ResponseInterface;
use CelerSearch\Vendor\RebelCode\WordPress\Http\Exception\BadResponseException;
use CelerSearch\Vendor\RebelCode\WordPress\Http\Middleware;
/**
 * A middleware handler that throws exceptions for responses with 4xx or 5xx status codes.
 * @internal
 */
class HttpErrorsToExceptions extends Middleware
{
    /**
     * @inheritDoc
     */
    public function handle(RequestInterface $request) : ResponseInterface
    {
        $response = $this->next($request);
        $code = $response->getStatusCode();
        if ($code < 400) {
            return $response;
        }
        throw BadResponseException::create($request, $response);
    }
}
