<?php

namespace CelerSearch\Vendor\Http\Discovery\Strategy;

use CelerSearch\Vendor\Http\Client\HttpAsyncClient;
use CelerSearch\Vendor\Http\Client\HttpClient;
use CelerSearch\Vendor\Http\Mock\Client as Mock;
/**
 * Find the Mock client.
 *
 * @author Sam Rapaport <me@samrapdev.com>
 * @internal
 */
final class MockClientStrategy implements DiscoveryStrategy
{
    public static function getCandidates($type)
    {
        if (\is_a(HttpClient::class, $type, \true) || \is_a(HttpAsyncClient::class, $type, \true)) {
            return [['class' => Mock::class, 'condition' => Mock::class]];
        }
        return [];
    }
}
