<?php

namespace CelerSearch\Vendor\Http\Discovery\Strategy;

use CelerSearch\Vendor\Psr\Http\Message\RequestFactoryInterface;
use CelerSearch\Vendor\Psr\Http\Message\ResponseFactoryInterface;
use CelerSearch\Vendor\Psr\Http\Message\ServerRequestFactoryInterface;
use CelerSearch\Vendor\Psr\Http\Message\StreamFactoryInterface;
use CelerSearch\Vendor\Psr\Http\Message\UploadedFileFactoryInterface;
use CelerSearch\Vendor\Psr\Http\Message\UriFactoryInterface;
/**
 * @internal
 *
 * @author Tobias Nyholm <tobias.nyholm@gmail.com>
 *
 * Don't miss updating src/Composer/Plugin.php when adding a new supported class.
 */
final class CommonPsr17ClassesStrategy implements DiscoveryStrategy
{
    /**
     * @var array
     */
    private static $classes = [RequestFactoryInterface::class => ['CelerSearch\\Vendor\\Phalcon\\Http\\Message\\RequestFactory', 'CelerSearch\\Vendor\\Nyholm\\Psr7\\Factory\\Psr17Factory', 'CelerSearch\\Vendor\\GuzzleHttp\\Psr7\\HttpFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Diactoros\\RequestFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Guzzle\\RequestFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Slim\\RequestFactory', 'CelerSearch\\Vendor\\Laminas\\Diactoros\\RequestFactory', 'CelerSearch\\Vendor\\Slim\\Psr7\\Factory\\RequestFactory', 'CelerSearch\\Vendor\\HttpSoft\\Message\\RequestFactory'], ResponseFactoryInterface::class => ['CelerSearch\\Vendor\\Phalcon\\Http\\Message\\ResponseFactory', 'CelerSearch\\Vendor\\Nyholm\\Psr7\\Factory\\Psr17Factory', 'CelerSearch\\Vendor\\GuzzleHttp\\Psr7\\HttpFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Diactoros\\ResponseFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Guzzle\\ResponseFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Slim\\ResponseFactory', 'CelerSearch\\Vendor\\Laminas\\Diactoros\\ResponseFactory', 'CelerSearch\\Vendor\\Slim\\Psr7\\Factory\\ResponseFactory', 'CelerSearch\\Vendor\\HttpSoft\\Message\\ResponseFactory'], ServerRequestFactoryInterface::class => ['CelerSearch\\Vendor\\Phalcon\\Http\\Message\\ServerRequestFactory', 'CelerSearch\\Vendor\\Nyholm\\Psr7\\Factory\\Psr17Factory', 'CelerSearch\\Vendor\\GuzzleHttp\\Psr7\\HttpFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Diactoros\\ServerRequestFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Guzzle\\ServerRequestFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Slim\\ServerRequestFactory', 'CelerSearch\\Vendor\\Laminas\\Diactoros\\ServerRequestFactory', 'CelerSearch\\Vendor\\Slim\\Psr7\\Factory\\ServerRequestFactory', 'CelerSearch\\Vendor\\HttpSoft\\Message\\ServerRequestFactory'], StreamFactoryInterface::class => ['CelerSearch\\Vendor\\Phalcon\\Http\\Message\\StreamFactory', 'CelerSearch\\Vendor\\Nyholm\\Psr7\\Factory\\Psr17Factory', 'CelerSearch\\Vendor\\GuzzleHttp\\Psr7\\HttpFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Diactoros\\StreamFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Guzzle\\StreamFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Slim\\StreamFactory', 'CelerSearch\\Vendor\\Laminas\\Diactoros\\StreamFactory', 'CelerSearch\\Vendor\\Slim\\Psr7\\Factory\\StreamFactory', 'CelerSearch\\Vendor\\HttpSoft\\Message\\StreamFactory'], UploadedFileFactoryInterface::class => ['CelerSearch\\Vendor\\Phalcon\\Http\\Message\\UploadedFileFactory', 'CelerSearch\\Vendor\\Nyholm\\Psr7\\Factory\\Psr17Factory', 'CelerSearch\\Vendor\\GuzzleHttp\\Psr7\\HttpFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Diactoros\\UploadedFileFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Guzzle\\UploadedFileFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Slim\\UploadedFileFactory', 'CelerSearch\\Vendor\\Laminas\\Diactoros\\UploadedFileFactory', 'CelerSearch\\Vendor\\Slim\\Psr7\\Factory\\UploadedFileFactory', 'CelerSearch\\Vendor\\HttpSoft\\Message\\UploadedFileFactory'], UriFactoryInterface::class => ['CelerSearch\\Vendor\\Phalcon\\Http\\Message\\UriFactory', 'CelerSearch\\Vendor\\Nyholm\\Psr7\\Factory\\Psr17Factory', 'CelerSearch\\Vendor\\GuzzleHttp\\Psr7\\HttpFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Diactoros\\UriFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Guzzle\\UriFactory', 'CelerSearch\\Vendor\\Http\\Factory\\Slim\\UriFactory', 'CelerSearch\\Vendor\\Laminas\\Diactoros\\UriFactory', 'CelerSearch\\Vendor\\Slim\\Psr7\\Factory\\UriFactory', 'CelerSearch\\Vendor\\HttpSoft\\Message\\UriFactory']];
    public static function getCandidates($type)
    {
        $candidates = [];
        if (isset(self::$classes[$type])) {
            foreach (self::$classes[$type] as $class) {
                $candidates[] = ['class' => $class, 'condition' => [$class]];
            }
        }
        return $candidates;
    }
}
