<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Http\Serialize;

/** @internal */
interface SerializerInterface
{
    /**
     * Serialize data into string.
     *
     * @param string|int|float|bool|array<mixed>|null $data
     *
     * @throws \JsonException
     */
    public function serialize(mixed $data) : string;
    /**
     * Unserialize the given string.
     *
     * @return string|int|float|bool|array<mixed>|null
     *
     * @throws \JsonException
     */
    public function unserialize(string $string) : mixed;
}
