<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Endpoints\Delegates;

use CelerSearch\Vendor\Meilisearch\Contracts\CancelTasksQuery;
use CelerSearch\Vendor\Meilisearch\Contracts\DeleteTasksQuery;
use CelerSearch\Vendor\Meilisearch\Contracts\Task;
use CelerSearch\Vendor\Meilisearch\Contracts\TasksQuery;
use CelerSearch\Vendor\Meilisearch\Contracts\TasksResults;
use CelerSearch\Vendor\Meilisearch\Endpoints\Tasks;
/** @internal */
trait HandlesTasks
{
    protected Tasks $tasks;
    public function getTask(int $uid) : Task
    {
        return $this->tasks->get($uid);
    }
    public function getTasks(?TasksQuery $options = null) : TasksResults
    {
        $response = $this->tasks->all($options?->toArray() ?? []);
        return new TasksResults($response);
    }
    public function deleteTasks(?DeleteTasksQuery $options = null) : Task
    {
        return $this->tasks->deleteTasks($options);
    }
    public function cancelTasks(?CancelTasksQuery $options = null) : Task
    {
        return $this->tasks->cancelTasks($options);
    }
}
