<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Endpoints\Delegates;

use CelerSearch\Vendor\Meilisearch\Contracts\Http;
use CelerSearch\Vendor\Meilisearch\Contracts\MultiSearchFederation;
use CelerSearch\Vendor\Meilisearch\Contracts\SearchQuery;
/** @internal */
trait HandlesMultiSearch
{
    protected Http $http;
    /**
     * @param list<SearchQuery> $queries
     */
    public function multiSearch(array $queries = [], ?MultiSearchFederation $federation = null)
    {
        $body = [];
        foreach ($queries as $query) {
            $body[] = $query->toArray();
        }
        $payload = ['queries' => $body];
        if (null !== $federation) {
            $payload['federation'] = (object) $federation->toArray();
        }
        return $this->http->post('/multi-search', $payload);
    }
}
