<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Endpoints\Delegates;

use CelerSearch\Vendor\Meilisearch\Contracts\ChatWorkspacesResults;
use CelerSearch\Vendor\Meilisearch\Endpoints\ChatWorkspaces;
/** @internal */
trait HandlesChatWorkspaces
{
    private ChatWorkspaces $chats;
    /**
     * List all chat workspaces.
     */
    public function getChatWorkspaces() : ChatWorkspacesResults
    {
        return $this->chats->listWorkspaces();
    }
    /**
     * Get a specific chat workspace instance.
     */
    public function chatWorkspace(string $workspaceName) : ChatWorkspaces
    {
        return $this->chats->workspace($workspaceName);
    }
}
