<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Endpoints\Delegates;

use CelerSearch\Vendor\Meilisearch\Contracts\BatchesQuery;
use CelerSearch\Vendor\Meilisearch\Contracts\BatchesResults;
use CelerSearch\Vendor\Meilisearch\Endpoints\Batches;
/** @internal */
trait HandlesBatches
{
    protected Batches $batches;
    public function getBatch(int $uid) : array
    {
        return $this->batches->get($uid);
    }
    public function getBatches(?BatchesQuery $options = null) : BatchesResults
    {
        $query = null !== $options ? $options->toArray() : [];
        $response = $this->batches->all($query);
        return new BatchesResults($response);
    }
}
