<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Endpoints;

use CelerSearch\Vendor\Meilisearch\Contracts\ChatWorkspacesResults;
use CelerSearch\Vendor\Meilisearch\Contracts\Endpoint;
use CelerSearch\Vendor\Meilisearch\Contracts\Http;
use CelerSearch\Vendor\Meilisearch\Endpoints\Delegates\HandlesChatWorkspaceSettings;
/** @internal */
class ChatWorkspaces extends Endpoint
{
    use HandlesChatWorkspaceSettings;
    protected const PATH = '/chats';
    /**
     * @var non-empty-string|null
     */
    private ?string $workspaceName;
    public function __construct(Http $http, ?string $workspaceName = null)
    {
        $this->workspaceName = $workspaceName;
        parent::__construct($http);
    }
    public function listWorkspaces() : ChatWorkspacesResults
    {
        $response = $this->http->get(self::PATH);
        return new ChatWorkspacesResults($response);
    }
    public function workspace(string $workspaceName) : self
    {
        return new self($this->http, $workspaceName);
    }
}
