<?php

declare (strict_types=1);
namespace CelerSearch\Vendor\Meilisearch\Contracts\TaskDetails;

use CelerSearch\Vendor\Meilisearch\Contracts\TaskDetails;
/**
 * @implements TaskDetails<array{
 *     swaps: array<array{indexes: mixed, rename: bool}>
 * }>
 * @internal
 */
final class IndexSwapDetails implements TaskDetails
{
    /**
     * @param array<array{indexes: mixed, rename: bool}> $swaps
     */
    public function __construct(public readonly array $swaps)
    {
    }
    public static function fromArray(array $data) : self
    {
        return new self($data['swaps']);
    }
}
